##Copyright 2011 William Miller	-	kronos37@gmail.com
##
##This file is part of Sudoku.
##
##Sudoku is free software: you can redistribute it and/or modify
##it under the terms of the GNU General Public License as published by
##the Free Software Foundation, either version 3 of the License, or
##(at your option) any later version.
##
##Sudoku is distributed in the hope that it will be useful,
##but WITHOUT ANY WARRANTY; without even the implied warranty of
##MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
##GNU General Public License for more details.
##
##You should have received a copy of the GNU General Public License
##along with Sudoku.  If not, see <http://www.gnu.org/licenses/>.

import Sudoku
import pickle
import os.path

def main():
	"""
		Main menu for the program
	"""
	option = -1
	print "Welcome to the Sudoku Solver"
	
	while (option != 4):
		print "Main Menu:"
		print "1:\tBlank Puzzle \n2:\tNew Puzzle \n3:\tLoad Puzzle \n4:\tQuit"
		try:
			option = int(raw_input())
			while (option <= 0 or option > 4):
				print "Invalid Option, please select something between 1 and 3"
				option = int(raw_input())
		except ValueError:
			print "Please enter an integer value"
		else:
			if (option == 1):
				newGame()
			elif (option == 2):
				puzzle = generateNewPuzzle()
				gameMenu(puzzle)
			elif (option == 3):
				loadPuzzle()

def gameMenu(puzzle):
	"""
		ingame menu for a puzzle
	"""
	option = -1
	
	while (option != 10):    #Continues until user selects quit
		puzzle.printPuzzle()
		print "1:\tAdd Value \n2:\tDelete Value \n3:\tCheck Values \n4:\tFind Possible values\
		\n5:\tFind Patterns \n6:\tChange Representations \n7:\tSave \n8:\tModify Possible Values\
		\n9:\tPrint possible for square\n10:\tQuit to Main Menu"
		try:
			option = int(raw_input())
			while (option <= 0 or option > 10):      #Checks for input outside of range
				print "invalid option, please select something between 1 and 10"
				option = int(raw_input())
		except ValueError:
			print "Please enter integer value"
		else:
			if (option == 1):
				addValue(puzzle)
			elif (option == 2):
				deleteValue(puzzle)
			elif (option == 3):
				checkPuzzle(puzzle)
			elif (option == 4):
				checkPossible(puzzle)
			elif (option == 5):
				patternMenu(puzzle)
			elif (option == 7):
				savePuzzle(puzzle)
			elif (option == 6):
				representationMenu(puzzle)
			elif (option == 8):
				modifyPossible(puzzle)
			elif (option == 9):
				printPossiblePuzzle(puzzle)

def newGame():
	"""
		Creates a new puzzle of the size indicated and passes it to the ingame menu
	"""
	try:
		newSize = int(raw_input("What size Sudoku? 4, 9 or 16?"))
		while not newSize == 4 and not newSize == 9 and not newSize == 16:
			newSize = int(raw_input("Size can only be 4, 9 or 16"))
		puzzle = Sudoku.Sudoku(newSize)
		gameMenu(puzzle)
	except ValueError:
		print "Please enter integer value"

def addValue(puzzle):
	"""
		Prompts user for the row, column and value to be entered, then updates puzzle
		param: puzzle the Sudoku puzzle
	"""
	try:
		row = int(raw_input("Row: "))
		while row > puzzle.SIZE or row < 1:
			print "Value needs to be between 1 and " + str(puzzle.SIZE)
			row = int(raw_input("Row: "))
		col = int(raw_input("Column: "))
		while col > puzzle.SIZE or col < 1:
			print "Value needs to be between 1 and " + str(puzzle.SIZE)
			col = int(raw_input("Column: "))
		value = int(raw_input("Value: "))
		while value > puzzle.SIZE or value < 1:
			print "Value needs to be between 1 and " + str(puzzle.SIZE)
			value = int(raw_input("Value: "))
	except ValueError:
		print "invalid input"
	else:
		try:
			squareList = puzzle.validateValue(row-1,col-1,value)
			if squareList.__len__() == 0:
				puzzle.addValue(row-1,col-1,value)
			else:
				print "That value is invalid for that square"
		except Exception as e:
			print e

def deleteValue(puzzle):
	"""
		Prompts user for the row and column of the square to be cleared, then updates puzzle
		param: puzzle the Sudoku puzzle
	"""
	try:
		row = int(raw_input("Row: "))
		while row > puzzle.SIZE or row < 1:
			print "Value needs to be between 1 and " + str(puzzle.SIZE)
			value = int(raw_input("Row: "))
		col = int(raw_input("Column: "))
		while col > puzzle.SIZE or col < 1:
			print "Value needs to be between 1 and " + str(puzzle.SIZE)
			value = int(raw_input("Column: "))
	except ValueError:
		print "invalid input"
	else:
		try:
			puzzle.deleteValue(row-1,col-1)
		except Exception as e:
			print e
			
def modifyPossible(puzzle):
	puzzle.manualPossible = True
	try:
		row = int(raw_input("Row: "))
		while row > puzzle.SIZE or row < 1:
			print "Value needs to be between 1 and " + str(puzzle.SIZE)
			row = int(raw_input("Row: "))
		col = int(raw_input("Column: "))
		while col > puzzle.SIZE or col < 1:
			print "Value needs to be between 1 and " + str(puzzle.SIZE)
			col = int(raw_input("Column: "))
	except ValueError:
		print "invalid input"
	else:
		try:
			while True:
				print puzzle.possible[row-1][col-1]
				value = int(raw_input("Value: "))
				while value > puzzle.SIZE or value < 0:
					print "Value needs to be between 1 and " + str(puzzle.SIZE)
					value = int(raw_input("Value: "))
				if value == 0:
					break
				else:
					puzzle.modifyPossible(row-1,col-1,value)
		except ValueError:
			print "invalid input"

def checkPuzzle(puzzle):
	squareList = puzzle.checkPuzzle()
	if squareList.__len__() == 0:
		if puzzle.isComplete():
			print "Victory is yours!"
		else:
			print "Everything correct so far"
	else:
		while squareList.__len__() > 0:
			square = squareList.pop()
			if square[0] == 1:
				print "Row at " + str(square[1] + 1) + " is invalid"
			elif square[0] == 2:
				print "Column at " + str(square[1] + 1) + "is invalid"
			else:
				print "Box at Row " + str(square[1] + 1) + " and Column " + str(square[2] + 1) + " is invalid"
				
	
def checkPossible(puzzle):
	"""
		Prompts the user to select a square, then finds the possible values of that square
	"""
	try:
		puzzle.manualPossible = False
		puzzle.findPossiblePuzzle()
	except Exception as e:
		print e

def printPossible(puzzle):
	"""
		Shows the possible values of a given square, test method for findPossiblePuzzle
	"""
	try:
		row = int(raw_input("Row: "))
		while row > puzzle.SIZE or row < 1:
			print "Value needs to be between 1 and " + str(puzzle.SIZE)
			row = int(raw_input("Row: "))
		col = int(raw_input("Column: "))
		while col > puzzle.SIZE or col < 1:
			print "Value needs to be between 1 and " + str(puzzle.SIZE)
			col = int(raw_input("Column: "))
	except ValueError:
		print "invalid input"
	else:
		try:
			print puzzle.possible[row-1][col-1]
		except Exception as e:
			print e

def printPossiblePuzzle(puzzle):
	"""
		Prints the puzzle, including possible values
	"""
	puzzle.printPossiblePuzzle()

def savePuzzle(puzzle):
	"""
		Saves the puzzle to a text file
	"""
	fileName = raw_input("Please enter file name:")
	#fileName = fileName + ".txt"
	puzzle.savePuzzleAs(fileName)

def loadPuzzle():
	"""
		Loads a puzzle from a text file
		Loads in such a way as to be compatable with old versions
	"""
	try:	#prompts for file name, then uses pickle to load
		fileName = raw_input("Please enter file name:")
		#fileName = fileName + ".txt"
		save = open(fileName, 'r')
		puzzleOld = pickle.load(save)
		save.close()
		puzzle = Sudoku.Sudoku(puzzleOld.SIZE)
		puzzle.puzzle = puzzleOld.puzzle
		gameMenu(puzzle)
	except Exception as e:
		print e

def loadPuzzleFromPath(filePath):
	"""
		Loads a puzzle from a text file
		Loads in such a way as to be compatable with old versions
	"""
	if os.path.isfile(filePath):	#checks if file path exists, if it does loads the file
		save = open(filePath, 'r')
		puzzleOld = pickle.load(save)
		save.close()
		puzzle = Sudoku.Sudoku(puzzleOld.SIZE)
		puzzle.puzzle = puzzleOld.puzzle
		return puzzle
	else:	#if file path doesn't exist, raises an exception
		raise Exception("Invalid File Path")
	

def patternMenu(puzzle): #Not implemented fully yet
	"""
		Menu for finding different patterns in the sudoku
	"""
	option = -1
	puzzle.findPossiblePuzzle()
	
	while (option != 10):    #Continues until user selects quit
		puzzle.printPuzzle()
		print "1:\tSingle Candidate \n2:\tSingle Position\n3:\tCandidate Line \n4:\tNaked Pair\
			\n5:\tHidden Pair\n6:\tNaked Triple\n7:\tHidden Triple \n8:\tX-Wing\
			\n9:\tSwordfish \n10:\tReturn to Game Menu"
		try:
			option = int(raw_input())
			while (option <= 0 or option > 10):      #Checks for input outside of range
				print "invalid option, please select something between 1 and 10"
				option = int(raw_input())
		except ValueError:
			print "Please enter integer value"
		else:
			if (option == 1):
				squareList = puzzle.findSingleCandidate()
				for x in squareList:
					print x
			elif (option == 2):
				squareList = puzzle.findSinglePosition()
				for x in squareList:
					print x
				if squareList.__len__() == 0:
					print "None found"
			elif (option == 3):
				squareList = puzzle.findCandidateLine()
				for x in squareList:
					print x
			elif (option == 4):
				squareList = puzzle.findNakedPair()
				for x in squareList:
					print x
			elif (option == 5):
				squareList = puzzle.findHiddenPair()
				for x in squareList:
					print x
			elif (option == 6):
				squareList = puzzle.findNakedTriple()
				for x in squareList:
					print x
			elif (option == 7):
				squareList = puzzle.findHiddenTriple()
				for x in squareList:
					print x
			elif (option == 8):
				squareList = puzzle.findXWing()
				for x in squareList:
					print x
			elif (option == 9):
				squareList = puzzle.findSwordfish()
				for x in squareList:
					print x

def representationMenu(puzzle):
	"""
		Menu for change the representations
	"""
	option = -1
	print "Different representations of the puzzle"
	print "1:\tRow on y, Column on x, Numbers in field \n2:\tRow on y, Number on x, Columns in field \n3:\tNumbers on y, Columns on x, Rows in the field \n4:\tDon't change"
	try:
		option = int(raw_input())
		while (option <= 0 or option > 4):      #Checks for input outside of range
			print "invalid option, please select something between 1 and 3"
			option = int(raw_input())
	except ValueError:
		print "Please enter integer value"
	else:
		if (option == 1):
			puzzle.changeRepMode(1)
		elif (option == 2):
			puzzle.changeRepMode(2)
		elif (option == 3):
			puzzle.changeRepMode(3)
			
def generateNewPuzzle():
	"""
		Generates a new puzzle using Sudoku Generator
	"""
	import Generator
	Generator.reset()
	puzzleString = Generator.givePuzzle()
	puzzle = Sudoku.Sudoku(9)
	for cell, value in puzzleString.iteritems():
		i = 0
		if cell[0] == 'A':
			i = 0
		elif cell[0] == 'B':
			i = 1
		elif cell[0] == 'C':
			i = 2
		elif cell[0] == 'D':
			i = 3
		elif cell[0] == 'E':
			i = 4
		elif cell[0] == 'F':
			i = 5
		elif cell[0] == 'G':
			i = 6
		elif cell[0] == 'H':
			i = 7
		elif cell[0] == 'I':
			i = 8
		j = int(cell[1]) - 1
		puzzle.puzzle[i][j] = int(value)
	return puzzle

if __name__ == "__main__":
	main()

