##Copyright 2011 ZhaoXiang CAI
##
##This file is part of Sudoku.
##
##Sudoku is free software: you can redistribute it and/or modify
##it under the terms of the GNU General Public License as published by
##the Free Software Foundation, either version 3 of the License, or
##(at your option) any later version.
##
##Sudoku is distributed in the hope that it will be useful,
##but WITHOUT ANY WARRANTY; without even the implied warranty of
##MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
##GNU General Public License for more details.
##
##You should have received a copy of the GNU General Public License
##along with Sudoku.  If not, see <http://www.gnu.org/licenses/>.
import random
import Solver
import time

"use a list of list to represent partial solution"
partialSolution = [[],[],[],[],[],[],[],[],[]]
numOfPlaced = 0
size = 9
grid = ''
finish = False #used to stop the recursive calls after a random solution is found.
"the recursive part of the program. "
"pick a random number from the possible candidates each time and the remove it."
def sudoku(partialSolution, numOfPlaced):
    global finish 
    if numOfPlaced == size**2:
        finish = True
    else:
        possibleNum = getPossibleNum(partialSolution, numOfPlaced)
        if len(possibleNum) != 0: 
            while len(possibleNum) != 0 : #for each possible number in candidates.
                i = int(random.random() * possibleNum.__len__()) #pick a random one and remove it from candidates
                add(partialSolution, numOfPlaced, possibleNum.pop(i)) 
                numOfPlaced = numOfPlaced+1
                sudoku(partialSolution, numOfPlaced) #recursive call
                if not finish:
                    pop(partialSolution, numOfPlaced) #remove the last one if no solution is found
                    numOfPlaced = numOfPlaced-1
                else:
                    break

def add (partialSolution, numOfPlaced, num):
    "add an element to the end of the partial solution"
    partialSolution[numOfPlaced/size].append(num)
    
def pop (partialSolution, numOfPlaced):
    "pop the last element in partial solution."
    if numOfPlaced == 1:
        partialSolution[(numOfPlaced)/size].pop()
    else:
        partialSolution[(numOfPlaced-1)/size].pop()
    

def getPossibleNum(partialSolution, numOfPlaced):
    "get all possible candidates, according to the partial solution and number of elements that have been placed."
    possibleNum = range(1,10)
    if numOfPlaced%size != 0:
        for col in range(numOfPlaced%size): #check the column
            if len(possibleNum)!=0:
                possibleNum.remove(partialSolution[(numOfPlaced-1)/size][col])
        
    if numOfPlaced != 0:
        for row in range((numOfPlaced)/size): #check the row
            if len(possibleNum)!=0:
                if possibleNum.count(partialSolution[row][numOfPlaced%size]) == 1:
                    possibleNum.remove(partialSolution[row][numOfPlaced%size])
    
    #if the next number is in the position4 of a box, check the position2 and position3.
    if (numOfPlaced/size==1 or numOfPlaced/size==4 or numOfPlaced/size==7)\
            and(numOfPlaced%size == 0 or numOfPlaced%size == 3 or numOfPlaced%size == 6)\
                and numOfPlaced !=0: 
        if possibleNum.count(partialSolution[numOfPlaced/size-1][numOfPlaced%size+1])==1:
            possibleNum.remove(partialSolution[numOfPlaced/size-1][numOfPlaced%size+1])
        if possibleNum.count(partialSolution[numOfPlaced/size-1][numOfPlaced%size+2])==1:
            possibleNum.remove(partialSolution[numOfPlaced/size-1][numOfPlaced%size+2])
            
    #if the next number is in the position4 of a box, check the position1 and position3.
    if (numOfPlaced/size==1 or numOfPlaced/size==4 or numOfPlaced/size==7)\
            and(numOfPlaced%size == 1 or numOfPlaced%size == 4 or numOfPlaced%size == 7)\
                and numOfPlaced !=0: 
        if possibleNum.count(partialSolution[numOfPlaced/size-1][numOfPlaced%size+1])==1:
            possibleNum.remove(partialSolution[numOfPlaced/size-1][numOfPlaced%size+1])
        if possibleNum.count(partialSolution[numOfPlaced/size-1][numOfPlaced%size-1])==1:
            possibleNum.remove(partialSolution[numOfPlaced/size-1][numOfPlaced%size-1])
            
    #if the next number is in the position4 of a box, check the position1 and position2.
    if (numOfPlaced/size==1 or numOfPlaced/size==4 or numOfPlaced/size==7)\
            and(numOfPlaced%size == 2 or numOfPlaced%size == 5 or numOfPlaced%size == 8)\
                and numOfPlaced !=0: 
        if possibleNum.count(partialSolution[numOfPlaced/size-1][numOfPlaced%size-2])==1:
            possibleNum.remove(partialSolution[numOfPlaced/size-1][numOfPlaced%size-2])
        if possibleNum.count(partialSolution[numOfPlaced/size-1][numOfPlaced%size-1])==1:
            possibleNum.remove(partialSolution[numOfPlaced/size-1][numOfPlaced%size-1])
            
    #if the next number is in the position4 of a box, check the position 2,3,5,6.
    if (numOfPlaced/size==2 or numOfPlaced/size==5 or numOfPlaced/size==8)\
            and(numOfPlaced%size == 0 or numOfPlaced%size == 3 or numOfPlaced%size == 6)\
                and numOfPlaced !=0: 
        if possibleNum.count(partialSolution[numOfPlaced/size-1][numOfPlaced%size+1])==1:
            possibleNum.remove(partialSolution[numOfPlaced/size-1][numOfPlaced%size+1])
        if possibleNum.count(partialSolution[numOfPlaced/size-1][numOfPlaced%size+2])==1:
            possibleNum.remove(partialSolution[numOfPlaced/size-1][numOfPlaced%size+2])
        if possibleNum.count(partialSolution[numOfPlaced/size-2][numOfPlaced%size+1])==1:
            possibleNum.remove(partialSolution[numOfPlaced/size-2][numOfPlaced%size+1])
        if possibleNum.count(partialSolution[numOfPlaced/size-2][numOfPlaced%size+2])==1:
            possibleNum.remove(partialSolution[numOfPlaced/size-2][numOfPlaced%size+2])    
        
    #if the next number is in the position4 of a box, check the position 1,3,4,6. 
    if (numOfPlaced/size==2 or numOfPlaced/size==5 or numOfPlaced/size==8)\
            and(numOfPlaced%size == 1 or numOfPlaced%size == 4 or numOfPlaced%size == 7)\
                and numOfPlaced !=0: 
        if possibleNum.count(partialSolution[numOfPlaced/size-1][numOfPlaced%size+1])==1:
            possibleNum.remove(partialSolution[numOfPlaced/size-1][numOfPlaced%size+1])
        if possibleNum.count(partialSolution[numOfPlaced/size-1][numOfPlaced%size-1])==1:
            possibleNum.remove(partialSolution[numOfPlaced/size-1][numOfPlaced%size-1])
        if possibleNum.count(partialSolution[numOfPlaced/size-2][numOfPlaced%size+1])==1:
            possibleNum.remove(partialSolution[numOfPlaced/size-2][numOfPlaced%size+1])
        if possibleNum.count(partialSolution[numOfPlaced/size-2][numOfPlaced%size-1])==1:
            possibleNum.remove(partialSolution[numOfPlaced/size-2][numOfPlaced%size-1])
    
    #if the next number is in the position4 of a box, check the position 1,2,4,5.        
    if (numOfPlaced/size==2 or numOfPlaced/size==5 or numOfPlaced/size==8)\
            and(numOfPlaced%size == 2 or numOfPlaced%size == 5 or numOfPlaced%size == 8)\
                and numOfPlaced !=0: 
        if possibleNum.count(partialSolution[numOfPlaced/size-1][numOfPlaced%size-2])==1:
            possibleNum.remove(partialSolution[numOfPlaced/size-1][numOfPlaced%size-2])
        if possibleNum.count(partialSolution[numOfPlaced/size-1][numOfPlaced%size-1])==1:
            possibleNum.remove(partialSolution[numOfPlaced/size-1][numOfPlaced%size-1])
        if possibleNum.count(partialSolution[numOfPlaced/size-2][numOfPlaced%size-2])==1:
            possibleNum.remove(partialSolution[numOfPlaced/size-2][numOfPlaced%size-2])
        if possibleNum.count(partialSolution[numOfPlaced/size-2][numOfPlaced%size-1])==1:
            possibleNum.remove(partialSolution[numOfPlaced/size-2][numOfPlaced%size-1])    
    return possibleNum


def printOne(partialSolution):
    "print the partial solution"
    for row in range(size):
        print(partialSolution[row])
    print("")
        
def transfer(listOfList):
    "transfer the representation of the Sudoku from list of list to Strings"
    grid = ''
    for row in listOfList:
        for col in row:
            grid += str(col)
    return grid

def removeNum(grid):
    "remove numbers from the solved Sudoku."
    numOfGiven = 81
    possibleRemove = range(81)
    while True:
        #Remove next one till there are less than 22 numbers.
        if numOfGiven > 23 and Solver.validate(grid):
            pos = int(random.random()*len(possibleRemove))
            num = possibleRemove.pop(pos)
            temp = grid[num]
            grids = []
            for i in grid:
                grids.append(i)
            grids[num] = '0'
            newGrid = ''
            for i in grids:
                newGrid += i
            grid = newGrid
            del newGrid,grids
            numOfGiven -= 1
        #undo the last remove and continue if there are still more than 28 given numbers
        elif numOfGiven not in range(23,28) and not Solver.validate(grid):
            grids = []
            for i in grid:
                grids.append(i)
            grids[num] = temp
            newGrid = ''
            for i in grids:
                newGrid += i
            grid = newGrid
            del newGrid,grids
            numOfGiven += 1
        #undo last remove and return the grid.
        elif numOfGiven in range(23,28) and not Solver.validate(grid):
            grids = []
            for i in grid:
                grids.append(i)
            grids[num] = temp
            newGrid = ''
            for i in grids:
                newGrid += i
            grid = newGrid
            del newGrid,grids
            return grid
            break
        #return the grid if there are already less than 23 given numbers
        elif numOfGiven <= 23 and Solver.validate(grid):
            return grid
            break
        
def reset():
    global partialSolution
    global numOfPlaced
    global size
    global grid
    global finish
    partialSolution = [[],[],[],[],[],[],[],[],[]]
    numOfPlaced = 0
    size = 9
    grid = ''
    finish = False

def givePuzzle():
	"""
		Returns a string of the puzzle
	"""
	reset()
	sudoku(partialSolution, numOfPlaced)
	return Solver.grid_values(removeNum(transfer(partialSolution)))

if __name__ == "__main__":    
	a = time.clock()
	sudoku(partialSolution, numOfPlaced)
	Solver.display(Solver.grid_values(transfer(partialSolution)))
	print removeNum(transfer(partialSolution))
	b = time.clock()
	print b - a #print out the time taken to generate the sudoku.
	print ''
	Solver.display(Solver.grid_values(removeNum(transfer(partialSolution))))

	reset()

	a = time.clock()
	sudoku(partialSolution, numOfPlaced)
	Solver.display(Solver.grid_values(transfer(partialSolution)))
	print removeNum(transfer(partialSolution))
	b = time.clock()
	print b - a #print out the time taken to generate the sudoku.	
	print ''
	Solver.display(Solver.grid_values(removeNum(transfer(partialSolution))))
