"use strict";

require("../../lib/jasmine-promise");
var Q = require("q");
var FS = require("../../../fs");
/*global describe,it,expect */

describe("read", function () {
    it("should read a file from a mock filesystem", function () {

        return FS.mock(FS.join(__dirname, "fixture"))
        .then(function (mock) {

            return Q.fcall(function () {
                return mock.read("hello.txt");
            })
            .then(function (content) {
                expect(content).toBe("Hello, World!\n");
            })

        });
    });

    it("calls open correctly", function () {
        return FS.mock(FS.join(__dirname, "fixture"))
        .then(function (mock) {
            mock.open = function (path, options) {
                expect(path).toBe("hello.txt");
                expect(options.flags).toBe("ra");
                expect(options.charset).toBe("utf8");

                return Q.resolve({read: function () {}, close: function () {}});
            };

            return mock.read("hello.txt", "a", "utf8");
        });
    });

});

