/*
 * Decompiled with CFR 0.152.
 */
package au.gov.bafcsi.hapi;

import au.gov.bafcsi.clapi.crypto.CsiCertificate;
import java.util.Date;

public class MessageInfo {
    public static final int UNKNOWN_STATE = -1;
    public static final int SIGNATURE_VERIFIES = 0;
    public static final int SIGNING_CERT_INVALID = 1;
    public static final int NO_CERT_FOR_SIGNATURE = 2;
    private CsiCertificate m_signingCertificate;
    private byte[] m_message;
    private boolean m_isNonRepudiationSigned = false;
    private int m_signatureValidationResults = -1;
    private Date m_signingTime;

    MessageInfo(byte[] byArray, CsiCertificate csiCertificate, int n10, boolean bl2, Date date) {
        this.init(byArray, csiCertificate, n10, bl2, date);
    }

    MessageInfo(byte[] byArray, CsiCertificate csiCertificate, int n10, boolean bl2) {
        this.init(byArray, csiCertificate, n10, bl2, null);
    }

    private void init(byte[] byArray, CsiCertificate csiCertificate, int n10, boolean bl2, Date date) {
        this.m_signingCertificate = csiCertificate;
        this.m_message = byArray;
        this.m_isNonRepudiationSigned = bl2;
        this.m_signatureValidationResults = n10;
        this.m_signingTime = date;
        if (this.m_signatureValidationResults < 0 || this.m_signatureValidationResults > 2) {
            throw new IllegalArgumentException("Illegal signatureValidationResults (" + this.m_signatureValidationResults + ") in MessageInfo.");
        }
    }

    public String getAbn() {
        if (this.m_signingCertificate == null) {
            return null;
        }
        return this.m_signingCertificate.getAbn();
    }

    public CsiCertificate getCertificate() {
        return this.m_signingCertificate;
    }

    public byte[] getMessage() {
        if (this.m_message == null || this.m_message.length < 1) {
            throw new IllegalStateException("Message data not available from MessageInfo.");
        }
        byte[] byArray = new byte[this.m_message.length];
        System.arraycopy(this.m_message, 0, byArray, 0, byArray.length);
        return byArray;
    }

    public boolean isNonRepudiationSigned() {
        return this.m_isNonRepudiationSigned;
    }

    public boolean isSignatureValid() {
        return this.m_signatureValidationResults == 0;
    }

    public int getSignatureValidationResults() {
        if (this.m_signatureValidationResults == -1) {
            throw new IllegalStateException("Signature validation results not available from MessageInfo.");
        }
        return this.m_signatureValidationResults;
    }

    public Date getSigningTime() {
        return this.m_signingTime;
    }
}

