/*
 * Decompiled with CFR 0.152.
 */
package au.gov.bafcsi.common.utils.base64;

import au.gov.bafcsi.common.ByteArray;
import au.gov.bafcsi.common.utils.base64.Base64;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public final class Base64OutputStream
extends FilterOutputStream {
    private static final int MAX_LINE_LENGTH = 76;
    private boolean encode;
    private int srcIndex;
    private byte[] srcBuffer;
    private byte[] destBuffer;
    private int lineLength;

    public Base64OutputStream(OutputStream outputStream) {
        this(outputStream, true);
    }

    public Base64OutputStream(OutputStream outputStream, boolean bl2) {
        super(outputStream);
        this.encode = bl2;
        this.srcBuffer = new byte[bl2 ? 3 : 4];
        this.destBuffer = new byte[bl2 ? 4 : 3];
        this.srcIndex = 0;
        this.lineLength = 0;
    }

    public void write(int n10) throws IOException {
        if (this.encode) {
            this.srcBuffer[this.srcIndex++] = (byte)n10;
        } else if (n10 != 13 && n10 != 10) {
            this.srcBuffer[this.srcIndex++] = (byte)n10;
        }
        if (this.srcIndex >= (this.encode ? 3 : 4)) {
            if (this.encode) {
                this.out.write(Base64.base64Encode(this.srcBuffer, 0, 3, this.destBuffer, 0));
                this.lineLength += 4;
                if (this.lineLength >= 76) {
                    this.out.write(Base64.NEW_LINE);
                    this.lineLength = 0;
                }
            } else {
                this.out.write(Base64.base64Decode(this.srcBuffer));
            }
            this.srcIndex = 0;
        }
    }

    public void write(byte[] byArray, int n10, int n11) throws IOException {
        for (int i10 = 0; i10 < n11; ++i10) {
            this.write(byArray[n10 + i10]);
        }
    }

    public void write(ByteArray byteArray) throws IOException {
        this.write(byteArray.getBytes(), 0, byteArray.length());
    }

    public void flush() throws IOException {
        if (this.srcIndex > 0) {
            if (!this.encode) {
                throw new IOException("Base64OutputStream.flush() - Base64 encoded input not properly padded !");
            }
            this.out.write(Base64.base64Encode(this.srcBuffer, 0, this.srcIndex, this.destBuffer, 0));
            this.srcIndex = -1;
        }
        super.flush();
    }
}

