/*
 * Decompiled with CFR 0.152.
 */
package au.gov.bafcsi.common.utils;

import au.gov.bafcsi.common.utils.ae;
import au.gov.bafcsi.common.utils.af;
import au.gov.bafcsi.common.utils.fq;
import au.gov.bafcsi.common.utils.j0;
import au.gov.bafcsi.common.utils.j1;
import au.gov.bafcsi.common.utils.jm;
import au.gov.bafcsi.common.utils.jn;
import au.gov.bafcsi.common.utils.jo;
import au.gov.bafcsi.common.utils.r;
import au.gov.bafcsi.common.utils.w;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.print.Book;
import java.awt.print.PageFormat;
import java.awt.print.Paper;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.IOException;
import java.net.URL;
import java.util.Vector;
import javax.print.attribute.standard.MediaSize;
import javax.print.attribute.standard.MediaSizeName;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.KeyStroke;
import javax.swing.border.EmptyBorder;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.StyleSheet;

public class HelpViewer
implements ActionListener {
    private static HelpViewer m_helpViewer = null;
    private static final int MIN_WIDTH = 640;
    private static final int MIN_HEIGHT = 350;
    private static final int PRINT_PAGE_OVERLAP = 15;
    private JEditorPane m_browserPane;
    private af m_helpDialog;
    private Window m_parentWindow = null;
    private Vector m_browseHistory = new Vector(10, 5);
    private int m_currentBrowseIndex = -1;
    private JButton m_forwardButton;
    private JButton m_backButton;
    private JButton m_printButton;
    private JButton m_closeButton;
    private static StyleSheet m_styleSheet = new StyleSheet();

    private HelpViewer(Window window) {
        this.m_parentWindow = window;
        this.m_helpDialog = new af("CSI help", true, window);
        this.init();
    }

    public static HelpViewer getInstance(Window window) {
        if (m_helpViewer == null) {
            m_helpViewer = new HelpViewer(window);
            m_helpViewer.getDialog().setSize(640, 550);
            m_helpViewer.getDialog().setLocation(new Point(50, 50));
            m_helpViewer.getDialog().invalidate();
        } else if (window == null || !window.equals(m_helpViewer.getParentWindow())) {
            Dimension dimension = m_helpViewer.getDialog().getSize();
            Point point = m_helpViewer.getDialog().getLocation();
            m_helpViewer.getDialog().c();
            m_helpViewer = null;
            m_helpViewer = new HelpViewer(window);
            m_helpViewer.getDialog().setSize(dimension);
            m_helpViewer.getDialog().setLocation(point);
            m_helpViewer.getDialog().invalidate();
        }
        return m_helpViewer;
    }

    private void init() {
        this.m_browserPane = new JTextPane();
        this.m_browserPane.setEditable(false);
        this.m_browserPane.addHyperlinkListener(new jm(this));
        this.m_browserPane.getInputMap(1).put(KeyStroke.getKeyStroke("ESCAPE"), "escapeAction");
        this.m_browserPane.getActionMap().put("escapeAction", new jn(this));
        JScrollPane jScrollPane = new JScrollPane(this.m_browserPane);
        jScrollPane.setHorizontalScrollBarPolicy(31);
        jScrollPane.setVerticalScrollBarPolicy(20);
        jScrollPane.getViewport().setView(this.m_browserPane);
        this.m_closeButton = new JButton("Close");
        this.m_closeButton.setMnemonic('C');
        this.m_closeButton.setToolTipText("Close the help information");
        this.m_closeButton.addActionListener(this);
        this.m_backButton = new JButton("Back");
        this.m_backButton.setMnemonic('B');
        this.m_backButton.setToolTipText("Navigate backwards one page");
        this.m_backButton.addActionListener(this);
        this.m_forwardButton = new JButton("Forward");
        this.m_forwardButton.setMnemonic('F');
        this.m_forwardButton.setToolTipText("Navigate forward one page");
        this.m_forwardButton.addActionListener(this);
        this.m_printButton = new JButton("Print");
        this.m_printButton.setMnemonic('P');
        this.m_printButton.setToolTipText("Print this page");
        this.m_printButton.addActionListener(this);
        JPanel jPanel = new JPanel();
        jPanel.add(this.m_closeButton);
        jPanel.add(this.m_backButton);
        jPanel.add(this.m_forwardButton);
        jPanel.add(this.m_printButton);
        this.m_closeButton.requestFocus();
        jPanel.setBorder(new EmptyBorder(10, 0, 0, 0));
        Container container = this.m_helpDialog.m();
        container.setLayout(new BorderLayout());
        container.add((Component)jScrollPane, "Center");
        container.add((Component)jPanel, "South");
        this.m_helpDialog.g();
        this.m_helpDialog.a(2);
        this.m_helpDialog.addComponentListener(new jo(this));
    }

    private static Container getContentPane(Window window) {
        if (window instanceof JFrame) {
            return ((JFrame)window).getContentPane();
        }
        return ((JDialog)window).getContentPane();
    }

    private static void setDefaultCloseOperation(Window window, int n10) {
        if (window instanceof JFrame) {
            ((JFrame)window).setDefaultCloseOperation(n10);
        } else {
            ((JDialog)window).setDefaultCloseOperation(n10);
        }
    }

    private void close() {
        this.m_helpDialog.setVisible(false);
    }

    private void print() {
        j0 j02 = new j0(this);
        try {
            MediaSize mediaSize = MediaSize.getMediaSizeForName(MediaSizeName.ISO_A4);
            PrinterJob printerJob = PrinterJob.getPrinterJob();
            PageFormat pageFormat = new PageFormat();
            Paper paper = new Paper();
            paper.setSize(mediaSize.getX(25400) * 72.0f, mediaSize.getY(25400) * 72.0f);
            pageFormat.setPaper(paper);
            boolean bl2 = printerJob.printDialog();
            if (bl2) {
                int n10 = (int)(this.getPrintScale(pageFormat) * (double)this.m_browserPane.getHeight() / (pageFormat.getImageableHeight() - 15.0)) + 1;
                Book book = new Book();
                book.append(j02, pageFormat, n10);
                printerJob.setPageable(book);
                printerJob.print();
            }
        }
        catch (PrinterException printerException) {
            ae.b(this.getParentWindow(), "An unexpected error occurred while trying to print this page.", "CSI - Error", 0);
            r.a(w.g, "HelpViewer.print(): An unexpected error occured while trying to print: " + printerException.getMessage(), printerException);
        }
        this.m_helpDialog.i();
    }

    private void forward() {
        if (this.m_currentBrowseIndex < this.m_browseHistory.size() - 1) {
            ++this.m_currentBrowseIndex;
            this.engineShowPage((URL)this.m_browseHistory.get(this.m_currentBrowseIndex));
        }
    }

    private void back() {
        if (this.m_currentBrowseIndex > 0) {
            --this.m_currentBrowseIndex;
            this.engineShowPage((URL)this.m_browseHistory.get(this.m_currentBrowseIndex));
        }
    }

    private void updateButtonEnablement() {
        this.m_forwardButton.setEnabled(this.m_currentBrowseIndex + 1 < this.m_browseHistory.size());
        this.m_backButton.setEnabled(this.m_currentBrowseIndex > 0);
    }

    private double getPrintScale(PageFormat pageFormat) {
        double d10 = pageFormat.getImageableWidth() / (double)this.m_browserPane.getWidth();
        if (d10 > 1.0) {
            d10 = 1.0;
        }
        return d10;
    }

    private void resized() {
        boolean bl2 = false;
        Dimension dimension = this.m_helpDialog.getSize();
        if (dimension.width < 640) {
            dimension.width = 640;
            bl2 = true;
        }
        if (dimension.height < 350) {
            dimension.height = 350;
            bl2 = true;
        }
        if (bl2) {
            this.m_helpDialog.setSize(dimension);
            this.m_helpDialog.invalidate();
        }
    }

    public void showPage(URL uRL) {
        ++this.m_currentBrowseIndex;
        if (this.m_currentBrowseIndex < this.m_browseHistory.size()) {
            for (int i10 = this.m_currentBrowseIndex; i10 < this.m_browseHistory.size(); ++i10) {
                this.m_browseHistory.removeElementAt(i10);
            }
        }
        this.m_browseHistory.add(uRL);
        if (uRL == null) {
            throw new IllegalArgumentException("Null cannot be passed to HelpViewer.showPage()");
        }
        this.engineShowPage(uRL);
    }

    private void engineShowPage(URL uRL) {
        this.updateButtonEnablement();
        try {
            this.m_browserPane.setEditorKit(new HTMLEditorKit());
            HTMLDocument hTMLDocument = new HTMLDocument(m_styleSheet);
            hTMLDocument.setBase(uRL);
            this.m_browserPane.read(uRL.openStream(), (Object)hTMLDocument);
            this.m_browserPane.setCaretPosition(0);
            if (!this.m_helpDialog.isVisible()) {
                this.m_helpDialog.setVisible(true);
            }
        }
        catch (IOException iOException) {
            String string = "An error occured while attempting to display the help page from " + uRL.toExternalForm();
            r.a(w.i, string, iOException);
        }
    }

    private Window getParentWindow() {
        return this.m_parentWindow;
    }

    private af getDialog() {
        return this.m_helpDialog;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object.equals(this.m_closeButton)) {
            this.close();
        } else if (object.equals(this.m_backButton)) {
            this.back();
        } else if (object.equals(this.m_forwardButton)) {
            this.forward();
        } else if (object.equals(this.m_printButton)) {
            this.print();
        }
    }

    public static void main(String[] stringArray) throws Exception {
        fq.a();
        URL uRL = HelpViewer.class.getResource("/au/gov/bafcsi/helppages/Introduction.htm");
        HelpViewer helpViewer = HelpViewer.getInstance(null);
        helpViewer.m_helpDialog.a(new j1());
        helpViewer.showPage(uRL);
    }

    static /* synthetic */ int access$000(HelpViewer helpViewer) {
        return helpViewer.m_currentBrowseIndex;
    }

    static /* synthetic */ Vector access$100(HelpViewer helpViewer) {
        return helpViewer.m_browseHistory;
    }

    static /* synthetic */ void access$200(HelpViewer helpViewer) {
        helpViewer.close();
    }

    static /* synthetic */ void access$300(HelpViewer helpViewer) {
        helpViewer.resized();
    }

    static /* synthetic */ double access$400(HelpViewer helpViewer, PageFormat pageFormat) {
        return helpViewer.getPrintScale(pageFormat);
    }

    static /* synthetic */ JEditorPane access$500(HelpViewer helpViewer) {
        return helpViewer.m_browserPane;
    }

    static /* synthetic */ af access$600(HelpViewer helpViewer) {
        return helpViewer.m_helpDialog;
    }

    static {
        m_styleSheet.addRule("a { text-decoration:underline ; color:blue}");
        m_styleSheet.addRule("pre p { margin-top:0 }");
        m_styleSheet.addRule("p { margin-top:15 }");
        m_styleSheet.addRule("ul { margin-left:50 ; margin-bottom:10 ; margin-top:10 ; list-style-type:disc}");
        m_styleSheet.addRule("ol { margin-left:50 ; margin-bottom:10 ; margin-top:10 ; list-style-type:decimal}");
    }
}

