/*
 * Decompiled with CFR 0.152.
 */
package au.gov.bafcsi.common.asn1;

import au.gov.bafcsi.clapi.asn1.ax;
import au.gov.bafcsi.clapi.asn1.b6;
import au.gov.bafcsi.clapi.asn1.cf;
import au.gov.bafcsi.clapi.common.Attribute;
import au.gov.bafcsi.clapi.common.Oid;
import au.gov.bafcsi.common.ByteArray;
import au.gov.bafcsi.common.asn1.ASN1Exception;
import au.gov.bafcsi.common.asn1.ASN1Object;
import java.io.IOException;

public class CustomAttribute {
    public static Attribute build(Oid oid, ASN1Object aSN1Object) throws IOException, ASN1Exception {
        if (oid == null) {
            throw new IllegalArgumentException("Attribute.createCustomAttribute(Oid,ByteArray) - Oid is null.");
        }
        if (aSN1Object == null) {
            throw new IllegalArgumentException("Attribute.createCustomAttribute(Oid,ByteArray) - ByteArray is null.");
        }
        return new Attribute(oid, new cf(new ByteArray(aSN1Object.encode())));
    }

    public static void parse(Attribute attribute, ASN1Object aSN1Object) throws IOException, ASN1Exception {
        if (attribute == null) {
            throw new IllegalArgumentException("Attribute.parseCustomAttribute(Attribute) - Attribute is null.");
        }
        ax ax2 = attribute.getFirstAttributeValue();
        if (!(ax2 instanceof b6)) {
            throw new IllegalArgumentException("CustomAttribute.parse(Attribute,ASN1Object) - This is not a custom attribute.");
        }
        ByteArray byteArray = ((b6)ax2).b;
        aSN1Object.decode(byteArray.getBytes());
    }
}

