/*
 * Decompiled with CFR 0.152.
 */
package au.gov.bafcsi.common.asn1;

import au.gov.bafcsi.common.asn1.ASN1Exception;
import au.gov.bafcsi.common.asn1.ASN1Object;
import au.gov.bafcsi.common.asn1.ir;
import java.io.IOException;
import java.io.UnsupportedEncodingException;

public abstract class ASN1String
extends ASN1Object {
    private String s;
    private byte[] decodedValue;
    private String encoding;

    public ASN1String(int n10) {
        this(n10, "", "ISO-8859-1");
    }

    public ASN1String(int n10, String string) {
        this(n10, string, "ISO-8859-1");
    }

    public ASN1String(int n10, String string, String string2) {
        super(n10);
        this.setValue(string);
        if (string2 == null) {
            throw new IllegalArgumentException("ASN1String(int, String, String) - The supplied encoding is null.");
        }
        this.encoding = string2;
    }

    public String getValue() {
        return this.s;
    }

    public void setValue(String string) {
        if (string == null) {
            throw new IllegalArgumentException("ASN1String.setValue(String) - The supplied String is null.");
        }
        this.s = string;
        this.decodedValue = null;
    }

    void setValueEncoding(byte[] byArray) throws UnsupportedEncodingException {
        if (byArray == null) {
            throw new IllegalArgumentException("ASN1String.setValueEncoding(byte[]) - The encoding is null.");
        }
        this.setValue(new String(byArray, 0, byArray.length, this.encoding));
        this.decodedValue = byArray;
    }

    byte[] getValueEncoding() throws UnsupportedEncodingException {
        if (this.decodedValue == null) {
            this.decodedValue = this.s.getBytes(this.encoding);
        }
        return this.decodedValue;
    }

    public void accept(ir ir2) throws IOException, ASN1Exception {
        if (ir2 == null) {
            throw new IllegalArgumentException("ASN1String.accept(Visitor) - visitor is null.");
        }
        ir2.a(this);
    }
}

