/*
 * Decompiled with CFR 0.152.
 */
package au.gov.bafcsi.common.asn1;

import au.gov.bafcsi.common.asn1.ASN1Exception;
import au.gov.bafcsi.common.asn1.ir;
import au.gov.bafcsi.common.asn1.is;
import au.gov.bafcsi.common.asn1.it;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

public abstract class ASN1Object {
    protected int tag;

    public ASN1Object(int n10) {
        this.tag = n10;
    }

    public final void decode(byte[] byArray) throws IOException, ASN1Exception {
        if (byArray == null) {
            throw new IllegalArgumentException("ASN1Object.decode(byte[]) - The supplied byte[] is null.");
        }
        this.accept(new is(new ByteArrayInputStream(byArray)));
    }

    public final byte[] encode() throws IOException, ASN1Exception {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        this.accept(new it(byteArrayOutputStream));
        return byteArrayOutputStream.toByteArray();
    }

    public abstract void accept(ir var1) throws IOException, ASN1Exception;
}

