/*
 * Decompiled with CFR 0.152.
 */
package au.gov.bafcsi.clapi.packaging.xml.resource;

import au.gov.bafcsi.clapi.packaging.xml.XMLElement;
import au.gov.bafcsi.clapi.packaging.xml.XMLUtils;
import au.gov.bafcsi.clapi.packaging.xml.resource.ig;
import au.gov.bafcsi.clapi.packaging.xml.xpath.ib;
import au.gov.bafcsi.clapi.packaging.xml.xpath.ic;
import au.gov.bafcsi.clapi.packaging.xml.xpath.ie;
import java.util.Hashtable;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.NodeList;

public class IDResolver {
    private Hashtable IDs;

    public IDResolver(Document document) throws ig {
        if (document == null) {
            throw new IllegalArgumentException("IDResolver(Document) - The supplied Document is null.");
        }
        this.IDs = IDResolver.resolveIDs(document);
    }

    public IDResolver(XMLElement xMLElement) throws ig {
        if (xMLElement == null) {
            throw new IllegalArgumentException("IDResolver(XMLElement) - The supplied XMLElement is null.");
        }
        this.IDs = IDResolver.resolveIDs(XMLUtils.getOwnerDocument(xMLElement));
    }

    public void addXMLElement(XMLElement xMLElement) throws ig {
        if (xMLElement == null) {
            throw new IllegalArgumentException("IDResolver.addXMLElement(XMLElement) - The supplied XMLElement is null.");
        }
        this.addDocument(XMLUtils.getOwnerDocument(xMLElement));
    }

    public void addDocument(Document document) throws ig {
        if (document == null) {
            throw new IllegalArgumentException("IDResolver.addDocument(Document) - The supplied Document is null.");
        }
        this.IDs.putAll(IDResolver.resolveIDs(document));
    }

    public Element resolveID(String string) {
        if (string == null) {
            throw new IllegalArgumentException("IDResolver.resolveID(String) - The supplied String is null.");
        }
        return (Element)this.IDs.get(string);
    }

    private static Hashtable resolveIDs(Document document) throws ig {
        if (document == null) {
            throw new IllegalArgumentException("IDResolver.resolveIDs(Document) - The supplied Document is null.");
        }
        Hashtable<String, Element> hashtable = new Hashtable<String, Element>();
        try {
            ie ie2 = ic.a();
            NodeList nodeList = ie2.a(document, "//*[@ID or @Id or @id]");
            for (int i10 = 0; i10 < nodeList.getLength(); ++i10) {
                String string;
                Element element = (Element)nodeList.item(i10);
                NamedNodeMap namedNodeMap = element.getAttributes();
                if (namedNodeMap.getNamedItem("ID") != null) {
                    string = element.getAttribute("ID");
                } else if (namedNodeMap.getNamedItem("Id") != null) {
                    string = element.getAttribute("Id");
                } else if (namedNodeMap.getNamedItem("id") != null) {
                    string = element.getAttribute("id");
                } else if (namedNodeMap.getNamedItem("wsu:Id") != null) {
                    string = element.getAttribute("wsu:Id");
                } else {
                    throw new ig("IDResolver.resolveIDs(Document) - No ID/Id/id Attribute in Element '" + element.getNodeName() + "'.");
                }
                Element element2 = (Element)hashtable.get(string);
                if (element2 != null) {
                    throw new ig("IDResolver.resolveIDs(Document) - Cannot add Element '" + element.getNodeName() + "' to the hashtable, an Element '" + element2.getNodeName() + "' with an Attribute ID '" + string + "' already exists !");
                }
                hashtable.put(string, element);
            }
        }
        catch (ib ib2) {
            throw new ig("IDResolver.resolveIDs(Document)", ib2);
        }
        return hashtable;
    }
}

