/*
 * Decompiled with CFR 0.152.
 */
package au.gov.bafcsi.clapi.packaging.xml;

import au.gov.bafcsi.clapi.common.DigestOid;
import au.gov.bafcsi.clapi.packaging.xml.XMLElement;
import au.gov.bafcsi.clapi.packaging.xml.XMLException;
import au.gov.bafcsi.clapi.packaging.xml.ia;
import au.gov.bafcsi.clapi.packaging.xml.xpath.ib;
import au.gov.bafcsi.clapi.packaging.xml.xpath.ic;
import au.gov.bafcsi.common.ByteArray;
import au.gov.bafcsi.common.utils.base64.Base64;
import au.gov.bafcsi.common.utils.r;
import au.gov.bafcsi.common.utils.w;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.Hashtable;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public abstract class XMLUtils {
    private static HashMap DigestOidToDigestMethod = new HashMap(20);
    private static final String hexString = "0123456789ABCDEF";
    private static final char[] hexStringArray;
    static /* synthetic */ Class class$org$w3c$dom$Node;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$org$w3c$dom$UserDataHandler;

    public static Document getDocument(InputStream inputStream, boolean bl2, boolean bl3) throws XMLException {
        DocumentBuilder documentBuilder;
        if (inputStream == null) {
            throw new IllegalArgumentException("XMLUtils.getDocument(InputStream, boolean, boolean) - The supplied Document is null.");
        }
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setValidating(bl2);
        documentBuilderFactory.setNamespaceAware(bl3);
        try {
            documentBuilder = documentBuilderFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new XMLException("XMLUtils.getDocument(InputStream in, boolean, boolean)", parserConfigurationException);
        }
        try {
            InputSource inputSource = new InputSource(inputStream);
            return documentBuilder.parse(inputSource);
        }
        catch (SAXException sAXException) {
            throw new XMLException("XMLUtils.getDocument(InputStream in, boolean, boolean)", sAXException);
        }
        catch (IOException iOException) {
            throw new XMLException("XMLUtils.getDocument(InputStream in, boolean, boolean)", iOException);
        }
    }

    public static Document getDocument(boolean bl2, boolean bl3) throws XMLException {
        DocumentBuilder documentBuilder;
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setValidating(bl2);
        documentBuilderFactory.setNamespaceAware(bl3);
        try {
            documentBuilder = documentBuilderFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new XMLException("XMLUtils.getDocument()", parserConfigurationException);
        }
        return documentBuilder.newDocument();
    }

    public static Document getOwnerDocument(XMLElement xMLElement) {
        if (xMLElement == null) {
            throw new IllegalArgumentException("XMLUtils.getOwnerDocument(XMLElement) - The supplied XMLElement is null.");
        }
        return XMLUtils.getOwnerDocument(xMLElement.getElement());
    }

    public static Document getOwnerDocument(Node node) {
        if (node == null) {
            throw new IllegalArgumentException("XMLUtils.getOwnerDocument(Node) - The supplied Node is null.");
        }
        if (node.getNodeType() == 9) {
            return (Document)node;
        }
        return node.getOwnerDocument();
    }

    public static Element findElement(Document document, String string) throws XMLException {
        return XMLUtils.findElement(document, string, null);
    }

    public static Element findElement(Document document, String string, Hashtable hashtable) throws XMLException {
        NodeList nodeList;
        Object object;
        if (document == null) {
            throw new IllegalArgumentException("XMLUtils.findElement(Document, String) - The supplied Document is null.");
        }
        if (string == null) {
            throw new IllegalArgumentException("XMLUtils.findElement(Document, String) - The supplied String is null.");
        }
        try {
            object = ic.a();
            nodeList = object.a(document, string, hashtable);
        }
        catch (ib ib2) {
            throw new XMLException("XMLUtils.findElement(Document, String)", ib2);
        }
        if (nodeList.getLength() != 1) {
            throw new XMLException("XMLUtils.findElement(Document, String) - '" + nodeList.getLength() + "' '" + string + "' Elements found, we were expecting just one!");
        }
        object = (Element)nodeList.item(0);
        if (object == null) {
            throw new XMLException("XMLUtils.findElement(Document, String) - The supplied Element does not contain a '" + string + "'");
        }
        return object;
    }

    public static XMLElement toCryptoBinary(Document document, String string, String string2, BigInteger bigInteger) throws XMLException {
        if (document == null) {
            throw new IllegalArgumentException("XMLUtils.toCryptoBinary(Document, String, String, BigInteger) - The supplied Document is null.");
        }
        if (string == null) {
            throw new IllegalArgumentException("XMLUtils.toCryptoBinary(Document, String, String, BigInteger) - The supplied elementName is null.");
        }
        if (bigInteger == null) {
            throw new IllegalArgumentException("XMLUtils.toCryptoBinary(Document, String, String, BigInteger) - The supplied BigInteger is null.");
        }
        byte[] byArray = bigInteger.toByteArray();
        int n10 = 0;
        while (byArray[n10] == 0) {
            ++n10;
        }
        return XMLUtils.toBase64Binary(document, string, string2, new ByteArray(byArray, n10, byArray.length - n10));
    }

    public static XMLElement toBase64Binary(Document document, String string, String string2, ByteArray byteArray) throws XMLException {
        if (document == null) {
            throw new IllegalArgumentException("XMLUtils.toBase64Binary(Document, String, String, ByteArray) - The supplied Document is null.");
        }
        if (string == null) {
            throw new IllegalArgumentException("XMLUtils.toBase64Binary(Document, String, String, ByteArray) - The supplied elementName is null.");
        }
        if (byteArray == null) {
            throw new IllegalArgumentException("XMLUtils.toBase64Binary(Document, String, String, ByteArray) - The supplied ByteArray is null.");
        }
        XMLElement xMLElement = new XMLElement(document, string, string2);
        try {
            xMLElement.getElement().appendChild(document.createTextNode(Base64.encode(byteArray).toString()));
        }
        catch (IOException iOException) {
            throw new XMLException("XMLUtils.toBase64Binary(Document, String, String, ByteArray)", iOException);
        }
        return xMLElement;
    }

    public static BigInteger fromCryptoBinary(Element element) throws XMLException {
        if (element == null) {
            throw new IllegalArgumentException("XMLUtils.fromCryptoBinary(Element) - The supplied Element is null.");
        }
        return new BigInteger(1, XMLUtils.fromBase64Binary(element).toBytes());
    }

    public static ByteArray fromBase64Binary(Element element) throws XMLException {
        if (element == null) {
            throw new IllegalArgumentException("XMLUtils.fromBase64Binary(Element) - The supplied Element is null.");
        }
        Node node = element.getFirstChild();
        if (node == null) {
            throw new XMLException("XMLUtils.fromBase64Binary(Element) - The supplied Element does not have children.");
        }
        return Base64.decode(node.getNodeValue());
    }

    public static String getStringValue(Node node) {
        if (node == null) {
            throw new IllegalArgumentException("XMLUtils.getStringValue(Node) - The supplied Node is null.");
        }
        switch (node.getNodeType()) {
            case 1: 
            case 5: 
            case 9: {
                Node node2 = node.getFirstChild();
                if (node2 == null) {
                    return "";
                }
                if (node2 == node.getLastChild() && (node2.getNodeType() == 3 || node2.getNodeType() == 4)) {
                    return node2.getNodeValue();
                }
                StringBuffer stringBuffer = new StringBuffer();
                XMLUtils.getStringValueInternal(node, stringBuffer);
                return stringBuffer.toString();
            }
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 8: {
                return node.getNodeValue();
            }
        }
        throw new RuntimeException("XMLUtils.getStringValue(Node) - Unexpected Node '" + node.getNodeType() + "'");
    }

    private static void getStringValueInternal(Node node, StringBuffer stringBuffer) {
        if (node == null) {
            throw new IllegalArgumentException("XMLUtils.getStringValueInternal(Node, StringBuffer) - The supplied Node is null.");
        }
        if (stringBuffer == null) {
            throw new IllegalArgumentException("XMLUtils.getStringValueInternal(Node, StringBuffer) - The supplied StringBuffer is null.");
        }
        switch (node.getNodeType()) {
            case 1: 
            case 5: 
            case 9: {
                for (Node node2 = node.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
                    XMLUtils.getStringValueInternal(node2, stringBuffer);
                }
                break;
            }
            case 3: 
            case 4: {
                stringBuffer.append(node.getNodeValue());
            }
        }
    }

    public static boolean isElement(Node node, String string, String string2) {
        if (node == null) {
            throw new IllegalArgumentException("XMLUtils.isElement(Node, String, String) - The supplied Node is null.");
        }
        if (node.getNodeType() != 1) {
            return false;
        }
        if (string == null) {
            throw new IllegalArgumentException("XMLUtils.isElement(Node, String, String) - The supplied localName is null.");
        }
        if (string2 == null) {
            throw new IllegalArgumentException("XMLUtils.isElement(Node, String, String) - The supplied namespace is null.");
        }
        String string3 = node.getNamespaceURI();
        if (string3 == null) {
            return false;
        }
        return string3.equals(string2) && node.getLocalName().equals(string);
    }

    public static String encodeUTF8Character(char c10) throws UnsupportedEncodingException {
        String string = String.valueOf(c10);
        byte[] byArray = string.getBytes("UTF8");
        StringBuffer stringBuffer = new StringBuffer();
        int n10 = byArray.length;
        for (int i10 = 0; i10 < n10; ++i10) {
            byte by2 = byArray[i10];
            stringBuffer.append("#x");
            stringBuffer.append(hexStringArray[by2 >> 4 & 0xF]);
            stringBuffer.append(hexStringArray[by2 & 0xF]);
        }
        return stringBuffer.toString();
    }

    public static Hashtable getNamespaceAttributesInAncestors(Node node) {
        Object object;
        if (node == null) {
            throw new IllegalArgumentException("XMLUtils.getNamespaceAttributesInAncestors(Node) - The supplied Node is null.");
        }
        Node node2 = node;
        Hashtable<String, ia> hashtable = new Hashtable<String, ia>();
        if (node.getNodeType() == 1 && ((Element)node).getAttributeNode("xmlns:xml") == null) {
            object = XMLUtils.getOwnerDocument(node).createAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:xml");
            object.setNodeValue("http://www.w3.org/XML/1998/namespace");
            hashtable.put("xmlns:xml", new ia((Element)node, (Attr)object));
        }
        do {
            if ((object = node.getAttributes()) == null) continue;
            int n10 = object.getLength();
            for (int i10 = 0; i10 < n10; ++i10) {
                Attr attr = (Attr)object.item(i10);
                String string = attr.getNodeName();
                if (!string.equals("xmlns") && !string.startsWith("xmlns:") || hashtable.containsKey(string)) continue;
                hashtable.put(string, new ia((Element)node2, attr));
            }
        } while ((node = node.getParentNode()) != null);
        return hashtable;
    }

    public static Hashtable getAllAttributesInAncestors(Node node) {
        Object object;
        if (node == null) {
            throw new IllegalArgumentException("XMLUtils.getNamespaceAttributesInAncestors(Node) - The supplied Node is null.");
        }
        Node node2 = node;
        Hashtable<String, ia> hashtable = new Hashtable<String, ia>();
        if (node.getNodeType() == 1 && ((Element)node).getAttributeNode("xmlns:xml") == null) {
            object = XMLUtils.getOwnerDocument(node).createAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:xml");
            object.setNodeValue("http://www.w3.org/XML/1998/namespace");
            hashtable.put("xmlns:xml", new ia((Element)node, (Attr)object));
        }
        while ((node = node.getParentNode()) != null) {
            object = node.getAttributes();
            if (object == null) continue;
            int n10 = object.getLength();
            for (int i10 = 0; i10 < n10; ++i10) {
                Attr attr = (Attr)object.item(i10);
                String string = attr.getNodeName();
                if (hashtable.containsKey(string)) continue;
                hashtable.put(string, new ia((Element)node2, attr));
            }
        }
        return hashtable;
    }

    public static Hashtable getXMLPrefixAttributesInAncestors(Node node) {
        Object object;
        int n10;
        Object object2;
        if (node == null) {
            throw new IllegalArgumentException("XMLUtils.getXMLPrefixAttributesInAncestors(Node) - The supplied Node is null.");
        }
        Hashtable<String, Object> hashtable = null;
        for (object2 = node.getParentNode(); object2 != null; object2 = object2.getParentNode()) {
            NamedNodeMap namedNodeMap = object2.getAttributes();
            if (namedNodeMap == null) continue;
            n10 = namedNodeMap.getLength();
            for (int i10 = 0; i10 < n10; ++i10) {
                object = (Attr)namedNodeMap.item(i10);
                String string = object.getNodeName();
                if (!string.startsWith("xml:") || hashtable != null && hashtable.containsKey(string)) continue;
                if (hashtable == null) {
                    hashtable = new Hashtable<String, Object>();
                }
                hashtable.put(string, object);
            }
        }
        if (hashtable != null && (object2 = node.getAttributes()) != null) {
            int n11 = object2.getLength();
            for (n10 = 0; n10 < n11; ++n10) {
                Attr attr = (Attr)object2.item(n10);
                object = attr.getNodeName();
                if (!((String)object).startsWith("xml:") || !hashtable.containsKey(object)) continue;
                hashtable.remove(object);
            }
        }
        return hashtable;
    }

    public static ByteArray I2OSP(BigInteger bigInteger, int n10) {
        ByteArray byteArray;
        block6: {
            block5: {
                if (bigInteger == null) {
                    throw new IllegalArgumentException("XMLUtils.I2OSP(BigInteger) - The supplied BigInteger is null.");
                }
                if (bigInteger.signum() != 1) {
                    throw new IllegalArgumentException("XMLUtils.I2OSP(BigInteger) - The supplied BigInteger must be positive.");
                }
                if (n10 <= 0) {
                    throw new IllegalArgumentException("XMLUtils.I2OSP(BigInteger) - The supplied xLen must be > 0.");
                }
                byteArray = new ByteArray(bigInteger.toByteArray());
                if (byteArray.length() <= n10) break block5;
                while (byteArray.length() > n10) {
                    byteArray = byteArray.subbytes(1);
                }
                break block6;
            }
            if (byteArray.length() >= n10) break block6;
            while (byteArray.length() < n10) {
                byteArray.prepend((byte)0);
            }
        }
        return byteArray;
    }

    public static BigInteger OS2IP(ByteArray byteArray) {
        if (byteArray == null) {
            throw new IllegalArgumentException("XMLUtils.OS2IP(ByteArray) - The supplied ByteArray is null.");
        }
        while (byteArray.byteAt(0) == 0) {
            byteArray = byteArray.subbytes(1);
        }
        return new BigInteger(1, byteArray.getBytes());
    }

    private static void addDigestMethodToDigestOidMapping(DigestOid digestOid, Object object) {
        if (digestOid != null && object != null) {
            DigestOidToDigestMethod.put(digestOid, object);
        }
    }

    public static String getDigestMethod(DigestOid digestOid) {
        String string = null;
        if (digestOid != null && (string = (String)DigestOidToDigestMethod.get(digestOid)) == null) {
            r.a(w.i, "No OID mapping exists for the OID " + digestOid + ".");
        }
        return string;
    }

    static {
        XMLUtils.addDigestMethodToDigestOidMapping(DigestOid.MD5, "http://www.w3.org/2001/04/xmldsig-more#md5");
        XMLUtils.addDigestMethodToDigestOidMapping(DigestOid.SHA1, "http://www.w3.org/2000/09/xmldsig#sha1");
        XMLUtils.addDigestMethodToDigestOidMapping(DigestOid.SHA256, "http://www.w3.org/2001/04/xmldsig-more#sha256");
        XMLUtils.addDigestMethodToDigestOidMapping(DigestOid.SHA384, "http://www.w3.org/2001/04/xmldsig-more#sha384");
        XMLUtils.addDigestMethodToDigestOidMapping(DigestOid.SHA512, "http://www.w3.org/2001/04/xmldsig-more#sha512");
        hexStringArray = hexString.toCharArray();
    }
}

