/*
 * Decompiled with CFR 0.152.
 */
package au.gov.bafcsi.clapi.packaging.xml;

import au.gov.bafcsi.clapi.crypto.CertificateCollection;
import au.gov.bafcsi.clapi.crypto.CsiCertificate;
import au.gov.bafcsi.clapi.packaging.SignedInputStream;
import au.gov.bafcsi.clapi.packaging.xml.signature.Validity;
import au.gov.bafcsi.clapi.packaging.xml.signature.XMLSignature;
import au.gov.bafcsi.clapi.packaging.xml.signature.XMLSignatureException;
import au.gov.bafcsi.clapi.packaging.xml.signature.properties.CSIAttributes;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;

public class SignedXMLInputStream
extends SignedInputStream {
    private InputStream data = null;
    private XMLSignature signature = null;

    public SignedXMLInputStream(InputStream inputStream) throws XMLSignatureException {
        if (inputStream == null) {
            throw new IllegalArgumentException("SignedXMLInputStream(InputStream) - The supplied InputStream is null.");
        }
        this.signature = XMLSignature.getInstance(inputStream);
        this.data = this.signature.getTransformedReferenceStream(0);
    }

    public int read() throws IOException {
        if (this.data == null) {
            throw new IOException("SignedXMLInputStream.read() - This InputStream has been closed !");
        }
        return this.data.read();
    }

    public void close() throws IOException {
        this.data = null;
    }

    public CertificateCollection getCertificates() {
        try {
            return this.signature.getKeyInfo().d();
        }
        catch (XMLSignatureException xMLSignatureException) {
            return null;
        }
    }

    public CsiCertificate verify(CertificateCollection certificateCollection) throws IOException {
        if (certificateCollection == null) {
            throw new IllegalArgumentException("SignedXMLInputStream.verify(CertificateCollection) - The supplied CertificateCollection is null.");
        }
        if (certificateCollection.isEmpty()) {
            throw new IllegalArgumentException("SignedXMLInputStream.verify(CertificateCollection) - The supplied CertificateCollection is empty.");
        }
        try {
            Validity validity = this.signature.verify(certificateCollection.getCertificate(0).getPublicKey(), null);
            if (validity.isValid()) {
                return certificateCollection.getCertificate(0);
            }
            return null;
        }
        catch (XMLSignatureException xMLSignatureException) {
            throw new IOException("SignedXMLInputStream.verify(CertificateCollection) - " + xMLSignatureException.toString());
        }
    }

    public boolean isNonRepudiationSigned(CsiCertificate csiCertificate) {
        CSIAttributes cSIAttributes;
        try {
            cSIAttributes = this.signature.getCSIAttributes();
        }
        catch (XMLSignatureException xMLSignatureException) {
            return false;
        }
        if (cSIAttributes != null) {
            return cSIAttributes.isNonRepudiationSigning();
        }
        return false;
    }

    public void setCancelled() {
    }

    public Date getSigningTime() throws XMLSignatureException {
        return this.signature.getSigningTime().getTime();
    }
}

