/*
 * Decompiled with CFR 0.152.
 */
package au.gov.bafcsi.clapi.packaging.smime;

import au.gov.bafcsi.clapi.packaging.exceptions.BadMessageFormatException;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;

public final class SMimeHeaders {
    public static final int SIGNED = 1;
    public static final int ENVELOPED = 2;
    public static final int MULTIPART = 3;
    public static final int CERTS_ONLY = 4;
    public static final int UNKNOWN = 5;
    private Map map = new HashMap();
    private InputStream in = null;
    private boolean firstLine = true;

    public SMimeHeaders(InputStream inputStream) throws IOException {
        if (inputStream == null) {
            throw new IllegalArgumentException("SMimeHeaders(InputStream) - InputStream is null.");
        }
        this.in = inputStream;
        boolean bl2 = false;
        while (!bl2) {
            String string = this.readLine();
            bl2 = string.equals("");
            if (!string.equals("EOF")) continue;
            throw new BadMessageFormatException("SMimeHeaders(InputStream) : The stream does not contain a valid S/MIME message.");
        }
        if (this.getValue("Content-Type") == null) {
            throw new BadMessageFormatException("SMimeHeaders(InputStream) : S/MIME headers do not contain \"Content-Type\"");
        }
    }

    public int getMessageType() {
        if (this.getValue("Content-Type").equals("multipart/signed")) {
            return 3;
        }
        String string = this.getValue("smime-type");
        if (string == null) {
            return 5;
        }
        if (string.equals("signed-data")) {
            return 1;
        }
        if (string.equals("enveloped-data")) {
            return 2;
        }
        if (string.equals("certs-only")) {
            return 4;
        }
        return 5;
    }

    public String getValue(String string) {
        return (String)this.map.get(string);
    }

    public Set getMapValues() {
        return this.map.entrySet();
    }

    private String readLine() throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        int n10 = 0;
        boolean bl2 = false;
        while (n10 != 2 && !bl2) {
            int n11 = this.in.read();
            if (n11 == 13 || n11 == 10) {
                ++n10;
                continue;
            }
            if (n11 == -1) {
                bl2 = true;
                continue;
            }
            stringBuffer.append((char)n11);
            n10 = 0;
        }
        if (!bl2) {
            String string = stringBuffer.toString();
            this.parseLine(string);
            return string;
        }
        return "EOF";
    }

    private void parseLine(String string) throws IOException {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            String string3 = null;
            if (string2.indexOf("=") != -1) {
                string3 = "=";
            } else if (string2.indexOf(":") != -1) {
                string3 = ":";
            } else {
                throw new BadMessageFormatException("SMimeHeaders.parseLine() : Invalid S/MIME headers supplied.");
            }
            String string4 = string2.substring(0, string2.indexOf(string3));
            String string5 = string2.substring(string4.length() + 1);
            this.map.put(string4.trim(), string5.trim());
        }
    }

    protected void printMap() {
        Set set = this.map.entrySet();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            System.out.println("Name: " + (String)entry.getKey() + " Value: " + (String)entry.getValue());
        }
    }
}

