/*
 * Decompiled with CFR 0.152.
 */
package au.gov.bafcsi.clapi.packaging.smime;

import au.gov.bafcsi.clapi.common.DigestOid;
import au.gov.bafcsi.clapi.common.Oid;
import au.gov.bafcsi.clapi.common.Oids;
import au.gov.bafcsi.clapi.common.Pkcs7DataOid;
import au.gov.bafcsi.clapi.crypto.CertificateCollection;
import au.gov.bafcsi.clapi.crypto.CsiCertificate;
import au.gov.bafcsi.clapi.packaging.SignedInputStream;
import au.gov.bafcsi.clapi.packaging.cms.full.SignerInfo;
import au.gov.bafcsi.clapi.packaging.exceptions.PackagingException;
import au.gov.bafcsi.clapi.packaging.smime.SMimeHeaders;
import au.gov.bafcsi.clapi.packaging.smime.SignedSMimeInputStream;
import au.gov.bafcsi.clapi.packaging.smime.im;
import au.gov.bafcsi.common.utils.r;
import au.gov.bafcsi.common.utils.w;
import java.io.IOException;
import java.io.InputStream;
import java.security.DigestInputStream;
import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.Collection;

public class MultipartSignedInputStream
extends SignedInputStream {
    private InputStream originalStream = null;
    private im boundaryStream = null;
    private DigestInputStream digestStream = null;
    private MessageDigest digester = null;
    private SignedSMimeInputStream signedStream = null;
    private boolean cancelled = false;
    private boolean interludeCalled = false;

    public MultipartSignedInputStream(SMimeHeaders sMimeHeaders, InputStream inputStream) throws IOException {
        if (sMimeHeaders == null) {
            throw new IllegalArgumentException("MultipartSignedInputStream(SMimeHeaders, InputStream) : SMimeHeaders is null.");
        }
        if (inputStream == null) {
            throw new IllegalArgumentException("MultipartSignedInputStream(SMimeHeaders, InputStream) : InputStream is null.");
        }
        this.originalStream = inputStream;
        if (sMimeHeaders.getMessageType() != 3) {
            throw new IllegalArgumentException("MultipartSignedInputStream(SMimeHeaders, InputStream) : This is not a multipart signed S/MIME message.");
        }
        this.boundaryStream = new im(this.originalStream, sMimeHeaders.getValue("boundary"));
        String string = sMimeHeaders.getValue("micalg");
        if (string == null) {
            throw new PackagingException("MultipartSignedInputStream(SMimeHeaders,InputStream) : Invalid multipart/signed message. Does not contain a 'micalg' header.");
        }
        Oid oid = Oids.getOIDMapping(string);
        try {
            this.digester = DigestOid.getInstance(oid).getDigester();
        }
        catch (GeneralSecurityException generalSecurityException) {
            r.a(w.h, oid + "Not a supported algorithm");
            throw new IllegalArgumentException(generalSecurityException.getMessage());
        }
        this.digestStream = new DigestInputStream(this.boundaryStream, this.digester);
    }

    public int read() throws IOException {
        if (this.interludeCalled) {
            return -1;
        }
        int n10 = this.digestStream.read();
        if (n10 == -1) {
            this.interlude();
        }
        return n10;
    }

    public int read(byte[] byArray, int n10, int n11) throws IOException {
        if (this.interludeCalled) {
            return -1;
        }
        int n12 = this.digestStream.read(byArray, n10, n11);
        if (n12 == -1) {
            this.interlude();
        }
        return n12;
    }

    public void close() throws IOException {
        if (this.signedStream != null) {
            this.signedStream.close();
        }
    }

    private void interlude() throws IOException {
        if (!this.interludeCalled) {
            this.interludeCalled = true;
            this.boundaryStream.reset();
            if (!this.cancelled) {
                SMimeHeaders sMimeHeaders = new SMimeHeaders(this.boundaryStream);
                this.signedStream = new SignedSMimeInputStream(sMimeHeaders, this.boundaryStream);
                ArrayList<MessageDigest> arrayList = new ArrayList<MessageDigest>();
                arrayList.add(this.digester);
                this.signedStream.setDetachedDigesters(arrayList);
            }
        }
    }

    public CsiCertificate verify(CertificateCollection certificateCollection) throws IOException {
        if (this.signedStream == null) {
            throw new IllegalStateException("MultipartSignedInputStream.getVersion() : You must read all the data from the stream before trying to verify the signature.");
        }
        return this.signedStream.verify(certificateCollection);
    }

    public int getVersion() {
        if (this.signedStream == null) {
            throw new IllegalStateException("MultipartSignedInputStream.getVersion() : You must read all the data from the stream before trying to get the version.");
        }
        return this.signedStream.getVersion();
    }

    public Pkcs7DataOid getContentType() {
        if (this.signedStream == null) {
            throw new IllegalStateException("MultipartSignedInputStream.getVersion() : You must read all the data from the stream before trying to get the data content type.");
        }
        return this.signedStream.getContentType();
    }

    public CertificateCollection getCertificates() {
        if (this.signedStream == null) {
            throw new IllegalStateException("MultipartSignedInputStream.getCertificates() : You must read all the data from the stream before trying to get the certificates contained in the message.");
        }
        return this.signedStream.getCertificates();
    }

    public Collection getCRLs() {
        if (this.signedStream == null) {
            throw new IllegalStateException("MultipartSignedInputStream.getCRLs() : You must read all the data from the stream before trying to get the CRLs contained in the message.");
        }
        return this.signedStream.getCRLs();
    }

    public DigestOid getDigestAlgorithm() {
        if (this.signedStream == null) {
            throw new IllegalStateException("MultipartSignedInputStream.getDigestAlgorithm() : You must read all the data from the stream before trying to get the digest algorithm.");
        }
        return this.signedStream.getDigestAlgorithm();
    }

    public SignerInfo getSignerInfo(CsiCertificate csiCertificate) throws CertificateException {
        if (this.signedStream == null) {
            throw new IllegalStateException("MultipartSignedInputStream.getSignerInfo() : You must read all the data from the stream before trying to get SignerInfo of the verifier.");
        }
        return this.signedStream.getSignerInfo(csiCertificate);
    }

    public void setCancelled() {
        this.cancelled = true;
    }

    public void setDetachedDigesters(Collection collection) {
    }

    public boolean isSignatureDetached() {
        return true;
    }

    public boolean isNonRepudiationSigned(CsiCertificate csiCertificate) {
        return this.signedStream.isNonRepudiationSigned(csiCertificate);
    }
}

