/*
 * Decompiled with CFR 0.152.
 */
package au.gov.bafcsi.clapi.packaging.cms.full;

import au.gov.bafcsi.clapi.certs.extensions.KeyUsage;
import au.gov.bafcsi.clapi.common.Attributes;
import au.gov.bafcsi.clapi.common.Oid;
import au.gov.bafcsi.clapi.common.Oids;
import au.gov.bafcsi.clapi.common.Pkcs7DataOid;
import au.gov.bafcsi.clapi.common.SymmetricCipherOid;
import au.gov.bafcsi.clapi.crypto.CertificateCollection;
import au.gov.bafcsi.clapi.crypto.CsiCertificate;
import au.gov.bafcsi.clapi.packaging.cms.full.OriginatorInfo;
import java.util.Iterator;

public final class EnvelopingParameters {
    private CertificateCollection recipients = null;
    private Oid contentType = Oids.data;
    private Oid cipherOID = Oids.tripleDesCBC;
    private OriginatorInfo originator = null;
    private Attributes unprotectedAttrs = null;

    public EnvelopingParameters(CertificateCollection certificateCollection) {
        if (certificateCollection == null) {
            throw new IllegalArgumentException("EnvelopingParameters(CertificateCollection) : CertificateCollection is null.");
        }
        this.recipients = this.removeNonEncryptingCerts(certificateCollection);
        if (this.recipients.isEmpty()) {
            throw new IllegalArgumentException("EnvelopingParameters(CertificateCollection) : There are no certificates in the recipients Collection with the KeyEncipherment usage flag set.");
        }
        this.recipients = certificateCollection;
    }

    CertificateCollection getRecipients() {
        return this.recipients;
    }

    Oid getCipherOID() {
        return this.cipherOID;
    }

    public void setCipherOID(SymmetricCipherOid symmetricCipherOid) {
        if (symmetricCipherOid == null) {
            throw new IllegalArgumentException("EnvelopingParameters.setCipherOID(SymmetricCipherOid) : SymmetricCipherOid is null.");
        }
        if (!this.isValidCipherOID(symmetricCipherOid)) {
            throw new IllegalArgumentException("EnvelopingParameters.setCipherOID(SymmetricCipherOid) : SymmetricCipherOid is not supported.");
        }
        this.cipherOID = symmetricCipherOid;
    }

    Oid getContentType() {
        return this.contentType;
    }

    public void setContentType(Pkcs7DataOid pkcs7DataOid) {
        if (pkcs7DataOid == null) {
            throw new IllegalArgumentException("EnvelopingParameters.setContentType(Pkcs7DataOid) : Pkcs7DataOid is null.");
        }
        this.contentType = pkcs7DataOid;
    }

    OriginatorInfo getOriginator() {
        return this.originator;
    }

    boolean hasOriginator() {
        return this.originator != null;
    }

    public void setOriginatorInfo(OriginatorInfo originatorInfo) {
        this.originator = originatorInfo;
    }

    Attributes getUnprotectedAttrs() {
        return this.unprotectedAttrs;
    }

    public void setUnprotectedAttrs(Attributes attributes) {
        if (attributes != null && attributes.d() != 0) {
            this.unprotectedAttrs = attributes;
        }
    }

    boolean hasAttributes() {
        return this.unprotectedAttrs != null;
    }

    private CertificateCollection removeNonEncryptingCerts(CertificateCollection certificateCollection) {
        Iterator iterator = certificateCollection.iterator();
        while (iterator.hasNext()) {
            CsiCertificate csiCertificate = (CsiCertificate)iterator.next();
            KeyUsage keyUsage = new KeyUsage(csiCertificate.getKeyUsage());
            if (keyUsage.hasUsage(2)) continue;
            iterator.remove();
        }
        return certificateCollection;
    }

    private boolean isValidCipherOID(Oid oid) {
        return oid.equals(Oids.tripleDesCBC) || oid.equals(Oids.aes128CBC);
    }
}

