/*
 * Decompiled with CFR 0.152.
 */
package au.gov.bafcsi.clapi.packaging.cms;

import au.gov.bafcsi.clapi.asn1.bl;
import au.gov.bafcsi.clapi.asn1.coders.CoderException;
import au.gov.bafcsi.clapi.common.DigestOid;
import au.gov.bafcsi.clapi.common.Oid;
import au.gov.bafcsi.clapi.common.Oids;
import au.gov.bafcsi.clapi.common.Pkcs7DataOid;
import au.gov.bafcsi.clapi.crypto.CertificateCollection;
import au.gov.bafcsi.clapi.crypto.CsiCertificate;
import au.gov.bafcsi.clapi.packaging.SignedInputStream;
import au.gov.bafcsi.clapi.packaging.cms.full.CsiInformation;
import au.gov.bafcsi.clapi.packaging.cms.full.SignerInfo;
import au.gov.bafcsi.clapi.packaging.cms.full.cc;
import au.gov.bafcsi.clapi.packaging.cms.full.ct;
import au.gov.bafcsi.clapi.packaging.da;
import au.gov.bafcsi.clapi.packaging.exceptions.BadMessageFormatException;
import au.gov.bafcsi.clapi.packaging.exceptions.PackagingException;
import au.gov.bafcsi.common.utils.q;
import java.io.IOException;
import java.io.InputStream;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class SignedCmsInputStream
extends SignedInputStream {
    private InputStream in = null;
    private cc contentInfo = null;
    private InputStream contentStream = null;
    private ct signedData = null;
    private boolean cancelled = false;

    public SignedCmsInputStream(InputStream inputStream) throws IOException {
        if (inputStream == null) {
            throw new IllegalArgumentException("SignedCmsInputStream(InputStream) : InputStream is null.");
        }
        this.in = inputStream;
        this.contentInfo = new cc();
        try {
            this.contentInfo.decode(this.in);
        }
        catch (CoderException coderException) {
            throw new BadMessageFormatException("Cannot decode contentInfo.", coderException);
        }
        if (!this.contentInfo.j().equals(Oids.signedData)) {
            throw new PackagingException("ContentInfo does not contain a SignedData.");
        }
        this.signedData = (ct)this.contentInfo.k();
        this.contentStream = this.signedData.m();
    }

    public int read() throws IOException {
        try {
            return this.contentStream.read();
        }
        catch (bl bl2) {
            throw new PackagingException("Unable to read from stream.");
        }
        catch (NullPointerException nullPointerException) {
            throw new PackagingException("No content available to read.");
        }
    }

    public int read(byte[] byArray, int n10, int n11) throws IOException {
        try {
            return this.contentStream.read(byArray, n10, n11);
        }
        catch (bl bl2) {
            throw new PackagingException("Unable to read from stream.");
        }
        catch (NullPointerException nullPointerException) {
            throw new PackagingException("No content available to read.");
        }
    }

    public void close() throws IOException {
        if (!this.cancelled) {
            this.contentInfo.i();
            try {
                this.signedData.decodeFully();
            }
            catch (CoderException coderException) {
                throw new PackagingException("Unable to decode stream.", coderException);
            }
        }
        this.contentStream = null;
        this.in.close();
    }

    public boolean isSignatureDetached() {
        return this.contentStream == null;
    }

    public boolean isCertsOnly() {
        return this.signedData.q().j() == 0 && this.signedData.j().size() == 0 && this.signedData.k() != null;
    }

    public void setDetachedDigesters(Collection collection) {
        this.signedData.a(collection);
    }

    public void setDetachedData(InputStream inputStream) throws NoSuchAlgorithmException, IOException {
        Object object;
        if (inputStream == null) {
            throw new IllegalArgumentException("SignedCmsInputStream.setDetachedData(InputStream) - InputStream is null.");
        }
        if (!this.isSignatureDetached()) {
            throw new IllegalStateException();
        }
        ArrayList<MessageDigest> arrayList = new ArrayList<MessageDigest>();
        List list = this.signedData.j();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            object = (Oid)iterator.next();
            MessageDigest messageDigest = MessageDigest.getInstance(Oids.getJCAMapping((Oid)object), q.a());
            arrayList.add(messageDigest);
            inputStream = new DigestInputStream(inputStream, messageDigest);
        }
        int n10 = 0;
        object = new byte[1024];
        while ((n10 = inputStream.read((byte[])object)) != -1) {
        }
        this.setDetachedDigesters(arrayList);
    }

    public CsiCertificate verify(CertificateCollection certificateCollection) throws IOException {
        return this.signedData.a(certificateCollection);
    }

    public boolean isNonRepudiationSigned(CsiCertificate csiCertificate) {
        SignerInfo signerInfo;
        boolean bl2 = false;
        if (csiCertificate == null) {
            return false;
        }
        try {
            signerInfo = this.getSignerInfo(csiCertificate);
        }
        catch (CertificateException certificateException) {
            return false;
        }
        if (signerInfo != null) {
            CsiInformation csiInformation = signerInfo.getCsiInformation();
            bl2 = csiInformation != null ? csiInformation.wasNonRepudiationSigned() : csiCertificate.canDoNonRepudiationSigning() && !csiCertificate.canDoAuthenticationSigning();
        }
        return bl2;
    }

    public int getVersion() {
        return this.signedData.i();
    }

    public Pkcs7DataOid getContentType() {
        return this.signedData.h();
    }

    public CertificateCollection getCertificates() {
        return this.signedData.k();
    }

    public Collection getCRLs() {
        return this.signedData.l();
    }

    public DigestOid getDigestAlgorithm() {
        LinkedList linkedList = new LinkedList(this.signedData.j());
        DigestOid digestOid = DigestOid.getInstance((Oid)linkedList.get(0));
        return digestOid;
    }

    public SignerInfo getSignerInfo(CsiCertificate csiCertificate) throws CertificateException {
        return this.signedData.q().a(csiCertificate);
    }

    public void setCancelled() {
        this.cancelled = true;
        if (this.in instanceof da) {
            ((da)((Object)this.in)).setCancelled();
        }
    }
}

