/*
 * Decompiled with CFR 0.152.
 */
package au.gov.bafcsi.clapi.packaging.cms;

import au.gov.bafcsi.clapi.asn1.coders.CoderException;
import au.gov.bafcsi.clapi.asn1.coders.dz;
import au.gov.bafcsi.clapi.common.Oids;
import au.gov.bafcsi.clapi.packaging.cms.full.EnvelopingParameters;
import au.gov.bafcsi.clapi.packaging.cms.full.cc;
import au.gov.bafcsi.clapi.packaging.cms.full.db;
import au.gov.bafcsi.clapi.packaging.da;
import au.gov.bafcsi.clapi.packaging.dd;
import au.gov.bafcsi.clapi.packaging.exceptions.BadMessageFormatException;
import java.io.IOException;
import java.io.OutputStream;
import javax.crypto.SecretKey;

public class EnvelopedCmsOutputStream
extends dd {
    private OutputStream out = null;
    private cc contentInfo = null;
    private dz berOs = null;
    private OutputStream contentStream = null;
    private SecretKey sessionKey = null;
    private boolean cancelled = false;

    public EnvelopedCmsOutputStream(OutputStream outputStream, EnvelopingParameters envelopingParameters) throws IOException {
        if (outputStream == null) {
            throw new IllegalArgumentException("EnvelopedCmsOutputStream(Collection,EnvelopingParameters) : OutputStream is null.");
        }
        if (envelopingParameters == null) {
            throw new IllegalArgumentException("EnvelopedCmsOutputStream(Collection,EnvelopingParameters) : EnvelopingParameters is null.");
        }
        this.out = outputStream;
        db db2 = new db(envelopingParameters);
        this.sessionKey = db2.b;
        this.contentInfo = new cc(Oids.envelopedData, db2);
        try {
            this.berOs = (dz)this.contentInfo.encode(this.out);
        }
        catch (CoderException coderException) {
            throw new BadMessageFormatException("Cannot encode contentInfo.", coderException);
        }
        this.contentStream = db2.n();
    }

    public void write(int n10) throws IOException {
        this.contentStream.write(n10);
    }

    public void write(byte[] byArray, int n10, int n11) throws IOException {
        this.contentStream.write(byArray, n10, n11);
    }

    public void close() throws IOException {
        if (!this.cancelled) {
            this.contentInfo.i();
        }
        this.contentStream = null;
        this.berOs.flush();
        this.berOs.close();
    }

    public SecretKey getSecretKey() {
        return this.sessionKey;
    }

    public void setCancelled() {
        this.cancelled = true;
        if (this.out instanceof da) {
            ((da)((Object)this.out)).setCancelled();
        }
    }
}

