/*
 * Decompiled with CFR 0.152.
 */
package au.gov.bafcsi.clapi.packaging.cms;

import au.gov.bafcsi.clapi.asn1.coders.CoderException;
import au.gov.bafcsi.clapi.asn1.coders.dz;
import au.gov.bafcsi.clapi.common.Oids;
import au.gov.bafcsi.clapi.packaging.cms.full.EncryptingParameters;
import au.gov.bafcsi.clapi.packaging.cms.full.cc;
import au.gov.bafcsi.clapi.packaging.cms.full.ga;
import au.gov.bafcsi.clapi.packaging.da;
import au.gov.bafcsi.clapi.packaging.exceptions.BadMessageFormatException;
import java.io.IOException;
import java.io.OutputStream;

public class EncryptedCmsOutputStream
extends OutputStream
implements da {
    private OutputStream out = null;
    private cc contentInfo = null;
    private dz berOs = null;
    private OutputStream contentStream = null;
    private boolean cancelled = false;

    public EncryptedCmsOutputStream(OutputStream outputStream, EncryptingParameters encryptingParameters) throws IOException {
        if (outputStream == null) {
            throw new IllegalArgumentException("EncryptedCmsOutputStream(OutputStream,EncryptingParameters) : OutputStream is null.");
        }
        if (encryptingParameters == null) {
            throw new IllegalArgumentException("EncryptedCmsOutputStream(OutputStream,EncryptingParameters) : EncryptingParameters is null.");
        }
        this.out = outputStream;
        ga ga2 = new ga(encryptingParameters);
        this.contentInfo = new cc(Oids.encryptedData, ga2);
        try {
            this.berOs = (dz)this.contentInfo.encode(this.out);
        }
        catch (CoderException coderException) {
            throw new BadMessageFormatException("Cannot encode contentInfo.", coderException);
        }
        this.contentStream = this.contentInfo.h();
    }

    public void write(int n10) throws IOException {
        this.contentStream.write(n10);
    }

    public void write(byte[] byArray, int n10, int n11) throws IOException {
        this.contentStream.write(byArray, n10, n11);
    }

    public void close() throws IOException {
        if (!this.cancelled) {
            this.contentInfo.i();
        }
        this.contentStream = null;
        this.berOs.flush();
        this.berOs.close();
    }

    public void setCancelled() {
        this.cancelled = true;
        if (this.out instanceof da) {
            ((da)((Object)this.out)).setCancelled();
        }
    }
}

