/*
 * Decompiled with CFR 0.152.
 */
package au.gov.bafcsi.clapi.crypto.symmetriccipher;

import au.gov.bafcsi.clapi.crypto.InvalidConfigurationException;
import au.gov.bafcsi.clapi.crypto.symmetriccipher.c1;
import au.gov.bafcsi.clapi.crypto.symmetriccipher.c3;
import au.gov.bafcsi.common.utils.q;
import au.gov.bafcsi.common.utils.r;
import au.gov.bafcsi.common.utils.w;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import javax.crypto.BadPaddingException;
import javax.crypto.CipherSpi;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.ShortBufferException;
import javax.crypto.spec.IvParameterSpec;

abstract class c0
extends CipherSpi {
    public final int a;
    private final String b;
    private c3 c;
    private c1 d;

    protected c0(String string, int n10) {
        if (string == null) {
            throw new IllegalArgumentException("BlockCipher(String, int) - The supplied String is null.");
        }
        this.a = n10;
        this.b = string;
        try {
            this.d = c1.a("CBC", this);
            this.c = c3.a("PKCS5", this.d);
        }
        catch (NoSuchPaddingException noSuchPaddingException) {
            String string2 = "An error occured while attempting to get the default padding and cipher mode. This error should not have happened since the default padding and cipher modes are in the CSI api. The originating error is " + noSuchPaddingException;
            r.a(w.f, string2, noSuchPaddingException);
            throw new InvalidConfigurationException(string2);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            String string3 = "An error occured while attempting to get the default padding and cipher mode. This error should not have happened since the default padding and cipher modes are in the CSI api. The originating error is " + noSuchAlgorithmException;
            r.a(w.f, string3, noSuchAlgorithmException);
            throw new InvalidConfigurationException(string3);
        }
    }

    public final Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }

    protected final void engineSetMode(String string) throws NoSuchAlgorithmException {
        if (string == null) {
            throw new IllegalArgumentException("BlockCipher.engineSetMode(String) - The supplied String is null.");
        }
        this.d = c1.a(string, this);
    }

    protected final void engineSetPadding(String string) throws NoSuchPaddingException {
        if (string == null) {
            throw new IllegalArgumentException("BlockCipher.engineSetPadding(String) - The supplied String is null.");
        }
        this.c = c3.a(string, this.d);
    }

    protected final int engineGetBlockSize() {
        return this.c.a();
    }

    protected final int engineGetOutputSize(int n10) {
        return this.c.a(n10);
    }

    protected final byte[] engineGetIV() {
        return this.c.c();
    }

    protected final AlgorithmParameters engineGetParameters() {
        AlgorithmParameterSpec algorithmParameterSpec = this.c.b();
        if (algorithmParameterSpec == null) {
            return null;
        }
        try {
            AlgorithmParameters algorithmParameters = q.f(this.b);
            algorithmParameters.init(algorithmParameterSpec);
            return algorithmParameters;
        }
        catch (InvalidParameterSpecException invalidParameterSpecException) {
            throw new RuntimeException("An unexpected error has occured. Could not initialise " + this.b + " algorithm parameter with a parameter spec of type " + algorithmParameterSpec.getClass().getName());
        }
    }

    protected final void engineInit(int n10, Key key, SecureRandom secureRandom) throws InvalidKeyException {
        if (key == null) {
            throw new IllegalArgumentException("BlockCipher.engineInit(int, Key, SecureRandom) - The supplied Key is null.");
        }
        if (n10 == 2) {
            throw new IllegalArgumentException("The cipher " + this.getClass().getName() + " does not support init methods" + " that do not pass in an Initialisation Vector in decrypt mode." + " Please use an alternative init method when decrypting.");
        }
        try {
            this.engineInit(n10, key, this.c.b(), secureRandom);
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            String string = "An invalid AlgorithmParameterSpec was returned by the internal padding object. The originating error was " + invalidAlgorithmParameterException.toString();
            r.a(w.f, string, invalidAlgorithmParameterException);
            throw new InternalError(string);
        }
    }

    protected void engineInit(int n10, Key key, AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidKeyException, InvalidAlgorithmParameterException {
        if (algorithmParameterSpec == null) {
            throw new IllegalArgumentException("BlockCipher.engineInit(int, Key, AlgorithmParameterSpec, SecureRandom) - The supplied AlgorithmParameterSpec is null.");
        }
        boolean bl2 = false;
        if (!(algorithmParameterSpec instanceof IvParameterSpec)) {
            throw new InvalidAlgorithmParameterException("The Cipher " + this.getClass().getName() + " only accepts" + " AlgorithmParameterSpec's of type IvParameterSpec");
        }
        if (n10 == 3 || n10 == 4) {
            throw new UnsupportedOperationException("Cipher.WRAP_MODE and Cipher.UNWRAP_MODE are not supported in " + this.getClass().getName());
        }
        bl2 = n10 == 2;
        this.c.a(bl2, key, algorithmParameterSpec, secureRandom);
    }

    protected void engineInit(int n10, Key key, AlgorithmParameters algorithmParameters, SecureRandom secureRandom) throws InvalidKeyException, InvalidAlgorithmParameterException {
        Object t2;
        try {
            t2 = algorithmParameters.getParameterSpec(IvParameterSpec.class);
        }
        catch (InvalidParameterSpecException invalidParameterSpecException) {
            throw new InvalidAlgorithmParameterException("A problem occured when attempting to convert the specified AlgorithmParameters to an AlgoritmParameterSpec. The originating error is " + invalidParameterSpecException.getMessage() + ". Note that Cipher " + this.getClass().getName() + " only accepts" + " AlgorithmParameter's of type CsiIvParameters.");
        }
        this.engineInit(n10, key, (AlgorithmParameterSpec)t2, secureRandom);
    }

    protected final int engineUpdate(byte[] byArray, int n10, int n11, byte[] byArray2, int n12) throws ShortBufferException {
        if (n11 == 0) {
            return 0;
        }
        return this.c.a(byArray, n10, n11, byArray2, n12);
    }

    protected final byte[] engineUpdate(byte[] byArray, int n10, int n11) {
        if (n11 == 0) {
            return null;
        }
        try {
            byte[] byArray2 = new byte[this.engineGetOutputSize(n11)];
            int n12 = this.engineUpdate(byArray, n10, n11, byArray2, 0);
            if (n12 != byArray2.length) {
                byte[] byArray3 = new byte[n12];
                System.arraycopy(byArray2, 0, byArray3, 0, n12);
                byArray2 = byArray3;
            }
            return byArray2;
        }
        catch (ShortBufferException shortBufferException) {
            shortBufferException.printStackTrace();
            throw new RuntimeException("Error: A sanity check failed that should not have been reachable. Please contact the CSI development team.");
        }
    }

    protected final int engineDoFinal(byte[] byArray, int n10, int n11, byte[] byArray2, int n12) throws ShortBufferException, IllegalBlockSizeException, BadPaddingException {
        int n13 = this.c.b(byArray, n10, n11, byArray2, n12);
        if (n13 < 0 || n13 > this.engineGetOutputSize(n11)) {
            String string = "BadPaddingException in BlockCipher.engineDoFinal (bytesInOutput = " + n13 + ", outputSize = " + this.engineGetOutputSize(n11) + " bytes).";
            throw new BadPaddingException(string);
        }
        return n13;
    }

    protected final byte[] engineDoFinal(byte[] byArray, int n10, int n11) throws IllegalBlockSizeException, BadPaddingException {
        try {
            byte[] byArray2 = new byte[this.engineGetOutputSize(n11)];
            int n12 = this.engineDoFinal(byArray, n10, n11, byArray2, 0);
            if (n12 != byArray2.length) {
                byte[] byArray3 = new byte[n12];
                System.arraycopy(byArray2, 0, byArray3, 0, n12);
                byArray2 = byArray3;
            }
            return byArray2;
        }
        catch (ShortBufferException shortBufferException) {
            shortBufferException.printStackTrace();
            throw new RuntimeException("Error: A sanity check failed that should not have been reachable. Please contact the CSI development team.");
        }
    }

    abstract void coreInit(Key var1, boolean var2) throws InvalidKeyException;

    abstract void coreCrypt(byte[] var1, int var2, byte[] var3, int var4);

    protected final int engineGetKeySize(Key key) throws InvalidKeyException {
        if (!(key instanceof SecretKey)) {
            throw new InvalidKeyException("BlockCipher.engineGetKeySize(Key key) - The supplied Key is not an instanceof SecretKey.");
        }
        byte[] byArray = key.getEncoded();
        if (byArray == null) {
            throw new InvalidKeyException("BlockCipher.engineGetKeySize(Key key) - key.getEncoded() returned null.");
        }
        return byArray.length * 8;
    }
}

