/*
 * Decompiled with CFR 0.152.
 */
package au.gov.bafcsi.clapi.crypto.symmetriccipher;

import au.gov.bafcsi.clapi.crypto.symmetriccipher.c0;
import au.gov.bafcsi.clapi.crypto.symmetriccipher.c6;
import au.gov.bafcsi.clapi.crypto.symmetriccipher.di;
import java.security.InvalidKeyException;
import java.security.Key;

public final class TripleDes
extends c0 {
    private static final int BLOCK_SIZE = 8;
    private static final int KEY_LENGTH = 24;
    private static final int ALT_KEY_LENGTH = 21;
    private c6 m_des1 = new c6();
    private c6 m_des2 = new c6();
    private c6 m_des3 = new c6();

    public TripleDes() {
        super("3DES", 8);
    }

    protected void coreInit(Key key, boolean bl2) throws InvalidKeyException {
        if (key == null) {
            throw new InvalidKeyException("Key missing. Key cannot be null.");
        }
        if (!key.getFormat().equalsIgnoreCase("RAW")) {
            throw new InvalidKeyException("Key is in the Wrong format: RAW bytes needed");
        }
        byte[] byArray = key.getEncoded();
        if (byArray == null) {
            throw new InvalidKeyException("Null user key");
        }
        int n10 = 0;
        if (byArray.length == 24) {
            n10 = 8;
        } else if (byArray.length == 21) {
            n10 = 7;
        } else {
            throw new InvalidKeyException("Invalid user key length");
        }
        byte[] byArray2 = new byte[n10];
        System.arraycopy(byArray, 0, byArray2, 0, n10);
        di di2 = new di("DES", byArray2);
        this.m_des1.coreInit(di2, bl2);
        System.arraycopy(byArray, n10, byArray2, 0, n10);
        di2 = new di("DES", byArray2);
        this.m_des2.coreInit(di2, !bl2);
        System.arraycopy(byArray, n10 + n10, byArray2, 0, n10);
        di2 = new di("DES", byArray2);
        this.m_des3.coreInit(di2, bl2);
        if (bl2) {
            c6 c62 = this.m_des1;
            this.m_des1 = this.m_des3;
            this.m_des3 = c62;
        }
    }

    protected void coreCrypt(byte[] byArray, int n10, byte[] byArray2, int n11) {
        this.m_des1.coreCrypt(byArray, n10, byArray2, n11);
        this.m_des2.coreCrypt(byArray2, n11, byArray2, n11);
        this.m_des3.coreCrypt(byArray2, n11, byArray2, n11);
    }
}

