/*
 * Decompiled with CFR 0.152.
 */
package au.gov.bafcsi.clapi.crypto.symmetriccipher;

import au.gov.bafcsi.clapi.crypto.symmetriccipher.di;
import au.gov.bafcsi.clapi.crypto.symmetriccipher.g6;
import java.security.spec.InvalidKeySpecException;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;

public final class RijndaelKeyFactory
extends g6 {
    private static final int BYTE_LENGTH_FOR_128_BIT_KEYS = 16;
    private static final int BYTE_LENGTH_FOR_192_BIT_KEYS = 24;
    private static final int BYTE_LENGTH_FOR_256_BIT_KEYS = 32;

    final SecretKey parseSecretKey(SecretKeySpec secretKeySpec) throws InvalidKeySpecException {
        di di2 = null;
        byte[] byArray = null;
        int n10 = 0;
        RijndaelKeyFactory.checkValidAlgorithmName(secretKeySpec);
        n10 = RijndaelKeyFactory.getKeyByteLength(secretKeySpec);
        if (secretKeySpec.getEncoded().length == n10) {
            byArray = secretKeySpec.getEncoded();
        } else {
            byArray = new byte[n10];
            System.arraycopy(secretKeySpec.getEncoded(), 0, byArray, 0, n10);
        }
        di2 = new di("AES", byArray);
        return di2;
    }

    private static void checkValidAlgorithmName(SecretKeySpec secretKeySpec) throws InvalidKeySpecException {
        String[] stringArray = new String[]{"AES", "RIJNDAEL"};
        String string = "";
        boolean bl2 = false;
        string = secretKeySpec.getAlgorithm();
        for (int i10 = 0; i10 < stringArray.length; ++i10) {
            if (!string.toUpperCase().equals(stringArray[i10])) continue;
            bl2 = true;
            break;
        }
        if (!bl2) {
            throw new InvalidKeySpecException("The keySpec does not contain a recognised algoritm name. Expected algoritm name was AES, the unrecognised algorithm name was " + secretKeySpec.getAlgorithm());
        }
    }

    private static int getKeyByteLength(SecretKeySpec secretKeySpec) throws InvalidKeySpecException {
        byte[] byArray = null;
        int n10 = 0;
        byArray = secretKeySpec.getEncoded();
        if (byArray.length < 16) {
            throw new InvalidKeySpecException("The keySpec does not contain enough encoding bits to create an AES key. The keySpec only contains " + byArray.length * 8);
        }
        n10 = byArray.length >= 32 ? 32 : (byArray.length >= 24 ? 24 : 16);
        return n10;
    }
}

