/*
 * Decompiled with CFR 0.152.
 */
package au.gov.bafcsi.clapi.crypto.symmetriccipher;

import au.gov.bafcsi.clapi.crypto.symmetriccipher.c0;
import java.security.InvalidKeyException;
import java.security.Key;

public final class Rijndael
extends c0 {
    private static final int BLOCK_SIZE = 16;
    private static final String SS = "\u637c\u777b\uf26b\u6fc5\u3001\u672b\ufed7\uab76\uca82\uc97d\ufa59\u47f0\uadd4\ua2af\u9ca4\u72c0\ub7fd\u9326\u363f\uf7cc\u34a5\ue5f1\u71d8\u3115\u04c7\u23c3\u1896\u059a\u0712\u80e2\ueb27\ub275\u0983\u2c1a\u1b6e\u5aa0\u523b\ud6b3\u29e3\u2f84\u53d1\u00ed\u20fc\ub15b\u6acb\ube39\u4a4c\u58cf\ud0ef\uaafb\u434d\u3385\u45f9\u027f\u503c\u9fa8\u51a3\u408f\u929d\u38f5\ubcb6\uda21\u10ff\uf3d2\ucd0c\u13ec\u5f97\u4417\uc4a7\u7e3d\u645d\u1973\u6081\u4fdc\u222a\u9088\u46ee\ub814\ude5e\u0bdb\ue032\u3a0a\u4906\u245c\uc2d3\uac62\u9195\ue479\ue7c8\u376d\u8dd5\u4ea9\u6c56\uf4ea\u657a\uae08\uba78\u252e\u1ca6\ub4c6\ue8dd\u741f\u4bbd\u8b8a\u703e\ub566\u4803\uf60e\u6135\u57b9\u86c1\u1d9e\ue1f8\u9811\u69d9\u8e94\u9b1e\u87e9\uce55\u28df\u8ca1\u890d\ubfe6\u4268\u4199\u2d0f\ub054\ubb16";
    private static final byte[] S;
    private static final byte[] Si;
    private static final int[] T1;
    private static final int[] T2;
    private static final int[] T3;
    private static final int[] T4;
    private static final int[] T5;
    private static final int[] T6;
    private static final int[] T7;
    private static final int[] T8;
    private static final int[] U1;
    private static final int[] U2;
    private static final int[] U3;
    private static final int[] U4;
    private static final byte[] RCON;
    private boolean ROUNDS_12;
    private boolean ROUNDS_14;
    private boolean m_decrypt;
    private int[] m_K;
    private int m_limit;

    public Rijndael() {
        super("AES", 16);
    }

    protected void coreInit(Key key, boolean bl2) throws InvalidKeyException {
        if (key == null) {
            throw new InvalidKeyException("Key missing");
        }
        if (!key.getFormat().equalsIgnoreCase("RAW")) {
            throw new InvalidKeyException("Wrong format: RAW bytes needed");
        }
        byte[] byArray = key.getEncoded();
        if (byArray == null) {
            throw new InvalidKeyException("RAW bytes missing");
        }
        int n10 = byArray.length;
        if (n10 != 16 && n10 != 24 && n10 != 32) {
            throw new InvalidKeyException("Invalid user key length");
        }
        this.m_decrypt = bl2;
        this.m_K = Rijndael.makeKey(byArray, bl2);
        if (bl2) {
            Rijndael.invertKey(this.m_K);
        }
        this.ROUNDS_12 = n10 >= 24;
        this.ROUNDS_14 = n10 == 32;
        this.m_limit = Rijndael.getRounds(n10) * 4;
    }

    protected void coreCrypt(byte[] byArray, int n10, byte[] byArray2, int n11) {
        if (this.m_decrypt) {
            this.blockDecrypt(byArray, n10, byArray2, n11);
        } else {
            this.blockEncrypt(byArray, n10, byArray2, n11);
        }
    }

    private void blockEncrypt(byte[] byArray, int n10, byte[] byArray2, int n11) {
        int n12;
        int n13 = 0;
        int n14 = (byArray[n10++] << 24 | (byArray[n10++] & 0xFF) << 16 | (byArray[n10++] & 0xFF) << 8 | byArray[n10++] & 0xFF) ^ this.m_K[n13++];
        int n15 = (byArray[n10++] << 24 | (byArray[n10++] & 0xFF) << 16 | (byArray[n10++] & 0xFF) << 8 | byArray[n10++] & 0xFF) ^ this.m_K[n13++];
        int n16 = (byArray[n10++] << 24 | (byArray[n10++] & 0xFF) << 16 | (byArray[n10++] & 0xFF) << 8 | byArray[n10++] & 0xFF) ^ this.m_K[n13++];
        int n17 = (byArray[n10++] << 24 | (byArray[n10++] & 0xFF) << 16 | (byArray[n10++] & 0xFF) << 8 | byArray[n10++] & 0xFF) ^ this.m_K[n13++];
        while (n13 < this.m_limit) {
            n12 = T1[n14 >>> 24] ^ T2[n15 >>> 16 & 0xFF] ^ T3[n16 >>> 8 & 0xFF] ^ T4[n17 & 0xFF] ^ this.m_K[n13++];
            int n18 = T1[n15 >>> 24] ^ T2[n16 >>> 16 & 0xFF] ^ T3[n17 >>> 8 & 0xFF] ^ T4[n14 & 0xFF] ^ this.m_K[n13++];
            int n19 = T1[n16 >>> 24] ^ T2[n17 >>> 16 & 0xFF] ^ T3[n14 >>> 8 & 0xFF] ^ T4[n15 & 0xFF] ^ this.m_K[n13++];
            n17 = T1[n17 >>> 24] ^ T2[n14 >>> 16 & 0xFF] ^ T3[n15 >>> 8 & 0xFF] ^ T4[n16 & 0xFF] ^ this.m_K[n13++];
            n14 = n12;
            n15 = n18;
            n16 = n19;
        }
        n12 = this.m_K[n13++];
        byArray2[n11++] = (byte)(S[n14 >>> 24] ^ n12 >>> 24);
        byArray2[n11++] = (byte)(S[n15 >>> 16 & 0xFF] ^ n12 >>> 16);
        byArray2[n11++] = (byte)(S[n16 >>> 8 & 0xFF] ^ n12 >>> 8);
        byArray2[n11++] = (byte)(S[n17 & 0xFF] ^ n12);
        n12 = this.m_K[n13++];
        byArray2[n11++] = (byte)(S[n15 >>> 24] ^ n12 >>> 24);
        byArray2[n11++] = (byte)(S[n16 >>> 16 & 0xFF] ^ n12 >>> 16);
        byArray2[n11++] = (byte)(S[n17 >>> 8 & 0xFF] ^ n12 >>> 8);
        byArray2[n11++] = (byte)(S[n14 & 0xFF] ^ n12);
        n12 = this.m_K[n13++];
        byArray2[n11++] = (byte)(S[n16 >>> 24] ^ n12 >>> 24);
        byArray2[n11++] = (byte)(S[n17 >>> 16 & 0xFF] ^ n12 >>> 16);
        byArray2[n11++] = (byte)(S[n14 >>> 8 & 0xFF] ^ n12 >>> 8);
        byArray2[n11++] = (byte)(S[n15 & 0xFF] ^ n12);
        n12 = this.m_K[n13++];
        byArray2[n11++] = (byte)(S[n17 >>> 24] ^ n12 >>> 24);
        byArray2[n11++] = (byte)(S[n14 >>> 16 & 0xFF] ^ n12 >>> 16);
        byArray2[n11++] = (byte)(S[n15 >>> 8 & 0xFF] ^ n12 >>> 8);
        byArray2[n11] = (byte)(S[n16 & 0xFF] ^ n12);
    }

    private void blockDecrypt(byte[] byArray, int n10, byte[] byArray2, int n11) {
        int n12;
        int n13;
        int n14;
        int n15 = 8;
        int n16 = (byArray[n10++] << 24 | (byArray[n10++] & 0xFF) << 16 | (byArray[n10++] & 0xFF) << 8 | byArray[n10++] & 0xFF) ^ this.m_K[4];
        int n17 = (byArray[n10++] << 24 | (byArray[n10++] & 0xFF) << 16 | (byArray[n10++] & 0xFF) << 8 | byArray[n10++] & 0xFF) ^ this.m_K[5];
        int n18 = (byArray[n10++] << 24 | (byArray[n10++] & 0xFF) << 16 | (byArray[n10++] & 0xFF) << 8 | byArray[n10++] & 0xFF) ^ this.m_K[6];
        int n19 = (byArray[n10++] << 24 | (byArray[n10++] & 0xFF) << 16 | (byArray[n10++] & 0xFF) << 8 | byArray[n10] & 0xFF) ^ this.m_K[7];
        if (this.ROUNDS_12) {
            n14 = T5[n16 >>> 24] ^ T6[n19 >>> 16 & 0xFF] ^ T7[n18 >>> 8 & 0xFF] ^ T8[n17 & 0xFF] ^ this.m_K[n15++];
            n13 = T5[n17 >>> 24] ^ T6[n16 >>> 16 & 0xFF] ^ T7[n19 >>> 8 & 0xFF] ^ T8[n18 & 0xFF] ^ this.m_K[n15++];
            n12 = T5[n18 >>> 24] ^ T6[n17 >>> 16 & 0xFF] ^ T7[n16 >>> 8 & 0xFF] ^ T8[n19 & 0xFF] ^ this.m_K[n15++];
            n19 = T5[n19 >>> 24] ^ T6[n18 >>> 16 & 0xFF] ^ T7[n17 >>> 8 & 0xFF] ^ T8[n16 & 0xFF] ^ this.m_K[n15++];
            n16 = T5[n14 >>> 24] ^ T6[n19 >>> 16 & 0xFF] ^ T7[n12 >>> 8 & 0xFF] ^ T8[n13 & 0xFF] ^ this.m_K[n15++];
            n17 = T5[n13 >>> 24] ^ T6[n14 >>> 16 & 0xFF] ^ T7[n19 >>> 8 & 0xFF] ^ T8[n12 & 0xFF] ^ this.m_K[n15++];
            n18 = T5[n12 >>> 24] ^ T6[n13 >>> 16 & 0xFF] ^ T7[n14 >>> 8 & 0xFF] ^ T8[n19 & 0xFF] ^ this.m_K[n15++];
            n19 = T5[n19 >>> 24] ^ T6[n12 >>> 16 & 0xFF] ^ T7[n13 >>> 8 & 0xFF] ^ T8[n14 & 0xFF] ^ this.m_K[n15++];
            if (this.ROUNDS_14) {
                n14 = T5[n16 >>> 24] ^ T6[n19 >>> 16 & 0xFF] ^ T7[n18 >>> 8 & 0xFF] ^ T8[n17 & 0xFF] ^ this.m_K[n15++];
                n13 = T5[n17 >>> 24] ^ T6[n16 >>> 16 & 0xFF] ^ T7[n19 >>> 8 & 0xFF] ^ T8[n18 & 0xFF] ^ this.m_K[n15++];
                n12 = T5[n18 >>> 24] ^ T6[n17 >>> 16 & 0xFF] ^ T7[n16 >>> 8 & 0xFF] ^ T8[n19 & 0xFF] ^ this.m_K[n15++];
                n19 = T5[n19 >>> 24] ^ T6[n18 >>> 16 & 0xFF] ^ T7[n17 >>> 8 & 0xFF] ^ T8[n16 & 0xFF] ^ this.m_K[n15++];
                n16 = T5[n14 >>> 24] ^ T6[n19 >>> 16 & 0xFF] ^ T7[n12 >>> 8 & 0xFF] ^ T8[n13 & 0xFF] ^ this.m_K[n15++];
                n17 = T5[n13 >>> 24] ^ T6[n14 >>> 16 & 0xFF] ^ T7[n19 >>> 8 & 0xFF] ^ T8[n12 & 0xFF] ^ this.m_K[n15++];
                n18 = T5[n12 >>> 24] ^ T6[n13 >>> 16 & 0xFF] ^ T7[n14 >>> 8 & 0xFF] ^ T8[n19 & 0xFF] ^ this.m_K[n15++];
                n19 = T5[n19 >>> 24] ^ T6[n12 >>> 16 & 0xFF] ^ T7[n13 >>> 8 & 0xFF] ^ T8[n14 & 0xFF] ^ this.m_K[n15++];
            }
        }
        n14 = T5[n16 >>> 24] ^ T6[n19 >>> 16 & 0xFF] ^ T7[n18 >>> 8 & 0xFF] ^ T8[n17 & 0xFF] ^ this.m_K[n15++];
        n13 = T5[n17 >>> 24] ^ T6[n16 >>> 16 & 0xFF] ^ T7[n19 >>> 8 & 0xFF] ^ T8[n18 & 0xFF] ^ this.m_K[n15++];
        n12 = T5[n18 >>> 24] ^ T6[n17 >>> 16 & 0xFF] ^ T7[n16 >>> 8 & 0xFF] ^ T8[n19 & 0xFF] ^ this.m_K[n15++];
        n19 = T5[n19 >>> 24] ^ T6[n18 >>> 16 & 0xFF] ^ T7[n17 >>> 8 & 0xFF] ^ T8[n16 & 0xFF] ^ this.m_K[n15++];
        n16 = T5[n14 >>> 24] ^ T6[n19 >>> 16 & 0xFF] ^ T7[n12 >>> 8 & 0xFF] ^ T8[n13 & 0xFF] ^ this.m_K[n15++];
        n17 = T5[n13 >>> 24] ^ T6[n14 >>> 16 & 0xFF] ^ T7[n19 >>> 8 & 0xFF] ^ T8[n12 & 0xFF] ^ this.m_K[n15++];
        n18 = T5[n12 >>> 24] ^ T6[n13 >>> 16 & 0xFF] ^ T7[n14 >>> 8 & 0xFF] ^ T8[n19 & 0xFF] ^ this.m_K[n15++];
        n19 = T5[n19 >>> 24] ^ T6[n12 >>> 16 & 0xFF] ^ T7[n13 >>> 8 & 0xFF] ^ T8[n14 & 0xFF] ^ this.m_K[n15++];
        n14 = T5[n16 >>> 24] ^ T6[n19 >>> 16 & 0xFF] ^ T7[n18 >>> 8 & 0xFF] ^ T8[n17 & 0xFF] ^ this.m_K[n15++];
        n13 = T5[n17 >>> 24] ^ T6[n16 >>> 16 & 0xFF] ^ T7[n19 >>> 8 & 0xFF] ^ T8[n18 & 0xFF] ^ this.m_K[n15++];
        n12 = T5[n18 >>> 24] ^ T6[n17 >>> 16 & 0xFF] ^ T7[n16 >>> 8 & 0xFF] ^ T8[n19 & 0xFF] ^ this.m_K[n15++];
        n19 = T5[n19 >>> 24] ^ T6[n18 >>> 16 & 0xFF] ^ T7[n17 >>> 8 & 0xFF] ^ T8[n16 & 0xFF] ^ this.m_K[n15++];
        n16 = T5[n14 >>> 24] ^ T6[n19 >>> 16 & 0xFF] ^ T7[n12 >>> 8 & 0xFF] ^ T8[n13 & 0xFF] ^ this.m_K[n15++];
        n17 = T5[n13 >>> 24] ^ T6[n14 >>> 16 & 0xFF] ^ T7[n19 >>> 8 & 0xFF] ^ T8[n12 & 0xFF] ^ this.m_K[n15++];
        n18 = T5[n12 >>> 24] ^ T6[n13 >>> 16 & 0xFF] ^ T7[n14 >>> 8 & 0xFF] ^ T8[n19 & 0xFF] ^ this.m_K[n15++];
        n19 = T5[n19 >>> 24] ^ T6[n12 >>> 16 & 0xFF] ^ T7[n13 >>> 8 & 0xFF] ^ T8[n14 & 0xFF] ^ this.m_K[n15++];
        n14 = T5[n16 >>> 24] ^ T6[n19 >>> 16 & 0xFF] ^ T7[n18 >>> 8 & 0xFF] ^ T8[n17 & 0xFF] ^ this.m_K[n15++];
        n13 = T5[n17 >>> 24] ^ T6[n16 >>> 16 & 0xFF] ^ T7[n19 >>> 8 & 0xFF] ^ T8[n18 & 0xFF] ^ this.m_K[n15++];
        n12 = T5[n18 >>> 24] ^ T6[n17 >>> 16 & 0xFF] ^ T7[n16 >>> 8 & 0xFF] ^ T8[n19 & 0xFF] ^ this.m_K[n15++];
        n19 = T5[n19 >>> 24] ^ T6[n18 >>> 16 & 0xFF] ^ T7[n17 >>> 8 & 0xFF] ^ T8[n16 & 0xFF] ^ this.m_K[n15++];
        n16 = T5[n14 >>> 24] ^ T6[n19 >>> 16 & 0xFF] ^ T7[n12 >>> 8 & 0xFF] ^ T8[n13 & 0xFF] ^ this.m_K[n15++];
        n17 = T5[n13 >>> 24] ^ T6[n14 >>> 16 & 0xFF] ^ T7[n19 >>> 8 & 0xFF] ^ T8[n12 & 0xFF] ^ this.m_K[n15++];
        n18 = T5[n12 >>> 24] ^ T6[n13 >>> 16 & 0xFF] ^ T7[n14 >>> 8 & 0xFF] ^ T8[n19 & 0xFF] ^ this.m_K[n15++];
        n19 = T5[n19 >>> 24] ^ T6[n12 >>> 16 & 0xFF] ^ T7[n13 >>> 8 & 0xFF] ^ T8[n14 & 0xFF] ^ this.m_K[n15++];
        n14 = T5[n16 >>> 24] ^ T6[n19 >>> 16 & 0xFF] ^ T7[n18 >>> 8 & 0xFF] ^ T8[n17 & 0xFF] ^ this.m_K[n15++];
        n13 = T5[n17 >>> 24] ^ T6[n16 >>> 16 & 0xFF] ^ T7[n19 >>> 8 & 0xFF] ^ T8[n18 & 0xFF] ^ this.m_K[n15++];
        n12 = T5[n18 >>> 24] ^ T6[n17 >>> 16 & 0xFF] ^ T7[n16 >>> 8 & 0xFF] ^ T8[n19 & 0xFF] ^ this.m_K[n15++];
        n19 = T5[n19 >>> 24] ^ T6[n18 >>> 16 & 0xFF] ^ T7[n17 >>> 8 & 0xFF] ^ T8[n16 & 0xFF] ^ this.m_K[n15++];
        n16 = T5[n14 >>> 24] ^ T6[n19 >>> 16 & 0xFF] ^ T7[n12 >>> 8 & 0xFF] ^ T8[n13 & 0xFF] ^ this.m_K[n15++];
        n17 = T5[n13 >>> 24] ^ T6[n14 >>> 16 & 0xFF] ^ T7[n19 >>> 8 & 0xFF] ^ T8[n12 & 0xFF] ^ this.m_K[n15++];
        n18 = T5[n12 >>> 24] ^ T6[n13 >>> 16 & 0xFF] ^ T7[n14 >>> 8 & 0xFF] ^ T8[n19 & 0xFF] ^ this.m_K[n15++];
        n19 = T5[n19 >>> 24] ^ T6[n12 >>> 16 & 0xFF] ^ T7[n13 >>> 8 & 0xFF] ^ T8[n14 & 0xFF] ^ this.m_K[n15++];
        n14 = T5[n16 >>> 24] ^ T6[n19 >>> 16 & 0xFF] ^ T7[n18 >>> 8 & 0xFF] ^ T8[n17 & 0xFF] ^ this.m_K[n15++];
        n13 = T5[n17 >>> 24] ^ T6[n16 >>> 16 & 0xFF] ^ T7[n19 >>> 8 & 0xFF] ^ T8[n18 & 0xFF] ^ this.m_K[n15++];
        n12 = T5[n18 >>> 24] ^ T6[n17 >>> 16 & 0xFF] ^ T7[n16 >>> 8 & 0xFF] ^ T8[n19 & 0xFF] ^ this.m_K[n15++];
        n19 = T5[n19 >>> 24] ^ T6[n18 >>> 16 & 0xFF] ^ T7[n17 >>> 8 & 0xFF] ^ T8[n16 & 0xFF] ^ this.m_K[n15++];
        n17 = this.m_K[0];
        byArray2[n11++] = (byte)(Si[n14 >>> 24] ^ n17 >>> 24);
        byArray2[n11++] = (byte)(Si[n19 >>> 16 & 0xFF] ^ n17 >>> 16);
        byArray2[n11++] = (byte)(Si[n12 >>> 8 & 0xFF] ^ n17 >>> 8);
        byArray2[n11++] = (byte)(Si[n13 & 0xFF] ^ n17);
        n17 = this.m_K[1];
        byArray2[n11++] = (byte)(Si[n13 >>> 24] ^ n17 >>> 24);
        byArray2[n11++] = (byte)(Si[n14 >>> 16 & 0xFF] ^ n17 >>> 16);
        byArray2[n11++] = (byte)(Si[n19 >>> 8 & 0xFF] ^ n17 >>> 8);
        byArray2[n11++] = (byte)(Si[n12 & 0xFF] ^ n17);
        n17 = this.m_K[2];
        byArray2[n11++] = (byte)(Si[n12 >>> 24] ^ n17 >>> 24);
        byArray2[n11++] = (byte)(Si[n13 >>> 16 & 0xFF] ^ n17 >>> 16);
        byArray2[n11++] = (byte)(Si[n14 >>> 8 & 0xFF] ^ n17 >>> 8);
        byArray2[n11++] = (byte)(Si[n19 & 0xFF] ^ n17);
        n17 = this.m_K[3];
        byArray2[n11++] = (byte)(Si[n19 >>> 24] ^ n17 >>> 24);
        byArray2[n11++] = (byte)(Si[n12 >>> 16 & 0xFF] ^ n17 >>> 16);
        byArray2[n11++] = (byte)(Si[n13 >>> 8 & 0xFF] ^ n17 >>> 8);
        byArray2[n11] = (byte)(Si[n14 & 0xFF] ^ n17);
    }

    private static int[] makeKey(byte[] byArray, boolean bl2) throws InvalidKeyException {
        int n10;
        int n11 = Rijndael.getRounds(byArray.length);
        int n12 = (n11 + 1) * 4;
        int[] nArray = new int[n12];
        int n13 = byArray.length / 4;
        int[] nArray2 = new int[n13];
        int n14 = 0;
        int n15 = 0;
        while (n14 < n13) {
            nArray2[n14++] = byArray[n15++] << 24 | (byArray[n15++] & 0xFF) << 16 | (byArray[n15++] & 0xFF) << 8 | byArray[n15++] & 0xFF;
        }
        for (n10 = 0; n10 < n13; ++n10) {
            nArray[n10] = nArray2[n10];
        }
        int n16 = 0;
        while (n10 < n12) {
            int n17 = nArray2[n13 - 1];
            nArray2[0] = nArray2[0] ^ (S[n17 >>> 16 & 0xFF] << 24 ^ (S[n17 >>> 8 & 0xFF] & 0xFF) << 16 ^ (S[n17 & 0xFF] & 0xFF) << 8 ^ S[n17 >>> 24] & 0xFF ^ RCON[n16++] << 24);
            if (n13 != 8) {
                n14 = 1;
                n15 = 0;
                while (n14 < n13) {
                    int n18 = n14++;
                    nArray2[n18] = nArray2[n18] ^ nArray2[n15++];
                }
            } else {
                n14 = 1;
                n15 = 0;
                while (n14 < n13 / 2) {
                    int n19 = n14++;
                    nArray2[n19] = nArray2[n19] ^ nArray2[n15++];
                }
                n17 = nArray2[n13 / 2 - 1];
                int n20 = n13 / 2;
                nArray2[n20] = nArray2[n20] ^ (S[n17 & 0xFF] & 0xFF ^ (S[n17 >>> 8 & 0xFF] & 0xFF) << 8 ^ (S[n17 >>> 16 & 0xFF] & 0xFF) << 16 ^ S[n17 >>> 24] << 24);
                n15 = n13 / 2;
                n14 = n15 + 1;
                while (n14 < n13) {
                    int n21 = n14++;
                    nArray2[n21] = nArray2[n21] ^ nArray2[n15++];
                }
            }
            for (n15 = 0; n15 < n13 && n10 < n12; ++n15, ++n10) {
                nArray[n10] = nArray2[n15];
            }
        }
        return nArray;
    }

    private static void invertKey(int[] nArray) {
        int n10;
        int n11;
        int n12;
        int n13;
        int n14;
        for (n14 = 0; n14 < nArray.length / 2 - 4; n14 += 4) {
            n13 = nArray[n14 + 0];
            n12 = nArray[n14 + 1];
            n11 = nArray[n14 + 2];
            n10 = nArray[n14 + 3];
            nArray[n14 + 0] = nArray[nArray.length - n14 - 4 + 0];
            nArray[n14 + 1] = nArray[nArray.length - n14 - 4 + 1];
            nArray[n14 + 2] = nArray[nArray.length - n14 - 4 + 2];
            nArray[n14 + 3] = nArray[nArray.length - n14 - 4 + 3];
            nArray[nArray.length - n14 - 4 + 0] = n13;
            nArray[nArray.length - n14 - 4 + 1] = n12;
            nArray[nArray.length - n14 - 4 + 2] = n11;
            nArray[nArray.length - n14 - 4 + 3] = n10;
        }
        for (n14 = 4; n14 < nArray.length - 4; ++n14) {
            n13 = nArray[n14];
            nArray[n14] = U1[n13 >>> 24 & 0xFF] ^ U2[n13 >>> 16 & 0xFF] ^ U3[n13 >>> 8 & 0xFF] ^ U4[n13 & 0xFF];
        }
        n14 = nArray[nArray.length - 4];
        n13 = nArray[nArray.length - 3];
        n12 = nArray[nArray.length - 2];
        n11 = nArray[nArray.length - 1];
        for (n10 = nArray.length - 1; n10 > 3; --n10) {
            nArray[n10] = nArray[n10 - 4];
        }
        nArray[0] = n14;
        nArray[1] = n13;
        nArray[2] = n12;
        nArray[3] = n11;
    }

    private static int getRounds(int n10) {
        return (n10 >> 2) + 6;
    }

    static {
        int n10;
        S = new byte[256];
        Si = new byte[256];
        T1 = new int[256];
        T2 = new int[256];
        T3 = new int[256];
        T4 = new int[256];
        T5 = new int[256];
        T6 = new int[256];
        T7 = new int[256];
        T8 = new int[256];
        U1 = new int[256];
        U2 = new int[256];
        U3 = new int[256];
        U4 = new int[256];
        RCON = new byte[30];
        int n11 = 283;
        int n12 = 0;
        for (n12 = 0; n12 < 256; ++n12) {
            int n13;
            int n14;
            int n15;
            char c10 = SS.charAt(n12 >>> 1);
            Rijndael.S[n12] = (byte)((n12 & 1) == 0 ? c10 >>> 8 : c10 & 0xFF);
            n10 = S[n12] & 0xFF;
            Rijndael.Si[n10] = (byte)n12;
            int n16 = n10 << 1;
            if (n16 >= 256) {
                n16 ^= n11;
            }
            int n17 = n16 ^ n10;
            int n18 = n12 << 1;
            if (n18 >= 256) {
                n18 ^= n11;
            }
            if ((n15 = n18 << 1) >= 256) {
                n15 ^= n11;
            }
            if ((n14 = n15 << 1) >= 256) {
                n14 ^= n11;
            }
            int n19 = n14 ^ n12;
            int n20 = n19 ^ n18;
            int n21 = n19 ^ n15;
            int n22 = n14 ^ n15 ^ n18;
            Rijndael.T1[n12] = n13 = n16 << 24 | n10 << 16 | n10 << 8 | n17;
            Rijndael.T2[n12] = n13 >>> 8 | n13 << 24;
            Rijndael.T3[n12] = n13 >>> 16 | n13 << 16;
            Rijndael.T4[n12] = n13 >>> 24 | n13 << 8;
            Rijndael.U1[n12] = n13 = n22 << 24 | n19 << 16 | n21 << 8 | n20;
            Rijndael.T5[n10] = n13;
            Rijndael.T6[n10] = Rijndael.U2[n12] = n13 >>> 8 | n13 << 24;
            Rijndael.T7[n10] = Rijndael.U3[n12] = n13 >>> 16 | n13 << 16;
            Rijndael.T8[n10] = Rijndael.U4[n12] = n13 >>> 24 | n13 << 8;
        }
        n10 = 1;
        Rijndael.RCON[0] = 1;
        for (n12 = 1; n12 < 30; ++n12) {
            if ((n10 <<= 1) >= 256) {
                n10 ^= n11;
            }
            Rijndael.RCON[n12] = (byte)n10;
        }
    }
}

