/*
 * Decompiled with CFR 0.152.
 */
package au.gov.bafcsi.clapi.crypto.prng;

import au.gov.bafcsi.clapi.common.Oids;
import au.gov.bafcsi.clapi.crypto.CsiSecurityError;
import au.gov.bafcsi.clapi.crypto.prng.SeedGeneratorException;
import au.gov.bafcsi.clapi.crypto.prng.dg;
import au.gov.bafcsi.clapi.crypto.prng.dh;
import au.gov.bafcsi.clapi.crypto.prng.g3;
import au.gov.bafcsi.clapi.crypto.prng.go;
import au.gov.bafcsi.clapi.crypto.prng.gq;
import au.gov.bafcsi.clapi.crypto.prng.gz;
import au.gov.bafcsi.common.ByteArray;
import au.gov.bafcsi.common.utils.p;
import au.gov.bafcsi.common.utils.q;
import au.gov.bafcsi.common.utils.r;
import au.gov.bafcsi.common.utils.s;
import au.gov.bafcsi.common.utils.w;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.MessageDigest;
import java.security.SecureRandomSpi;

public final class CsiSecureRandom
extends SecureRandomSpi {
    private static final int NEW_SEED_FILE_LENGTH = 64;
    private static final int NO_SEED_FILE_ENTROPY_BYTES = 32;
    private static final int CSI_STORE_ENTROPY = 32;
    private static final int EXTRA_SEED_ENTROPY_BYTES = 16;
    private static final int COLLECTED_USER_ENTROPY = 20;
    private static dg m_internalSecureRandom = null;
    private static boolean m_isReadyForUse = false;
    private static boolean m_isWaitingOnUserInput = false;
    private static boolean m_hasSeedingErrorOccured = true;
    private static final Object FINISHED_LOCK = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void initialise() {
        Object object;
        Object object2;
        if (m_internalSecureRandom != null) {
            throw new IllegalStateException("CsiSecureRandom.initialise() can only be called once.");
        }
        try {
            try {
                m_internalSecureRandom = new dg();
            }
            catch (Throwable throwable) {
                throw new CsiSecurityError("Unable to get an instance of the CSI random number generator.", throwable);
            }
            go.a();
            byte[] byArray = gq.a().c;
            m_internalSecureRandom.a(byArray);
            if (byArray.length < 64) {
                m_internalSecureRandom.a(CsiSecureRandom.moreEntropy());
            }
            object2 = FINISHED_LOCK;
            synchronized (object2) {
                m_hasSeedingErrorOccured = false;
            }
            Object var4_6 = null;
            object = FINISHED_LOCK;
        }
        catch (Throwable throwable) {
            Object var4_7 = null;
            Object object3 = FINISHED_LOCK;
            synchronized (object3) {
                m_isReadyForUse = true;
                FINISHED_LOCK.notifyAll();
            }
            throw throwable;
        }
        synchronized (object) {
            m_isReadyForUse = true;
            FINISHED_LOCK.notifyAll();
        }
        if (!s.n()) {
            int n10 = 10000;
            object2 = dg.a(16, n10);
            if (((Object)object2).length != 16) {
                r.a(w.j, "The PRNG seed generator could not provide additional entropy.");
            }
            m_internalSecureRandom.a((byte[])object2);
        }
        byte[] byArray = new byte[64];
        m_internalSecureRandom.b(byArray);
        gq.a().a(byArray);
    }

    protected byte[] engineGenerateSeed(int n10) {
        dh.a().b();
        CsiSecureRandom.waitOnSeeding();
        return dg.a(n10, -1);
    }

    protected void engineNextBytes(byte[] byArray) {
        if (byArray == null) {
            throw new IllegalArgumentException("CsiSecureRandom.engineNextBytes(byte[]) - The supplied byte[] is null.");
        }
        dh.a().b();
        CsiSecureRandom.waitOnSeeding();
        m_internalSecureRandom.b(byArray);
    }

    protected void engineSetSeed(byte[] byArray) {
        if (byArray == null) {
            throw new IllegalArgumentException("CsiSecureRandom.engineSetSeed(byte[]) - The supplied byte[] is null.");
        }
        CsiSecureRandom.waitOnSeeding();
        m_internalSecureRandom.a(byArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] moreEntropy() {
        Object object;
        Object object2;
        int n10 = 32;
        ByteArray byteArray = new ByteArray();
        byteArray.append("s0u!dHyc^&&(oiu2_u34hu2@479=87OuY^786:9&H.JH&^Yyuh8sd=&^65X;|hi".getBytes());
        byteArray.append(Long.toString(System.currentTimeMillis()).getBytes());
        byteArray.append(System.getProperties().toString().getBytes());
        File file = s.a().e();
        if (file.exists() && file.canRead()) {
            try {
                object2 = new FileInputStream(file);
                object = new ByteArrayOutputStream();
                p.b((InputStream)object2, (OutputStream)object);
                byteArray.append(((ByteArrayOutputStream)object).toByteArray());
                n10 -= 32;
            }
            catch (IOException iOException) {
                object = "The csistore (" + file.getAbsolutePath() + ") exists but could not be read.";
                r.a(w.i, (String)object, iOException);
            }
        }
        if (!s.n()) {
            try {
                while (n10 > 0) {
                    byteArray.append(go.b());
                    --n10;
                }
            }
            catch (SeedGeneratorException seedGeneratorException) {
                // empty catch block
            }
        }
        if (n10 > 0) {
            if (s.a().an()) {
                throw new CsiSecurityError("The PRNG has not been properly seeded and the CSI is running in server mode.  You can provide more random data to fix this problem by creating a file /.csi/seed in the users profile that contains 64 or more bytes of random data.");
            }
            int n11 = Math.max(20, n10);
            Object object3 = FINISHED_LOCK;
            synchronized (object3) {
                m_isWaitingOnUserInput = true;
            }
            object = new gz(n11);
            byteArray.append(((gz)object).u());
        }
        object2 = q.a(Oids.sha256);
        return ((MessageDigest)object2).digest(byteArray.getBytes());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void waitOnSeeding() {
        Object object = FINISHED_LOCK;
        synchronized (object) {
            if (m_isReadyForUse) {
                if (m_hasSeedingErrorOccured) {
                    String string = "An error occured during the random number seeding process. Therefore the Random number generator will not work.";
                    r.a(w.g, string);
                    throw new IllegalStateException(string);
                }
                return;
            }
            CsiSecureRandom.waitOnStandardSeeding();
            CsiSecureRandom.waitOnUISeeding();
            if (!m_isReadyForUse) {
                String string = "The PRNG engine timed out while waiting for it to be initialised for use.";
                r.a(w.g, string);
                throw new IllegalStateException(string);
            }
            if (m_hasSeedingErrorOccured) {
                String string = "An error occured during the random number seeding process. Therefore the Random number generator will not work.";
                r.a(w.g, string);
                throw new IllegalStateException(string);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void waitOnStandardSeeding() {
        long l10 = System.currentTimeMillis() + 30000L;
        long l11 = 30000L;
        Object object = FINISHED_LOCK;
        synchronized (object) {
            while (!m_isReadyForUse) {
                try {
                    FINISHED_LOCK.wait(l11);
                }
                catch (InterruptedException interruptedException) {
                    r.a(w.i, "There was an attempt to interupt when waiting for the random seed generator to finish.", interruptedException);
                    l11 = l10 - System.currentTimeMillis();
                    if (l11 > 0L) continue;
                }
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void waitOnUISeeding() {
        Object object = FINISHED_LOCK;
        synchronized (object) {
            if (m_isWaitingOnUserInput) {
                while (!m_isReadyForUse) {
                    try {
                        FINISHED_LOCK.wait();
                        break;
                    }
                    catch (InterruptedException interruptedException) {
                        r.a(w.i, "There was an attempt to interupt when waiting for the random seeding dialog to finish.");
                    }
                }
            }
        }
    }

    public void nextBytes(byte[] byArray) {
        if (byArray == null) {
            throw new IllegalArgumentException("CsiSecureRandom.nextBytes(byte[]) - The supplied byte[] is null.");
        }
        this.engineNextBytes(byArray);
    }

    public void setSeed(byte[] byArray) {
        if (byArray == null) {
            throw new IllegalArgumentException("CsiSecureRandom.setSeed(byte[]) - The supplied byte[] is null.");
        }
        this.engineSetSeed(byArray);
    }

    public byte[] generateSeed(int n10) {
        return this.engineGenerateSeed(n10);
    }

    static /* synthetic */ void access$000() {
        CsiSecureRandom.initialise();
    }

    static {
        g3 g32 = new g3();
        g32.setDaemon(true);
        g32.start();
    }
}

