/*
 * Decompiled with CFR 0.152.
 */
package au.gov.bafcsi.clapi.crypto.keygen;

import au.gov.bafcsi.clapi.asn1.coders.CoderException;
import au.gov.bafcsi.clapi.certs.SubjectPublicKeyInfo;
import au.gov.bafcsi.clapi.certs.extensions.KeyUsage;
import au.gov.bafcsi.clapi.crypto.keygen.CsiRsaKeyPairGenerator;
import java.io.IOException;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;

public class KeyProfile {
    private PublicKey publicKey = null;
    private PrivateKey privateKey = null;
    private static final KeyUsage sigUsage = new KeyUsage(new boolean[]{true, true, false, false, false, false, false, false, false});
    private static final KeyUsage encUsage = new KeyUsage(new boolean[]{false, false, true, false, false, false, false, false, false});
    private SubjectPublicKeyInfo subKeyInfo = null;
    private final KeyUsage m_keyUsage;
    private final int m_keySize;

    public static KeyProfile getDefaultSigningProfile(int n10) {
        return new KeyProfile(sigUsage, n10);
    }

    public static KeyProfile getDefaultEnvelopingProfile(int n10) {
        return new KeyProfile(encUsage, n10);
    }

    public KeyProfile(KeyUsage keyUsage) {
        this(keyUsage, 1024);
    }

    KeyProfile(KeyUsage keyUsage, RSAPrivateKey rSAPrivateKey, RSAPublicKey rSAPublicKey) {
        this(keyUsage, rSAPublicKey.getModulus().bitLength());
        this.privateKey = rSAPrivateKey;
        this.publicKey = rSAPublicKey;
    }

    public KeyProfile(KeyUsage keyUsage, int n10) {
        if (keyUsage == null) {
            throw new IllegalArgumentException("KeyProfile.KeyProfile(KeyUsage, int) - The supplied KeyUsage is null.");
        }
        if (n10 < 1024 || n10 > 8192) {
            throw new IllegalArgumentException("KeyProfile.KeyProfile(KeyUsage, int) - The supplied keysize must be between 1024 and 8192.");
        }
        this.m_keyUsage = keyUsage;
        this.m_keySize = n10;
    }

    public KeyUsage getKeyUsage() {
        return this.m_keyUsage;
    }

    protected void generateKeys() {
        CsiRsaKeyPairGenerator csiRsaKeyPairGenerator = new CsiRsaKeyPairGenerator();
        csiRsaKeyPairGenerator.initialize(this.m_keySize, null);
        KeyPair keyPair = csiRsaKeyPairGenerator.generateKeyPair();
        this.privateKey = keyPair.getPrivate();
        this.publicKey = keyPair.getPublic();
    }

    protected SubjectPublicKeyInfo getPublicKeyInfo() throws IOException, CoderException {
        if (this.publicKey == null) {
            return null;
        }
        if (this.subKeyInfo == null) {
            this.subKeyInfo = new SubjectPublicKeyInfo(this.publicKey);
        }
        return this.subKeyInfo;
    }

    protected PrivateKey getPrivateKey() {
        return this.privateKey;
    }
}

