/*
 * Decompiled with CFR 0.152.
 */
package au.gov.bafcsi.clapi.crypto;

import au.gov.bafcsi.clapi.crypto.CsiCertificate;
import au.gov.bafcsi.clapi.crypto.CsiPrivateKey;
import au.gov.bafcsi.clapi.crypto.Pkcs1;
import au.gov.bafcsi.clapi.crypto.UserCancelledCipherException;
import au.gov.bafcsi.clapi.crypto.ac;
import au.gov.bafcsi.clapi.crypto.do;
import au.gov.bafcsi.clapi.crypto.z;
import au.gov.bafcsi.common.ByteArray;
import au.gov.bafcsi.common.utils.r;
import au.gov.bafcsi.common.utils.w;
import java.math.BigInteger;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.interfaces.RSAKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.BadPaddingException;
import javax.crypto.CipherSpi;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.ShortBufferException;

public class RsaCipherSpi
extends CipherSpi {
    private Key m_cipherKey = null;
    private int m_operationMode = 0;

    protected void engineSetMode(String string) throws NoSuchAlgorithmException {
        if (!string.equalsIgnoreCase("ECB")) {
            throw new NoSuchAlgorithmException("The CSI RSA cipher only supports ECB feedback mode. The invalid mode was " + string + ".");
        }
    }

    protected void engineSetPadding(String string) throws NoSuchPaddingException {
        if (!(string.equalsIgnoreCase("PKCS#1") || string.equalsIgnoreCase("PKCS1") || string.equalsIgnoreCase("PKCS1Padding"))) {
            throw new NoSuchPaddingException("The CSI RSA cipher only supports PKCS#1 padding. The invalid padding was " + string + ".");
        }
    }

    protected int engineGetBlockSize() {
        RSAKey rSAKey = null;
        CsiPrivateKey csiPrivateKey = null;
        if (this.m_cipherKey instanceof CsiPrivateKey) {
            csiPrivateKey = (CsiPrivateKey)this.m_cipherKey;
            rSAKey = (RSAKey)((Object)csiPrivateKey.getAssociatedCertificate().getPublicKey());
        } else {
            rSAKey = (RSAKey)((Object)this.m_cipherKey);
        }
        return (rSAKey.getModulus().bitLength() + 7) / 8;
    }

    protected int engineGetOutputSize(int n10) {
        int n11 = 0;
        int n12 = 0;
        int n13 = 0;
        n12 = this.engineGetBlockSize();
        if (n10 < n12) {
            n11 = n12;
        } else {
            n13 = (int)Math.ceil((double)n10 / (double)n12);
            n11 = n13 * n12;
        }
        return n11;
    }

    protected byte[] engineGetIV() {
        return null;
    }

    protected AlgorithmParameters engineGetParameters() {
        return null;
    }

    protected void engineInit(int n10, Key key, SecureRandom secureRandom) throws InvalidKeyException {
        if (!(key instanceof RSAPublicKey) && !(key instanceof CsiPrivateKey)) {
            throw new InvalidKeyException("The key passed to engineInit was not a recognised class. The CSI cipher only accepts instances of RSAPublicKey or CSIPrivateKey. The invalid key class was " + key.getClass().getName());
        }
        if (key instanceof CsiPrivateKey && !key.getAlgorithm().equalsIgnoreCase("RSA")) {
            throw new InvalidKeyException("The key passed to engineInit does not support RSA ciphering. The key passed only supports the algorithm " + key.getAlgorithm());
        }
        if (n10 != 3 && n10 != 4) {
            throw new IllegalArgumentException("The CSI RSA cipher only supports key wrapping and key unwrapping.");
        }
        if (n10 == 3 && !(key instanceof RSAPublicKey)) {
            throw new IllegalArgumentException("The CSI RSA cipher can only be initialised for wrap mode with a key that is an instance of RSAPublicKey.");
        }
        if (n10 == 4 && !(key instanceof CsiPrivateKey)) {
            throw new IllegalArgumentException("The CSI RSA cipher can only be initialised for unwrap mode with a CSIPrivateKey.");
        }
        this.m_operationMode = n10;
        this.m_cipherKey = key;
    }

    protected void engineInit(int n10, Key key, AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidKeyException, InvalidAlgorithmParameterException {
        this.engineInit(n10, key, null);
    }

    protected void engineInit(int n10, Key key, AlgorithmParameters algorithmParameters, SecureRandom secureRandom) throws InvalidKeyException, InvalidAlgorithmParameterException {
        this.engineInit(n10, key, null);
    }

    protected byte[] engineUpdate(byte[] byArray, int n10, int n11) {
        throw new UnsupportedOperationException("The method engineUpdate is not supported by the CSI RsaCipherSpi class.");
    }

    protected int engineUpdate(byte[] byArray, int n10, int n11, byte[] byArray2, int n12) throws ShortBufferException {
        throw new UnsupportedOperationException("The method engineUpdate is not supported by the CSI RsaCipherSpi class.");
    }

    protected byte[] engineDoFinal(byte[] byArray, int n10, int n11) throws IllegalBlockSizeException, BadPaddingException {
        throw new UnsupportedOperationException("The method engineDoFinal is not supported by the CSI RsaCipherSpi class.");
    }

    protected int engineDoFinal(byte[] byArray, int n10, int n11, byte[] byArray2, int n12) throws ShortBufferException, IllegalBlockSizeException, BadPaddingException {
        throw new UnsupportedOperationException("The method engineDoFinal is not supported by the CSI RsaCipher class.");
    }

    protected byte[] engineWrap(Key key) throws IllegalBlockSizeException, InvalidKeyException {
        RSAPublicKey rSAPublicKey = null;
        SecretKey secretKey = null;
        if (this.m_operationMode != 3) {
            throw new IllegalStateException("The method engineWrap was called on a CipherWrapper class that was initialise for UNWRAP.");
        }
        if (!(this.m_cipherKey instanceof RSAPublicKey)) {
            String string = "";
            string = "The CSI RSA cipher can only perform key wrapping with a RSAPublicKey. Instead it has been initalised with a " + this.m_cipherKey.getClass().getName();
            r.a(w.f, string);
            throw new IllegalStateException(string);
        }
        rSAPublicKey = (RSAPublicKey)this.m_cipherKey;
        if (!(key instanceof SecretKey)) {
            throw new InvalidKeyException("The CipherWrapper " + this.getClass().getName() + ".wrap() only accepts" + " SecretKey's. The key passed in was of type " + key.getClass().getName());
        }
        secretKey = (SecretKey)key;
        return this.doRsaWrapping(secretKey, rSAPublicKey).getBytes();
    }

    private ByteArray doRsaWrapping(SecretKey secretKey, RSAPublicKey rSAPublicKey) throws InvalidKeyException {
        String string = "";
        byte[] byArray = null;
        byte[] byArray2 = null;
        int n10 = 0;
        ByteArray byteArray = null;
        BigInteger bigInteger = null;
        ByteArray byteArray2 = null;
        string = secretKey.getFormat();
        if (string != null && string.equalsIgnoreCase("RAW")) {
            byArray = secretKey.getEncoded();
            n10 = do.a(rSAPublicKey);
            byteArray = Pkcs1.makePKCS1ForEncryption(byArray, n10);
            if (byArray.length < 5) {
                throw new InvalidKeyException("RsaCipherSpi.doRsaWrapping: keyBytes is too small in length.");
            }
            if (new BigInteger(byteArray.getBytes()).compareTo(rSAPublicKey.getModulus()) != -1) {
                throw new InvalidKeyException("RsaCipherSpi.doRsaWrapping: pkcs1Packet is not less than the RSA modulus.");
            }
            bigInteger = do.a(new BigInteger(byteArray.getBytes()), rSAPublicKey.getModulus(), rSAPublicKey.getPublicExponent());
            byArray2 = bigInteger.toByteArray();
            byteArray2 = byArray2.length > n10 ? new ByteArray(byArray2, byArray2.length - n10, n10) : new ByteArray(byArray2);
        } else {
            throw new InvalidKeyException("The CipherWrapper " + this.getClass().getName() + " can only wrap keys in RAW format. The key passed in was in " + string + " format.");
        }
        return byteArray2;
    }

    protected Key engineUnwrap(byte[] byArray, String string, int n10) throws InvalidKeyException, NoSuchAlgorithmException, UserCancelledCipherException {
        CsiCertificate csiCertificate = null;
        ByteArray byteArray = null;
        SecretKey secretKey = null;
        String string2 = "";
        if (this.m_operationMode != 4) {
            throw new IllegalStateException("The method engineWrap was called on a CipherWrapper class that was initialise for UNWRAP.");
        }
        if (!(this.m_cipherKey instanceof CsiPrivateKey)) {
            string2 = "The CSI RSA cipher can only perform key unwrapping with a CSIPrivateKey. Instead it has been initalised with a " + this.m_cipherKey.getClass().getName();
            r.a(w.f, string2);
            throw new IllegalStateException(string2);
        }
        csiCertificate = ((CsiPrivateKey)this.m_cipherKey).getAssociatedCertificate();
        byteArray = new ByteArray(byArray);
        try {
            secretKey = z.a().a(csiCertificate, string, byteArray);
        }
        catch (ac ac2) {
            string2 = "An error occured while attempting to unwrap a secret key. The originating error is " + ac2.toString();
            r.a(w.f, string2, ac2);
            InvalidKeyException invalidKeyException = new InvalidKeyException(string2);
            invalidKeyException.initCause(ac2);
            throw invalidKeyException;
        }
        return secretKey;
    }

    protected int engineGetKeySize(Key key) throws InvalidKeyException {
        int n10;
        if (key instanceof CsiPrivateKey) {
            CsiCertificate csiCertificate = ((CsiPrivateKey)key).getAssociatedCertificate();
            key = csiCertificate.getPublicKey();
        }
        if (key instanceof RSAPublicKey) {
            n10 = ((RSAPublicKey)key).getModulus().bitLength();
        } else if (key instanceof RSAPrivateKey) {
            n10 = ((RSAPrivateKey)key).getModulus().bitLength();
        } else {
            throw new InvalidKeyException("RsaCipherSpi.engineGetKeySize(Key key): The Key does not associate itself with an RSAPublic/PrivateKey.");
        }
        return n10;
    }
}

