/*
 * Decompiled with CFR 0.152.
 */
package au.gov.bafcsi.clapi.crypto;

import java.math.BigInteger;
import java.security.SignatureException;

class DsaSignatureData {
    private BigInteger r;
    private BigInteger s;

    public DsaSignatureData(byte[] byArray) throws SignatureException {
        try {
            int n10;
            int n11 = 0;
            if (byArray[n11++] != 48 || byArray[n11++] != byArray.length - 2 || byArray[n11++] != 2) {
                throw new SignatureException("Corrupted signature data");
            }
            if ((n10 = byArray[n11++]) > 21) {
                throw new SignatureException("Corrupted signature data");
            }
            byte[] byArray2 = new byte[n10];
            for (int i10 = 0; i10 < n10; ++i10) {
                byArray2[i10] = byArray[n11++];
            }
            if (byArray[n11++] != 2) {
                throw new SignatureException("Corrupted signature data");
            }
            if ((n10 = byArray[n11++]) > 21) {
                throw new SignatureException("Corrupted signature data");
            }
            byte[] byArray3 = new byte[n10];
            for (int i11 = 0; i11 < n10; ++i11) {
                byArray3[i11] = byArray[n11++];
            }
            this.r = new BigInteger(byArray2);
            this.s = new BigInteger(byArray3);
            if (n11 != byArray.length || this.r.signum() != 1 || this.s.signum() != 1) {
                throw new SignatureException("Corrupted signature data");
            }
        }
        catch (NullPointerException nullPointerException) {
            throw new SignatureException("Corrupted signature data");
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new SignatureException("Corrupted signature data");
        }
    }

    public DsaSignatureData(BigInteger bigInteger, BigInteger bigInteger2) throws SignatureException {
        if (bigInteger == null || bigInteger2 == null) {
            throw new SignatureException("Invalid signature");
        }
        if (bigInteger.signum() != 1 || bigInteger2.signum() != 1) {
            throw new SignatureException("Invalid signature");
        }
        this.r = bigInteger;
        this.s = bigInteger2;
    }

    public BigInteger getR() {
        return this.r;
    }

    public BigInteger getS() {
        return this.s;
    }

    public byte[] getData() {
        int n10;
        byte[] byArray = this.r.toByteArray();
        byte[] byArray2 = this.s.toByteArray();
        byte[] byArray3 = new byte[6 + byArray.length + byArray2.length];
        int n11 = 0;
        byArray3[n11++] = 48;
        byArray3[n11++] = (byte)(byArray3.length - 2);
        byArray3[n11++] = 2;
        byArray3[n11++] = (byte)byArray.length;
        for (n10 = 0; n10 < byArray.length; ++n10) {
            byArray3[n11++] = byArray[n10];
        }
        byArray3[n11++] = 2;
        byArray3[n11++] = (byte)byArray2.length;
        for (n10 = 0; n10 < byArray2.length; ++n10) {
            byArray3[n11++] = byArray2[n10];
        }
        return byArray3;
    }
}

