/*
 * Decompiled with CFR 0.152.
 */
package au.gov.bafcsi.clapi.crypto;

import au.gov.bafcsi.clapi.asn1.coders.CoderException;
import au.gov.bafcsi.clapi.certs.SubjectPublicKeyInfo;
import au.gov.bafcsi.clapi.crypto.CsiRsaPrivateKey;
import au.gov.bafcsi.clapi.crypto.CsiRsaPublicKey;
import au.gov.bafcsi.clapi.crypto.Pkcs8EncodedPrivateKey;
import au.gov.bafcsi.common.ByteArray;
import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactorySpi;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.RSAPrivateCrtKeySpec;
import java.security.spec.RSAPrivateKeySpec;
import java.security.spec.RSAPublicKeySpec;
import java.security.spec.X509EncodedKeySpec;

public class CsiRsaKeyFactory
extends KeyFactorySpi {
    protected PrivateKey engineGeneratePrivate(KeySpec keySpec) throws InvalidKeySpecException {
        if (keySpec instanceof RSAPrivateCrtKeySpec) {
            RSAPrivateCrtKeySpec rSAPrivateCrtKeySpec = (RSAPrivateCrtKeySpec)keySpec;
            return new CsiRsaPrivateKey(rSAPrivateCrtKeySpec.getModulus(), rSAPrivateCrtKeySpec.getPublicExponent(), rSAPrivateCrtKeySpec.getPrivateExponent(), rSAPrivateCrtKeySpec.getPrimeP(), rSAPrivateCrtKeySpec.getPrimeQ(), rSAPrivateCrtKeySpec.getPrimeExponentP(), rSAPrivateCrtKeySpec.getPrimeExponentQ(), rSAPrivateCrtKeySpec.getCrtCoefficient());
        }
        if (keySpec instanceof RSAPrivateKeySpec) {
            RSAPrivateCrtKeySpec rSAPrivateCrtKeySpec = (RSAPrivateCrtKeySpec)keySpec;
            return new CsiRsaPrivateKey(rSAPrivateCrtKeySpec.getModulus(), rSAPrivateCrtKeySpec.getPublicExponent(), rSAPrivateCrtKeySpec.getPrivateExponent());
        }
        if (keySpec instanceof PKCS8EncodedKeySpec) {
            try {
                PKCS8EncodedKeySpec pKCS8EncodedKeySpec = (PKCS8EncodedKeySpec)keySpec;
                Pkcs8EncodedPrivateKey pkcs8EncodedPrivateKey = new Pkcs8EncodedPrivateKey();
                pkcs8EncodedPrivateKey.a(new ByteArray(pKCS8EncodedKeySpec.getEncoded()));
                return pkcs8EncodedPrivateKey.getPrivateKey();
            }
            catch (Exception exception) {
                throw new InvalidKeySpecException(exception.getMessage());
            }
        }
        throw new InvalidKeySpecException("Invalid RSA private key specification supplied.");
    }

    protected PublicKey engineGeneratePublic(KeySpec keySpec) throws InvalidKeySpecException {
        if (keySpec instanceof RSAPublicKeySpec) {
            return new CsiRsaPublicKey(((RSAPublicKeySpec)keySpec).getModulus(), ((RSAPublicKeySpec)keySpec).getPublicExponent());
        }
        if (keySpec instanceof X509EncodedKeySpec) {
            try {
                return new CsiRsaPublicKey((X509EncodedKeySpec)keySpec);
            }
            catch (IOException iOException) {
                throw new InvalidKeySpecException("CSIRSAKeyFactory.engineGeneratePublic(KeySpec) - " + iOException.getMessage());
            }
            catch (CoderException coderException) {
                throw new InvalidKeySpecException("CSIRSAKeyFactory.engineGeneratePublic(KeySpec) - " + coderException.getMessage());
            }
        }
        throw new InvalidKeySpecException("CSIRSAKeyFactory.engineGeneratePublic(KeySpec) - '" + keySpec.getClass().getName() + "' unsupported KeySpec.");
    }

    protected KeySpec engineGetKeySpec(Key key, Class clazz) throws InvalidKeySpecException {
        try {
            if (!key.getAlgorithm().equals("RSA")) {
                throw new InvalidKeySpecException("CSIRSAKeyFactory.engineGetKeySpec(Key, Class) - Key is not an RSA Key.");
            }
            if (clazz.equals(X509EncodedKeySpec.class)) {
                if (!(key instanceof RSAPublicKey)) {
                    throw new InvalidKeySpecException("CSIRSAKeyFactory.engineGetKeySpec(Key, Class) - Key is not an RSAPublicKey.");
                }
                return new X509EncodedKeySpec(new SubjectPublicKeyInfo((RSAPublicKey)key).g().getBytes());
            }
            throw new InvalidKeySpecException("CSIRSAKeyFactory.engineGetKeySpec(Key, Class) - This KeySpec is unsupported '" + clazz.getName() + "'");
        }
        catch (InvalidKeySpecException invalidKeySpecException) {
            throw invalidKeySpecException;
        }
        catch (Exception exception) {
            throw new InvalidKeySpecException("CSIRSAKeyFactory.engineGetKeySpec(Key, Class) - " + exception.getMessage());
        }
    }

    protected Key engineTranslateKey(Key key) throws InvalidKeyException {
        throw new InvalidKeyException("CSIRSAKeyFactory.engineTranslateKey(Key) - This method is unsupported.");
    }
}

