/*
 * Decompiled with CFR 0.152.
 */
package au.gov.bafcsi.clapi.crypto;

import au.gov.bafcsi.clapi.common.DigestOid;
import au.gov.bafcsi.clapi.common.Oids;
import au.gov.bafcsi.clapi.crypto.CertificateCollection;
import au.gov.bafcsi.clapi.crypto.CertificateStoreType;
import au.gov.bafcsi.clapi.crypto.CsiCertificate;
import au.gov.bafcsi.clapi.crypto.UserCancelledCipherException;
import au.gov.bafcsi.clapi.crypto.UserCancelledSignatureException;
import au.gov.bafcsi.clapi.crypto.aa;
import au.gov.bafcsi.clapi.crypto.ac;
import au.gov.bafcsi.clapi.crypto.ey;
import au.gov.bafcsi.clapi.crypto.y;
import au.gov.bafcsi.common.ByteArray;
import au.gov.bafcsi.common.utils.ad;
import au.gov.bafcsi.common.utils.aq;
import au.gov.bafcsi.common.utils.r;
import au.gov.bafcsi.common.utils.s;
import au.gov.bafcsi.common.utils.w;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.nio.ByteBuffer;
import java.security.KeyStoreException;
import java.security.cert.CertificateEncodingException;
import java.util.LinkedList;
import java.util.ListIterator;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;

public final class CapiToken
extends aa {
    private static final String[] a = new String[]{"MY"};
    private static CapiToken b;
    private String[] c;
    private String d;
    private CertificateCollection e;
    private static boolean f;
    private final Object g = new Object();
    private static final Object h;
    static final String[] i;

    private static native long nativeIsCspAvailable(String var0, String var1, boolean[] var2);

    private native long nativeIsCertificateInStore(byte[] var1, String var2, boolean[] var3);

    private native long nativeWrapDigest(byte[] var1, int var2, byte[] var3, String var4, byte[] var5, int var6);

    private native long nativeGetCertificates(String var1, LinkedList var2);

    private native byte[] nativeUnwrapSecretKey(byte[] var1, byte[] var2, String var3) throws InterruptedIOException, KeyStoreException;

    private native void nativeGenerateSeed(ByteBuffer var1) throws IOException;

    public static synchronized CapiToken a() throws ac {
        if (b == null) {
            if (!s.m()) {
                throw new ac("CAPI does not support this OS platform.");
            }
            b = new CapiToken();
        }
        return b;
    }

    private CapiToken() throws ac {
        this(a, "X.509");
    }

    private CapiToken(String[] stringArray, String string) throws ac {
        this.c = stringArray == null || stringArray.length == 0 ? a : stringArray;
        this.d = string == null || string.length() == 0 ? "X.509" : string;
        this.e = new CertificateCollection();
        CapiToken.j();
        if (!CapiToken.b()) {
            b = null;
            throw new ac("Capi does not adequately support this platform: the 128-bit CSP (Microsoft Enhanced Cryptographic Provider v1.0) is not available.");
        }
    }

    public static boolean b() {
        boolean[] blArray;
        long l10;
        if (!f) {
            try {
                CapiToken.j();
            }
            catch (ac ac2) {
                return false;
            }
        }
        if ((l10 = CapiToken.nativeIsCspAvailable("Microsoft Enhanced Cryptographic Provider v1.0", "RSA_FULL", blArray = new boolean[]{false})) != 0L) {
            r.a(w.f, "Fault (CAPI error " + l10 + ") interrogating CAPI for CSP: " + "Microsoft Enhanced Cryptographic Provider v1.0");
            blArray[0] = false;
        }
        return blArray[0];
    }

    public byte[] a(int n10) throws IOException {
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(n10);
        this.nativeGenerateSeed(byteBuffer);
        byte[] byArray = new byte[byteBuffer.capacity()];
        for (int i10 = 0; i10 < byArray.length; ++i10) {
            byArray[i10] = byteBuffer.get(i10);
        }
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void j() throws ac {
        Object object = h;
        synchronized (object) {
            if (!f) {
                try {
                    ad.a("CSINative");
                    f = true;
                }
                catch (aq aq2) {
                    String string = "CapiToken: Unable to load the CSINative.";
                    throw new ac(w.g, string, aq2);
                }
            }
        }
    }

    CertificateStoreType e() {
        return CertificateStoreType.CAPI_STORE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CertificateCollection c() throws ac {
        Object object = this.g;
        synchronized (object) {
            this.d();
            return this.e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void d() throws ac {
        Object object = this.g;
        synchronized (object) {
            CertificateCollection certificateCollection = new CertificateCollection();
            for (int i10 = 0; i10 < this.c.length; ++i10) {
                LinkedList linkedList = new LinkedList();
                long l10 = 0L;
                l10 = this.nativeGetCertificates(this.c[i10], linkedList);
                if (l10 != 0L) {
                    throw new ey(l10, "Fault retrieving certificates from certificate store (" + this.c[i10] + ")");
                }
                if (linkedList.size() == 0) continue;
                ListIterator listIterator = linkedList.listIterator(0);
                while (listIterator.hasNext()) {
                    byte[] byArray = (byte[])listIterator.next();
                    try {
                        CsiCertificate csiCertificate = new CsiCertificate(new y(byArray));
                        csiCertificate.setStoreType(CertificateStoreType.CAPI_STORE);
                        csiCertificate.setSubTokenName(this.c[i10]);
                        certificateCollection.addCertificate(csiCertificate);
                    }
                    catch (RuntimeException runtimeException) {
                        r.a(w.h, "CapiToken.refreshCache(): Error generating an X509Certificate from a CAPI certificate.", runtimeException);
                    }
                }
            }
            this.e = certificateCollection;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ByteArray a(CsiCertificate csiCertificate, DigestOid digestOid, ByteArray byteArray, boolean bl2) throws ac, UserCancelledSignatureException {
        Object object = this.g;
        synchronized (object) {
            byte[] byArray;
            if (s.a().u()) {
                if (csiCertificate == null) {
                    throw new IllegalArgumentException("null function argument: signerCertificate");
                }
                if (digestOid == null) {
                    throw new IllegalArgumentException("null function argument: digestOid");
                }
                if (byteArray == null) {
                    throw new IllegalArgumentException("null function argument: digestBytes");
                }
            }
            if (byteArray.getLength() < 1) {
                throw new IllegalArgumentException("Invalid digest length: length = " + byteArray.getLength());
            }
            if (!csiCertificate.canDoAuthenticationSigning() && !csiCertificate.canDoNonRepudiationSigning()) {
                throw new IllegalArgumentException("CsiCertificate usage does not permit signing.");
            }
            if (this.a(digestOid) == 0) {
                throw new IllegalArgumentException("Digest Oid not supported: oid name = " + Oids.getJCAMapping(digestOid));
            }
            byte[] byArray2 = null;
            long l10 = 0L;
            try {
                byArray = csiCertificate.getEncoded();
            }
            catch (CertificateEncodingException certificateEncodingException) {
                throw new ac(w.h, "JCA fault (Certificate Encoding Exception) retrieving encoded version of the signer certificate.", certificateEncodingException);
            }
            String string = this.a(csiCertificate, byArray);
            String string2 = csiCertificate.getPublicKey().getAlgorithm();
            if (string2.equalsIgnoreCase("RSA")) {
                byArray2 = new byte[csiCertificate.getKeyLength()];
                l10 = this.nativeWrapDigest(byteArray.toBytes(), this.a(digestOid), byArray, string, byArray2, 2);
            } else if (string2.equalsIgnoreCase("DSA")) {
                byArray2 = new byte[40];
                l10 = this.nativeWrapDigest(byteArray.toBytes(), this.a(digestOid), byArray, string, byArray2, 1);
            } else {
                throw new ac("Unsupported certificate: not DSA or RSA");
            }
            if (l10 != 0L) {
                if (l10 == -999L) {
                    String string3 = s.a().an() ? "Operation cancelled while wrapping digest (CAPI)" : "User cancelled while wrapping digest (CAPI)";
                    throw new UserCancelledSignatureException(string3);
                }
                throw new ey(l10, "Fault (CAPI error) wrapping digest");
            }
            ByteArray byteArray2 = this.a(byArray2);
            if (byteArray2 == null) {
                throw new ac("Fault reversing signature data.");
            }
            if (string2.compareToIgnoreCase("DSA") == 0) {
                ByteArray byteArray3 = this.b(byteArray2.getBytes());
                if (byteArray3 == null) {
                    throw new ac("Fault encoding DSA signature data.");
                }
                return byteArray3;
            }
            return byteArray2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    SecretKey a(CsiCertificate csiCertificate, String string, ByteArray byteArray) throws ac, UserCancelledCipherException {
        Object object = this.g;
        synchronized (object) {
            byte[] byArray;
            byte[] byArray2;
            if (csiCertificate == null) {
                throw new IllegalArgumentException("null function argument: encrypterCertificate");
            }
            if (string == null) {
                throw new IllegalArgumentException("null function argument: secretKeyAlgOid");
            }
            if (byteArray == null) {
                throw new IllegalArgumentException("null function argument: wrappedKeyBytes");
            }
            if (byteArray.getLength() < 1) {
                throw new IllegalArgumentException("Invalid wrapped key length: length = " + byteArray.getLength());
            }
            if (!csiCertificate.canDoEncryption()) {
                throw new IllegalArgumentException("CsiCertificate usage does not permit unwraping.");
            }
            try {
                byArray2 = csiCertificate.getEncoded();
            }
            catch (CertificateEncodingException certificateEncodingException) {
                throw new ac(w.h, "JCA fault (Certificate Encoding Exception) retrieving encoded version of the signer certificate.", certificateEncodingException);
            }
            String string2 = this.a(csiCertificate, byArray2);
            try {
                byArray = this.nativeUnwrapSecretKey(byteArray.toBytes(), byArray2, string2);
            }
            catch (InterruptedIOException interruptedIOException) {
                String string3 = s.a().an() ? "Operation cancelled while unrwapping secret key (CAPI)" : "User cancelled while unwrapping secret key (CAPI)";
                UserCancelledCipherException userCancelledCipherException = new UserCancelledCipherException(string3);
                userCancelledCipherException.initCause(interruptedIOException);
                throw userCancelledCipherException;
            }
            catch (KeyStoreException keyStoreException) {
                ac ac2 = new ac(keyStoreException.getMessage());
                ac2.initCause(keyStoreException);
                throw ac2;
            }
            if (string.startsWith("AES")) {
                string = "AES";
            }
            SecretKeySpec secretKeySpec = new SecretKeySpec(byArray, string);
            return secretKeySpec;
        }
    }

    private String a(CsiCertificate csiCertificate, byte[] byArray) throws ac {
        if (s.a().u()) {
            if (csiCertificate == null) {
                throw new IllegalArgumentException("null function argument: certificate");
            }
            if (byArray == null) {
                throw new IllegalArgumentException("null function argument: rawCertificate");
            }
        }
        if (byArray.length < 1) {
            throw new IllegalArgumentException("invalid function argument: rawCertificate is empty");
        }
        String string = csiCertificate.getSubTokenName();
        if (string != null) {
            boolean bl2 = false;
            for (int i10 = 0; i10 < this.c.length; ++i10) {
                if (!this.c[i10].equalsIgnoreCase(string)) continue;
                bl2 = true;
                break;
            }
            if (!bl2) {
                throw new IllegalArgumentException("CsiCertificate sub token is not supported by this instance of CapiToken: sub token = " + string);
            }
        } else {
            boolean bl3 = false;
            boolean[] blArray = new boolean[1];
            for (int i11 = 0; i11 < this.c.length; ++i11) {
                long l10 = this.nativeIsCertificateInStore(byArray, this.c[i11], blArray);
                if (l10 != 0L) {
                    throw new ey(l10, "Fault locating certificate in store: " + this.c[i11]);
                }
                if (!blArray[0]) continue;
                string = this.c[i11];
                bl3 = true;
                break;
            }
            if (!bl3) {
                throw new IllegalArgumentException("CsiCertificate is not supported by this instance of CapiToken: unable to locate certificate in supported stores");
            }
        }
        return string;
    }

    private int a(DigestOid digestOid) {
        if (digestOid.equals(Oids.sha1)) {
            return 1;
        }
        if (digestOid.equals(Oids.md5)) {
            return 2;
        }
        return 0;
    }

    private ByteArray a(byte[] byArray) {
        if (s.a().u() && byArray == null) {
            throw new IllegalArgumentException("null function argument: src");
        }
        if (byArray.length < 1) {
            throw new IllegalArgumentException("invalid function argument: src is empty");
        }
        ByteArray byteArray = new ByteArray(byArray.length);
        int n10 = 0;
        for (n10 = byArray.length; n10 > 0; --n10) {
            byteArray.append(byArray[n10 - 1]);
        }
        return byteArray;
    }

    private ByteArray b(byte[] byArray) {
        if (s.a().u() && byArray == null) {
            throw new IllegalArgumentException("null function argument: src");
        }
        if (byArray.length < 1) {
            throw new IllegalArgumentException("invalid function argument: src is empty");
        }
        int n10 = 6 + byArray.length + 2;
        ByteArray byteArray = new ByteArray(n10);
        int n11 = 0;
        byteArray.append((byte)48);
        byteArray.append((byte)(n10 - 2));
        byteArray.append((byte)2);
        byteArray.append((byte)21);
        byteArray.append((byte)0);
        for (n11 = 20; n11 < 40; ++n11) {
            byteArray.append(byArray[n11]);
        }
        byteArray.append((byte)2);
        byteArray.append((byte)21);
        byteArray.append((byte)0);
        for (n11 = 0; n11 < 20; ++n11) {
            byteArray.append(byArray[n11]);
        }
        return byteArray;
    }

    void f() {
    }

    static {
        f = false;
        h = new Object();
        i = new String[]{"MY", "Root", "CA", "Trust"};
        b = null;
    }
}

