/*
 * Decompiled with CFR 0.152.
 */
package au.gov.bafcsi.clapi.crypto;

import au.gov.bafcsi.clapi.crypto.CsiCertificate;

public class AbnDscSet {
    private CsiCertificate m_authenticationCertificate = null;
    private CsiCertificate m_nonRepudiationCertificate = null;
    private CsiCertificate m_confidentialityCertificate = null;

    public AbnDscSet(CsiCertificate csiCertificate, CsiCertificate csiCertificate2, CsiCertificate csiCertificate3) {
        boolean bl2 = false;
        String string = "";
        if (csiCertificate != null) {
            string = csiCertificate.getAbn();
            bl2 = true;
        }
        if (csiCertificate2 != null) {
            if (bl2) {
                if (!string.equals(csiCertificate2.getAbn())) {
                    throw new IllegalArgumentException("The certificates passed into the AbnDscSet must all have the same ABN.");
                }
            } else {
                string = csiCertificate2.getAbn();
            }
        }
        if (csiCertificate3 != null && bl2 && !string.equals(csiCertificate3.getAbn())) {
            throw new IllegalArgumentException("The certificates passed into the AbnDscSet must all have the same ABN.");
        }
        this.m_authenticationCertificate = csiCertificate;
        this.m_nonRepudiationCertificate = csiCertificate2;
        this.m_confidentialityCertificate = csiCertificate3;
    }

    public CsiCertificate getAuthenticationCertificate() {
        return this.m_authenticationCertificate;
    }

    public CsiCertificate getNonRepudiationCertificate() {
        return this.m_nonRepudiationCertificate;
    }

    public CsiCertificate getConfidentialityCertificate() {
        return this.m_confidentialityCertificate;
    }

    boolean isBrokenAbnDscSet() {
        return this.m_authenticationCertificate == null || this.m_nonRepudiationCertificate == null || this.m_confidentialityCertificate == null;
    }
}

