/*
 * Decompiled with CFR 0.152.
 */
package au.gov.bafcsi.clapi.common;

import au.gov.bafcsi.clapi.asn1.a3;
import au.gov.bafcsi.clapi.asn1.aw;
import au.gov.bafcsi.clapi.asn1.ax;
import au.gov.bafcsi.clapi.asn1.az;
import au.gov.bafcsi.clapi.asn1.b5;
import au.gov.bafcsi.clapi.asn1.bh;
import au.gov.bafcsi.clapi.asn1.bi;
import au.gov.bafcsi.clapi.asn1.bm;
import au.gov.bafcsi.clapi.asn1.coders.CoderException;
import au.gov.bafcsi.clapi.asn1.dn;
import au.gov.bafcsi.clapi.common.DSAParameterChoice;
import au.gov.bafcsi.clapi.common.Oid;
import au.gov.bafcsi.clapi.common.Oids;
import au.gov.bafcsi.clapi.common.eq;
import au.gov.bafcsi.clapi.crypto.DsaParameters;
import au.gov.bafcsi.clapi.crypto.IvParameters;
import au.gov.bafcsi.clapi.crypto.PbeParameters;
import au.gov.bafcsi.clapi.crypto.Rc2Parameters;
import au.gov.bafcsi.common.utils.q;
import java.io.IOException;
import java.security.AlgorithmParameters;
import java.security.NoSuchAlgorithmException;
import java.security.spec.DSAParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import java.util.StringTokenizer;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEParameterSpec;
import javax.crypto.spec.RC2ParameterSpec;

public class AlgorithmIdentifier
extends az {
    private static b5 mapping = null;

    public AlgorithmIdentifier() {
        this.a((ax)new bh(), "algorithm");
        this.a((ax)new bm(new bi(this, "algorithm", mapping)), "parameters");
    }

    public AlgorithmIdentifier(Oid oid) {
        this.a((ax)new bh(oid), "algorithm");
        this.a((ax)new bm(new bi(this, "algorithm", mapping), false), "parameters");
    }

    public AlgorithmIdentifier(Oid oid, aw aw2) {
        this.a((ax)new bh(oid), "algorithm");
        if (aw2 == null) {
            this.a((ax)new bm(new bi(this, "algorithm", mapping), false), "parameters");
        } else {
            this.a((ax)new bm(new bi(this, "algorithm", mapping, aw2)), "parameters");
        }
    }

    public AlgorithmIdentifier(Oid oid, AlgorithmParameters algorithmParameters) throws InvalidParameterSpecException {
        a3 a32;
        String string = algorithmParameters.getAlgorithm();
        if (string.startsWith("RC2")) {
            a32 = new Rc2Parameters((RC2ParameterSpec)algorithmParameters.getParameterSpec(RC2ParameterSpec.class));
        } else if (string.startsWith("DES")) {
            a32 = new IvParameters((IvParameterSpec)algorithmParameters.getParameterSpec(IvParameterSpec.class));
        } else if (string.startsWith("AES")) {
            a32 = new IvParameters((IvParameterSpec)algorithmParameters.getParameterSpec(IvParameterSpec.class));
        } else if (string.startsWith("DSA")) {
            a32 = new DsaParameters((DSAParameterSpec)algorithmParameters.getParameterSpec(DSAParameterSpec.class));
        } else if (string.startsWith("PBE")) {
            a32 = new PbeParameters((PBEParameterSpec)algorithmParameters.getParameterSpec(PBEParameterSpec.class));
        } else {
            throw new InvalidParameterSpecException("AlgorithmIdentifier(ASN1ObjectIdentifier, AlgorithmParameters) - No mapping exists for the supplied AlgorithmParameters.");
        }
        this.a((ax)new bh(oid), "algorithm");
        this.a((ax)new bm(new bi(this, "algorithm", mapping, (aw)((Object)a32))), "parameters");
    }

    public String getAlgorithmName() {
        return Oids.getJCAMapping(this.getAlgorithmOID());
    }

    public Oid getAlgorithmOID() {
        return ((bh)this.a((String)"algorithm")).a;
    }

    public AlgorithmParameters getAlgorithmParameters() throws NoSuchAlgorithmException, CoderException, IOException {
        a3 a32;
        bm bm2 = (bm)this.a("parameters");
        if (bm2.a && !((a32 = (a3)bm2.getPrimitive()) instanceof dn)) {
            StringTokenizer stringTokenizer = new StringTokenizer(Oids.getJCAMapping(this.getAlgorithmOID()), "/");
            String string = stringTokenizer.nextToken();
            if (string == null) {
                string = Oids.getJCAMapping(this.getAlgorithmOID());
            }
            AlgorithmParameters algorithmParameters = q.f(string);
            algorithmParameters.init(a32.g().getBytes());
            return algorithmParameters;
        }
        return null;
    }

    static {
        mapping = new b5();
        mapping.a(Oids.tripleDesCBC, IvParameters.class);
        mapping.a(Oids.aes128CBC, IvParameters.class);
        mapping.a(Oids.aes192CBC, IvParameters.class);
        mapping.a(Oids.aes256CBC, IvParameters.class);
        mapping.a(Oids.rc2CBC, Rc2Parameters.class);
        mapping.a(Oids.rsaEncryption, dn.class);
        mapping.a(Oids.md5WithRSAEncryption, dn.class);
        mapping.a(Oids.sha1WithRSAEncryption, dn.class);
        mapping.a(Oids.dsaWithSHA1, DSAParameterChoice.class);
        mapping.a(Oids.pbeWithSHAAnd128BitRC4, eq.class);
        mapping.a(Oids.pbeWithSHAAnd40BitRC4, eq.class);
        mapping.a(Oids.pbeWithSHAAnd3_KeyTripleDES_CBC, eq.class);
        mapping.a(Oids.pbeWithSHAAnd2_KeyTripleDESCCBC, eq.class);
        mapping.a(Oids.pbeWithSHAAnd128BitRC2_CBC, eq.class);
        mapping.a(Oids.pbewithSHAAnd40BitRC2_CBC, eq.class);
        mapping.a(Oids.dsaANSI, DsaParameters.class);
    }
}

