/*
 * Decompiled with CFR 0.152.
 */
package au.gov.bafcsi.clapi.certs.extensions;

import au.gov.bafcsi.clapi.asn1.cf;
import au.gov.bafcsi.clapi.asn1.coders.CoderException;
import au.gov.bafcsi.clapi.certs.extensions.AuthorityKeyIdentifier;
import au.gov.bafcsi.common.ByteArray;
import java.io.IOException;
import java.security.cert.CertificateException;

public final class SubjectKeyIdentifier
extends cf {
    public SubjectKeyIdentifier(ByteArray byteArray) throws CertificateException {
        if (byteArray == null) {
            throw new IllegalArgumentException("SubjectKeyIdentifier(ByteArray) - The supplied ByteArray is null.");
        }
        try {
            this.a(byteArray);
        }
        catch (IOException iOException) {
            throw new CertificateException("BasicConstraints(ByteArray) - " + iOException.getMessage());
        }
        catch (CoderException coderException) {
            throw new CertificateException("BasicConstraints(ByteArray) - " + coderException.getMessage());
        }
    }

    public ByteArray getSubjectKeyIdentifier() {
        return this.j();
    }

    public String toString() {
        return "SubjectKeyIdentifier = " + this.getSubjectKeyIdentifier().toHexString();
    }

    public boolean compare(AuthorityKeyIdentifier authorityKeyIdentifier) {
        if (authorityKeyIdentifier == null) {
            throw new IllegalArgumentException("SubjectKeyIdentifier.compare(AuthorityKeyIdentifier) - The supplied AuthorityKeyIdentifier is null.");
        }
        ByteArray byteArray = authorityKeyIdentifier.getKeyIdentifier();
        if (byteArray == null) {
            return false;
        }
        return byteArray.equals(this.getSubjectKeyIdentifier());
    }

    public boolean compare(SubjectKeyIdentifier subjectKeyIdentifier) {
        if (subjectKeyIdentifier == null) {
            throw new IllegalArgumentException("SubjectKeyIdentifier.compare(SubjectKeyIdentifier) - The supplied SubjectKeyIdentifier is null.");
        }
        return this.getSubjectKeyIdentifier().equals(subjectKeyIdentifier.getSubjectKeyIdentifier());
    }
}

