/*
 * Decompiled with CFR 0.152.
 */
package au.gov.bafcsi.clapi.certs.extensions;

import au.gov.bafcsi.clapi.asn1.bh;
import au.gov.bafcsi.clapi.asn1.bq;
import au.gov.bafcsi.clapi.asn1.coders.CoderException;
import au.gov.bafcsi.clapi.common.ExtendedKeyUsageOid;
import au.gov.bafcsi.clapi.common.Oid;
import au.gov.bafcsi.clapi.common.Oids;
import au.gov.bafcsi.common.ByteArray;
import java.io.IOException;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.Iterator;

public final class ExtendedKeyUsage
extends bq {
    private boolean anyExtendedKeyUsage;
    private boolean serverAuth;
    private boolean clientAuth;
    private boolean codeSigning;
    private boolean emailProtection;
    private boolean timeStamping;
    private boolean OCSPSigning;

    public ExtendedKeyUsage(ByteArray byteArray) throws CertificateException {
        super(bh.class);
        if (byteArray == null) {
            throw new IllegalArgumentException("ExtendedKeyUsage(ByteArray) - The supplied ByteArray is null.");
        }
        try {
            this.a(byteArray);
        }
        catch (IOException iOException) {
            throw new CertificateException("ExtendedKeyUsage(ByteArray) - " + iOException.getMessage());
        }
        catch (CoderException coderException) {
            throw new CertificateException("ExtendedKeyUsage(ByteArray) - " + coderException.getMessage());
        }
        this.setExtendedKeyUsages();
    }

    public void addExtendedKeyUsage(ExtendedKeyUsageOid extendedKeyUsageOid) {
        if (extendedKeyUsageOid == null) {
            throw new IllegalArgumentException("ExtendedKeyUsage.addExtendedKeyUsage(ExtendedKeyUsageOid) - The supplied ExtendedKeyUsageOid is null.");
        }
        this.a(new bh(extendedKeyUsageOid));
    }

    public int getNumberOfExtendedKeyUsages() {
        return this.d();
    }

    public String getExtendedKeyUsage(int n10) {
        return ((bh)this.a((int)n10)).a.getValue();
    }

    public String[] getExtendedKeyUsages() {
        String[] stringArray;
        ArrayList<Oid> arrayList = new ArrayList<Oid>();
        Iterator iterator = this.a();
        while (iterator.hasNext()) {
            stringArray = (String[])iterator.next();
            arrayList.add(stringArray.a);
        }
        stringArray = new String[arrayList.size()];
        arrayList.toArray(stringArray);
        return stringArray;
    }

    public void setExtendedKeyUsages() {
        this.anyExtendedKeyUsage = this.hasExtendedKeyUsage(Oids.anyExtendedKeyUsage);
        this.serverAuth = this.hasExtendedKeyUsage(Oids.serverAuth);
        this.clientAuth = this.hasExtendedKeyUsage(Oids.clientAuth);
        this.codeSigning = this.hasExtendedKeyUsage(Oids.codeSigning);
        this.emailProtection = this.hasExtendedKeyUsage(Oids.emailProtection);
        this.timeStamping = this.hasExtendedKeyUsage(Oids.timeStamping);
        this.OCSPSigning = this.hasExtendedKeyUsage(Oids.OCSPSigning);
    }

    public boolean hasExtendedKeyUsage(ExtendedKeyUsageOid extendedKeyUsageOid) {
        if (extendedKeyUsageOid == null) {
            throw new IllegalArgumentException("ExtendedKeyUsage.hasExtendedKeyUsage(ExtendedKeyUsageOid) - The supplied ExtendedKeyUsageOid is null.");
        }
        Iterator iterator = this.a();
        while (iterator.hasNext()) {
            bh bh2 = (bh)iterator.next();
            if (!bh2.a.equals(extendedKeyUsageOid)) continue;
            return true;
        }
        return false;
    }

    public boolean canDoAuthenticationSigning() {
        return this.anyExtendedKeyUsage || this.serverAuth || this.clientAuth || this.codeSigning || this.emailProtection || this.timeStamping || this.OCSPSigning;
    }

    public boolean canDoNonRepudiationSigning() {
        return this.anyExtendedKeyUsage || this.emailProtection || this.timeStamping || this.OCSPSigning;
    }

    public boolean canDoEncryption() {
        return this.anyExtendedKeyUsage || this.serverAuth || this.emailProtection;
    }
}

