/*
 * Decompiled with CFR 0.152.
 */
package au.gov.bafcsi.clapi.certs.extensions;

import au.gov.bafcsi.clapi.asn1.bq;
import au.gov.bafcsi.clapi.asn1.coders.CoderException;
import au.gov.bafcsi.clapi.certs.extensions.CPSuri;
import au.gov.bafcsi.clapi.certs.extensions.NoticeReference;
import au.gov.bafcsi.clapi.certs.extensions.PolicyInformation;
import au.gov.bafcsi.clapi.certs.extensions.PolicyQualifierInfo;
import au.gov.bafcsi.clapi.certs.extensions.PolicyQualifiers;
import au.gov.bafcsi.clapi.certs.extensions.Qualifier;
import au.gov.bafcsi.clapi.certs.extensions.UserNotice;
import au.gov.bafcsi.clapi.common.Oid;
import au.gov.bafcsi.common.ByteArray;
import java.io.IOException;
import java.io.InputStream;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.Iterator;

public final class CertificatePolicies
extends bq {
    public CertificatePolicies(InputStream inputStream) throws CertificateException {
        super(PolicyInformation.class);
        if (inputStream == null) {
            throw new IllegalArgumentException("CertificatePolicies(InputStream) - The supplied InputStream is null.");
        }
        try {
            this.decode(inputStream);
        }
        catch (IOException iOException) {
            throw new CertificateException("CertificatePolicies(InputStream) - " + iOException.getMessage());
        }
        catch (CoderException coderException) {
            throw new CertificateException("CertificatePolicies(InputStream) - " + coderException.getMessage());
        }
    }

    public CertificatePolicies(ByteArray byteArray) throws CertificateException {
        super(PolicyInformation.class);
        if (byteArray == null) {
            throw new IllegalArgumentException("CertificatePolicies(ByteArray) - The supplied ByteArray is null.");
        }
        try {
            this.a(byteArray);
        }
        catch (IOException iOException) {
            throw new CertificateException("CertificatePolicies(ByteArray) - " + iOException.getMessage());
        }
        catch (CoderException coderException) {
            throw new CertificateException("CertificatePolicies(ByteArray) - " + coderException.getMessage());
        }
    }

    public int getNumberOfPolicies() {
        return this.d();
    }

    public PolicyInformation getPolicyInformation(int n10) {
        if (n10 < 0 || n10 >= this.d()) {
            throw new IndexOutOfBoundsException("CertificatePolicies.getPolicyInformation(int) - The supplied index < 0 or >= getNumberOfComponents().");
        }
        return (PolicyInformation)this.a(n10);
    }

    public PolicyInformation getPolicyInformation(Oid oid) {
        if (oid == null) {
            throw new IllegalArgumentException("CertificatePolicies.getPolicyInformation(Oid) - The supplied Oid is null.");
        }
        Iterator iterator = this.a();
        while (iterator.hasNext()) {
            PolicyInformation policyInformation = (PolicyInformation)iterator.next();
            if (!policyInformation.hasPolicyIdentifier(oid)) continue;
            return policyInformation;
        }
        return null;
    }

    public String[] getCertPolicyIds() {
        String[] stringArray;
        ArrayList<String> arrayList = new ArrayList<String>();
        Iterator iterator = this.a();
        while (iterator.hasNext()) {
            stringArray = (String[])iterator.next();
            arrayList.add(stringArray.getPolicyIdentifier().toString());
        }
        stringArray = new String[arrayList.size()];
        arrayList.toArray(stringArray);
        return stringArray;
    }

    public boolean hasPolicyInformation(Oid oid) {
        if (oid == null) {
            throw new IllegalArgumentException("CertificatePolicies.hasPolicyInformation(Oid) - The supplied Oid is null.");
        }
        Iterator iterator = this.a();
        while (iterator.hasNext()) {
            PolicyInformation policyInformation = (PolicyInformation)iterator.next();
            if (!policyInformation.hasPolicyIdentifier(oid)) continue;
            return true;
        }
        return false;
    }

    public boolean hasSubordinatePolicyInformation(Oid oid) {
        if (oid == null) {
            throw new IllegalArgumentException("CertificatePolicies.hasSubordinatePolicyInformation(X509ExtensionOid) - The supplied X509ExtensionOid is null.");
        }
        Iterator iterator = this.a();
        while (iterator.hasNext()) {
            PolicyInformation policyInformation = (PolicyInformation)iterator.next();
            if (!policyInformation.hasSubordinatePolicyIdentifier(oid)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("CertificatePolicies (");
        int n10 = this.getNumberOfPolicies();
        stringBuffer.append(n10);
        stringBuffer.append(" policy information(s))\r\n");
        for (int i10 = 0; i10 < n10; ++i10) {
            PolicyInformation policyInformation = this.getPolicyInformation(i10);
            stringBuffer.append("  [" + i10 + "] PolicyInformation - ");
            stringBuffer.append(policyInformation.getPolicyIdentifier().toString());
            stringBuffer.append("\r\n");
            PolicyQualifiers policyQualifiers = policyInformation.getPolicyQualifiers();
            if (policyQualifiers == null) continue;
            int n11 = policyQualifiers.getNumberOfQualifierInfos();
            stringBuffer.append("      PolicyQualifiers (");
            stringBuffer.append(n11);
            stringBuffer.append(" policy qualifier info(s))\r\n");
            for (int i11 = 0; i11 < n11; ++i11) {
                String string;
                PolicyQualifierInfo policyQualifierInfo = policyQualifiers.getPolicyQualifierInfo(i11);
                stringBuffer.append("        [" + i11 + "] PolicyQualifierId = ");
                stringBuffer.append(policyQualifierInfo.getPolicyQualifierId().toString());
                stringBuffer.append("\r\n");
                Qualifier qualifier = policyQualifierInfo.getQualifier();
                if (qualifier instanceof CPSuri) {
                    stringBuffer.append("            CPSuri - ");
                    stringBuffer.append(qualifier.toString());
                    stringBuffer.append("\r\n");
                    continue;
                }
                if (!(qualifier instanceof UserNotice)) continue;
                UserNotice userNotice = (UserNotice)qualifier;
                stringBuffer.append("            UserNotice -\r\n");
                NoticeReference noticeReference = userNotice.getNoticeReference();
                if (noticeReference != null) {
                    stringBuffer.append("              NoticeReference -\r\n");
                    stringBuffer.append("                organisation = ");
                    stringBuffer.append(noticeReference.getOrganization());
                    stringBuffer.append("\r\n");
                    stringBuffer.append("                noticeNumbers = ");
                    stringBuffer.append(noticeReference.getNoticeNumbersAsString());
                    stringBuffer.append("\r\n");
                }
                if ((string = userNotice.getExplicitText()) == null) continue;
                stringBuffer.append("              ExplicitText = ");
                stringBuffer.append(string);
                stringBuffer.append("\r\n");
            }
        }
        return stringBuffer.toString();
    }
}

