/*
 * Decompiled with CFR 0.152.
 */
package au.gov.bafcsi.clapi.certs.extensions;

import au.gov.bafcsi.clapi.asn1.bq;
import au.gov.bafcsi.clapi.asn1.coders.CoderException;
import au.gov.bafcsi.clapi.certs.GeneralNames;
import au.gov.bafcsi.clapi.certs.extensions.DistributionPoint;
import au.gov.bafcsi.clapi.certs.extensions.DistributionPointName;
import au.gov.bafcsi.clapi.certs.extensions.ReasonFlags;
import au.gov.bafcsi.common.ByteArray;
import java.io.IOException;
import java.security.cert.CertificateException;

public final class CRLDistributionPoints
extends bq {
    public CRLDistributionPoints(ByteArray byteArray) throws CertificateException {
        super(DistributionPoint.class);
        if (byteArray == null) {
            throw new IllegalArgumentException("CRLDistributionPoints(ByteArray) - The supplied ByteArray is null.");
        }
        try {
            this.a(byteArray);
        }
        catch (IOException iOException) {
            throw new CertificateException("CRLDistributionPoints(ByteArray) - " + iOException.getMessage());
        }
        catch (CoderException coderException) {
            throw new CertificateException("CRLDistributionPoints(ByteArray) - " + coderException.getMessage());
        }
    }

    public int getNumberOfDistributionPoints() {
        return this.d();
    }

    public DistributionPoint getDistributionPoint(int n10) {
        return (DistributionPoint)this.a(n10);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("CRLDistributionPoints (");
        int n10 = this.getNumberOfDistributionPoints();
        stringBuffer.append(n10);
        stringBuffer.append(" distribution point(s))\r\n");
        for (int i10 = 0; i10 < n10; ++i10) {
            GeneralNames generalNames;
            ReasonFlags reasonFlags;
            DistributionPoint distributionPoint = this.getDistributionPoint(i10);
            stringBuffer.append("  [" + i10 + "] DistributionPoint -\r\n");
            DistributionPointName distributionPointName = distributionPoint.getDistributionPointName();
            if (distributionPointName != null) {
                stringBuffer.append("        DistributionPointName - ");
                stringBuffer.append(distributionPointName.toString());
                stringBuffer.append("\r\n");
            }
            if ((reasonFlags = distributionPoint.getReasons()) != null) {
                stringBuffer.append("        ReasonFlags - ");
                stringBuffer.append(reasonFlags.toString());
                stringBuffer.append("\r\n");
            }
            if ((generalNames = distributionPoint.getCRLIssuer()) == null) continue;
            stringBuffer.append("        CRLIssuer - ");
            stringBuffer.append(generalNames.toString());
            stringBuffer.append("\r\n");
        }
        return stringBuffer.toString();
    }
}

