/*
 * Decompiled with CFR 0.152.
 */
package au.gov.bafcsi.chunk;

import au.gov.bafcsi.chunk.CertificateStatus;
import au.gov.bafcsi.chunk.Chunk;
import au.gov.bafcsi.chunk.SigningConfig;
import au.gov.bafcsi.chunk.SigningStatus;
import au.gov.bafcsi.chunk.UserId;
import au.gov.bafcsi.clapi.certs.extensions.KeyUsage;
import au.gov.bafcsi.clapi.crypto.CertificateStore;
import au.gov.bafcsi.clapi.crypto.CsiCertificate;
import au.gov.bafcsi.clapi.crypto.CsiPrivateKey;
import au.gov.bafcsi.clapi.packaging.cms.full.SigningParameters;
import au.gov.bafcsi.clapi.packaging.smime.SignedSMimeOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.cert.X509Certificate;

public final class SmimeSigner {
    private ByteArrayOutputStream baos;
    private SignedSMimeOutputStream smime;

    public SigningStatus start(SigningConfig signingConfig) throws Exception {
        if (signingConfig == null) {
            throw new IllegalArgumentException("SmimeSigner.start(SigningConfig): SigningConfig is null.");
        }
        UserId userId = signingConfig.getSigner();
        X509Certificate x509Certificate = userId.getCertificate();
        if (!new KeyUsage(x509Certificate.getKeyUsage()).hasUsage(0)) {
            throw new IllegalArgumentException("SmimeSigner.start(SigningConfig): The specified certificate is not permitted to sign data.");
        }
        CsiPrivateKey csiPrivateKey = CertificateStore.getInstance().getPrivateKey(new CsiCertificate(x509Certificate));
        if (csiPrivateKey == null) {
            throw new IllegalArgumentException("SmimeSigner.start(SigningConfig): No PrivateKey matches the specified signing certificate.");
        }
        SigningStatus signingStatus = new SigningStatus(x509Certificate);
        CertificateStatus certificateStatus = signingStatus.getSignerStatus();
        boolean bl2 = certificateStatus.getValidityCheck().isCheckPerformed();
        boolean bl3 = certificateStatus.getValidityCheck().isCheckPassed();
        if (!bl2 || !bl3) {
            throw new IllegalArgumentException("SmimeSigner.start(SigningConfig): SigningConfig does not contain a valid signer certificate.");
        }
        this.baos = new ByteArrayOutputStream(10240);
        SigningParameters signingParameters = new SigningParameters(new CsiCertificate(x509Certificate));
        signingParameters.setDigestAlgorithm(signingConfig.getHashAlgorithm().getAlgorithmOid());
        this.smime = new SignedSMimeOutputStream(this.baos, signingParameters);
        return signingStatus;
    }

    public Chunk update(Chunk chunk) throws IOException {
        if (chunk == null) {
            throw new IllegalArgumentException("SmimeSigner.update(Chunk): Chunk is null");
        }
        byte[] byArray = chunk.getData();
        if (byArray != null && byArray.length > 0) {
            this.smime.write(byArray);
        }
        byte[] byArray2 = this.baos.toByteArray();
        this.baos.reset();
        return new Chunk(chunk.getId(), byArray2);
    }

    public Chunk finish() throws IOException {
        this.smime.close();
        return new Chunk(-1L, this.baos.toByteArray());
    }
}

