/*
 * Decompiled with CFR 0.152.
 */
package au.gov.bafcsi.chunk;

import au.gov.bafcsi.clapi.common.DigestOid;
import au.gov.bafcsi.clapi.common.Oids;

public final class HashAlgorithm {
    private String algorithm = Oids.getJCAMapping(Oids.sha1);

    public HashAlgorithm() {
    }

    public HashAlgorithm(String string) {
        this.setHashAlgorithm(string);
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    DigestOid getAlgorithmOid() {
        return (DigestOid)Oids.getOIDMapping(this.algorithm);
    }

    private void setHashAlgorithm(String string) {
        if (this.algorithm == null) {
            throw new IllegalArgumentException("HashAlgorithm.setHashAlgorithm(String): String is null");
        }
        if (string.equalsIgnoreCase("SHA") || string.equalsIgnoreCase("SHA-1") || string.equalsIgnoreCase("SHA1")) {
            this.algorithm = Oids.getJCAMapping(Oids.sha1);
        } else if (string.equalsIgnoreCase("SHA256") || string.equalsIgnoreCase("SHA-256")) {
            this.algorithm = Oids.getJCAMapping(Oids.sha256);
        } else if (string.indexOf("MD5") != -1) {
            this.algorithm = Oids.getJCAMapping(Oids.md5);
        } else {
            throw new IllegalArgumentException("HashAlgorithm.setHashAlgorithm(String): String specifies an invalid algorithm.");
        }
    }
}

