/*
 * Decompiled with CFR 0.152.
 */
package au.gov.bafcsi.chunk;

import au.gov.bafcsi.clapi.common.Oids;
import au.gov.bafcsi.clapi.common.SymmetricCipherOid;

public final class EncryptionAlgorithm {
    private String algorithm = Oids.getJCAMapping(Oids.tripleDesCBC);

    public EncryptionAlgorithm() {
    }

    public EncryptionAlgorithm(String string) {
        this.setEncryptionAlgorithm(string);
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    SymmetricCipherOid getAlgorithmOid() {
        return (SymmetricCipherOid)Oids.getOIDMapping(this.algorithm);
    }

    private void setEncryptionAlgorithm(String string) {
        if (string == null) {
            throw new IllegalArgumentException("EncryptionAlgorithm.setEncryptionAlgorithm(String): The supplied String is null.");
        }
        if (string.indexOf("3DES") != -1) {
            this.algorithm = Oids.getJCAMapping(Oids.tripleDesCBC);
        } else if (string.indexOf("DESede") != -1) {
            this.algorithm = Oids.getJCAMapping(Oids.tripleDesCBC);
        } else if (string.indexOf("AES") != -1) {
            this.algorithm = Oids.getJCAMapping(Oids.aes128CBC);
        } else {
            throw new IllegalArgumentException("EncryptionAlgorithm.setEncryptionAlgorithm(String): The supplied String specifies an invalid algorithm (" + string + ").");
        }
        this.algorithm = string;
    }
}

