/*
 * Decompiled with CFR 0.152.
 */
package au.gov.bafcsi.applet;

import au.gov.bafcsi.applet.b;
import au.gov.bafcsi.applet.c;
import au.gov.bafcsi.applet.d;
import au.gov.bafcsi.applet.e;
import au.gov.bafcsi.applet.f;
import au.gov.bafcsi.applet.h;
import au.gov.bafcsi.applet.i;
import au.gov.bafcsi.applet.j;
import au.gov.bafcsi.applet.k;
import au.gov.bafcsi.applet.l;
import au.gov.bafcsi.applet.m;
import au.gov.bafcsi.applet.n;
import au.gov.bafcsi.applet.o;
import au.gov.bafcsi.applet.x;
import au.gov.bafcsi.clapi.crypto.g;
import au.gov.bafcsi.common.ByteArray;
import au.gov.bafcsi.common.utils.base64.Base64;
import au.gov.bafcsi.common.utils.q;
import au.gov.bafcsi.hapi.Csi;
import au.gov.bafcsi.hapi.ErrorCode;
import java.awt.Component;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import java.security.AccessController;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import javax.swing.ImageIcon;

public class HapiWrapper {
    private Csi m_Csi = null;
    private byte[] m_plainText;
    private byte[] m_package;
    private String m_termsConditions;
    private String m_encryptionCert;
    private final String m_encodingCharset;
    private f m_lastPackageInfo;
    private final b m_csiInitializationLatch = new b();
    public static final String PLATFORM_ENCODING = "__PLATFORM-TEXT-ENCODING__";
    public static final int SUCCESS = 0;
    public static final int INVALID_CERT = 1;
    public static final int NO_CERT_FOR_SIGNATURE = 2;
    public static final int INVALID_PACKAGE = 3;
    public static final int CANCELLED_OPERATION = 4;
    public static final int ILLEGAL_ARGUMENT = 5;
    public static final int CSI_GENERAL = 6;
    public static final int UNDEFINED = 7;
    public static final int UNSUPPORTED_CODING = 8;
    private g m_splash;
    private static final x ATO_SPLASH_RESOURCE = new x(null);

    public HapiWrapper() {
        this(ATO_SPLASH_RESOURCE, PLATFORM_ENCODING);
    }

    public HapiWrapper(ImageIcon imageIcon) {
        this(imageIcon, PLATFORM_ENCODING);
    }

    public HapiWrapper(String string) throws UnsupportedCharsetException {
        this(ATO_SPLASH_RESOURCE, string);
    }

    public HapiWrapper(ImageIcon imageIcon, String string) throws UnsupportedCharsetException {
        if (string.equals(PLATFORM_ENCODING)) {
            this.logInformationMessage("Setting HapiWrapper encoding to platform default");
            this.m_encodingCharset = string;
        } else {
            try {
                if (!Charset.forName(string).canEncode()) {
                    throw new UnsupportedCharsetException("This Java/OS platform doesn't support encoding to the given encoding: " + string);
                }
            }
            catch (IllegalCharsetNameException illegalCharsetNameException) {
                throw new UnsupportedCharsetException(illegalCharsetNameException.getMessage());
            }
            this.logInformationMessage("Setting HapiWrapper encoding to: " + string);
            this.m_encodingCharset = string;
        }
        this.init(imageIcon);
    }

    private void init(ImageIcon imageIcon) {
        AccessController.doPrivileged(new d(this, imageIcon));
        Thread thread = new Thread(new e(this));
        thread.setPriority(10);
        thread.start();
    }

    public int signForAuthentication(String string, String string2) {
        if (string == null || string2 == null) {
            this.m_lastPackageInfo = new f(ErrorCode.ILLEGAL_ARGUEMENT_EXCEPTION.getErrorCode(), "The parameters passed to the method HapiWrapper.signForAuthentication() cannot be null.");
            return 5;
        }
        if (!this.CanEncodePlainText(string)) {
            this.m_lastPackageInfo = new f(ErrorCode.UNSUPPORTED_CODING_EXCEPTION.getErrorCode(), "The plainText passed to the method HapiWrapper.signForAuthentication() cannot be encoded using the chosen encoding [" + this.m_encodingCharset + "].");
            return 8;
        }
        this.waitForCsiInstantiation();
        this.m_plainText = HapiWrapper.EncodeToChosenCharset(string, this.m_encodingCharset);
        this.m_termsConditions = string2;
        Integer n10 = (Integer)AccessController.doPrivileged(new h(this));
        this.logInformationMessage("HapiWrapper signForAuthentication finished.");
        return n10;
    }

    public int signForAuthenticationAndEncrypt(String string, String string2, String string3) {
        if (string == null || string2 == null || string3 == null) {
            this.m_lastPackageInfo = new f(ErrorCode.ILLEGAL_ARGUEMENT_EXCEPTION.getErrorCode(), "The parameters passed to the method HapiWrapper.signForAuthenticationAndEncrypt() cannot be null.");
            return 5;
        }
        if (!this.CanEncodePlainText(string)) {
            this.m_lastPackageInfo = new f(ErrorCode.UNSUPPORTED_CODING_EXCEPTION.getErrorCode(), "The plainText passed to the method HapiWrapper.signForAuthentication() cannot be encoded using the chosen encoding [" + this.m_encodingCharset + "].");
            return 8;
        }
        this.waitForCsiInstantiation();
        this.m_plainText = HapiWrapper.EncodeToChosenCharset(string, this.m_encodingCharset);
        this.m_termsConditions = string2;
        this.m_encryptionCert = string3;
        Integer n10 = (Integer)AccessController.doPrivileged(new i(this));
        this.logInformationMessage("HapiWrapper signForAuthenticationAndEncrypt finished.");
        return n10;
    }

    public int signForNonRepudiation(String string, String string2) {
        if (string == null || string2 == null) {
            this.m_lastPackageInfo = new f(ErrorCode.ILLEGAL_ARGUEMENT_EXCEPTION.getErrorCode(), "The parameters passed to the method HapiWrapper.signForNonRepudiation() cannot be null.");
            return 5;
        }
        if (!this.CanEncodePlainText(string)) {
            this.m_lastPackageInfo = new f(ErrorCode.UNSUPPORTED_CODING_EXCEPTION.getErrorCode(), "The plainText passed to the method HapiWrapper.signForAuthentication() cannot be encoded using the chosen encoding [" + this.m_encodingCharset + "].");
            return 8;
        }
        this.waitForCsiInstantiation();
        this.m_plainText = HapiWrapper.EncodeToChosenCharset(string, this.m_encodingCharset);
        this.m_termsConditions = string2;
        Integer n10 = (Integer)AccessController.doPrivileged(new j(this));
        this.logInformationMessage("HapiWrapper signForNonRepudiation finished.");
        return n10;
    }

    public int signForNonRepudiationAndEncrypt(String string, String string2, String string3) {
        if (string == null || string2 == null || string3 == null) {
            this.m_lastPackageInfo = new f(ErrorCode.ILLEGAL_ARGUEMENT_EXCEPTION.getErrorCode(), "The parameters passed to the method HapiWrapper.signForNonRepudiationAndEncrypt() cannot be null.");
            return 5;
        }
        if (!this.CanEncodePlainText(string)) {
            this.m_lastPackageInfo = new f(ErrorCode.UNSUPPORTED_CODING_EXCEPTION.getErrorCode(), "The plainText passed to the method HapiWrapper.signForAuthentication() cannot be encoded using the chosen encoding [" + this.m_encodingCharset + "].");
            return 8;
        }
        this.waitForCsiInstantiation();
        this.m_plainText = HapiWrapper.EncodeToChosenCharset(string, this.m_encodingCharset);
        this.m_termsConditions = string2;
        this.m_encryptionCert = string3;
        Integer n10 = (Integer)AccessController.doPrivileged(new k(this));
        this.logInformationMessage("HapiWrapper signForNonRepudiationAndEncrypt finished.");
        return n10;
    }

    public int encrypt(String string, String string2) {
        if (string == null || string2 == null) {
            this.m_lastPackageInfo = new f(ErrorCode.ILLEGAL_ARGUEMENT_EXCEPTION.getErrorCode(), "The parameters passed to the method HapiWrapper.encrypt() cannot be null.");
            return 5;
        }
        this.waitForCsiInstantiation();
        this.m_plainText = string.getBytes();
        this.m_encryptionCert = string2;
        Integer n10 = (Integer)AccessController.doPrivileged(new l(this));
        this.logInformationMessage("HapiWrapper encrypt finished.");
        return n10;
    }

    public int verify(String string) {
        if (string == null) {
            this.m_lastPackageInfo = new f(ErrorCode.ILLEGAL_ARGUEMENT_EXCEPTION.getErrorCode(), "The parameters passed to the method HapiWrapper.verify() cannot be null.");
            return 5;
        }
        this.waitForCsiInstantiation();
        this.m_package = string.getBytes();
        Integer n10 = (Integer)AccessController.doPrivileged(new m(this));
        this.logInformationMessage("HapiWrapper verify finished.");
        return n10;
    }

    public int decryptAndVerify(String string) {
        if (string == null) {
            this.m_lastPackageInfo = new f(ErrorCode.ILLEGAL_ARGUEMENT_EXCEPTION.getErrorCode(), "The parameters passed to the method HapiWrapper.decryptAndVerify() cannot be null.");
            return 5;
        }
        this.waitForCsiInstantiation();
        this.m_package = string.getBytes();
        Integer n10 = (Integer)AccessController.doPrivileged(new n(this));
        this.logInformationMessage("HapiWrapper decryptAndVerify finished.");
        return n10;
    }

    public int decrypt(String string) {
        if (string == null) {
            this.m_lastPackageInfo = new f(ErrorCode.ILLEGAL_ARGUEMENT_EXCEPTION.getErrorCode(), "The parameters passed to the method HapiWrapper.decryptAndVerify() cannot be null.");
            return 5;
        }
        this.waitForCsiInstantiation();
        this.m_package = string.getBytes();
        Integer n10 = (Integer)AccessController.doPrivileged(new o(this));
        this.logInformationMessage("HapiWrapper decrypt finished.");
        return n10;
    }

    private X509Certificate decodedEncryptionCertificate(String string) throws CertificateException, IOException {
        ByteArray byteArray = null;
        byte[] byArray = null;
        X509Certificate x509Certificate = null;
        if (string == null) {
            throw new CertificateException("null certificate");
        }
        byteArray = new ByteArray(string.getBytes());
        byArray = Base64.decode(byteArray).getDefensiveBytes();
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        CertificateFactory certificateFactory = q.b();
        x509Certificate = (X509Certificate)certificateFactory.generateCertificate(byteArrayInputStream);
        ((InputStream)byteArrayInputStream).close();
        return x509Certificate;
    }

    public String getPackage() {
        return this.m_lastPackageInfo.a;
    }

    public String getMessage() {
        return this.m_lastPackageInfo.b;
    }

    public String getSigningCertificateFingerprint() {
        return this.m_lastPackageInfo.d;
    }

    public String getSigningCertificateAbn() {
        return this.m_lastPackageInfo.c;
    }

    public String getIsSignedForNonRepudiation() {
        return this.m_lastPackageInfo.f;
    }

    public String getSigningTime() {
        return this.m_lastPackageInfo.e;
    }

    public String getLastErrorCode() {
        return String.valueOf(this.m_lastPackageInfo.h);
    }

    public String getLastErrorCodeFromHapi() {
        return String.valueOf(this.m_lastPackageInfo.j);
    }

    public String getLastCancelledOperationBadPasswords() {
        if (this.m_lastPackageInfo.h == 4) {
            return String.valueOf(this.m_lastPackageInfo.i);
        }
        return "";
    }

    public String getLastErrorMessage() {
        return this.m_lastPackageInfo.g;
    }

    public void logDebugMessage(String string) {
        System.out.println(string);
        System.out.flush();
    }

    private void waitForCsiInstantiation() {
        if (this.m_Csi == null) {
            if (this.m_splash != null) {
                ((Component)this.m_splash).setVisible(true);
            }
            long l10 = System.currentTimeMillis();
            try {
                if (!this.m_csiInitializationLatch.a(60000L)) {
                    this.logInformationMessage("CSI was not initialised within 60 seconds of the splash screen");
                }
            }
            catch (InterruptedException interruptedException) {
                this.logInformationMessage("The thread was interrupted while waiting for the CSI initialisation latch to release");
            }
            long l11 = System.currentTimeMillis() - (l10 + 1000L);
            if (l11 > 0L) {
                try {
                    Thread.sleep(l11);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            if (this.m_splash != null) {
                ((Component)this.m_splash).setVisible(false);
            }
        }
    }

    private void logInformationMessage(String string) {
        AccessController.doPrivileged(new c(this, string));
    }

    public synchronized void cleanUp() {
        this.m_package = null;
        this.m_encryptionCert = null;
        this.m_lastPackageInfo = null;
        System.gc();
    }

    private boolean CanEncodePlainText(String string) {
        if (this.m_encodingCharset.equals(PLATFORM_ENCODING)) {
            return true;
        }
        Charset charset = Charset.forName(this.m_encodingCharset);
        CharsetEncoder charsetEncoder = charset.newEncoder();
        if (charsetEncoder.canEncode(string)) {
            try {
                ByteBuffer byteBuffer = charsetEncoder.encode(CharBuffer.wrap(string));
                charset.newDecoder().decode(byteBuffer);
            }
            catch (CharacterCodingException characterCodingException) {
                return false;
            }
            return true;
        }
        return false;
    }

    static byte[] EncodeToChosenCharset(String string, String string2) {
        if (string2.equals(PLATFORM_ENCODING)) {
            return string.getBytes();
        }
        ByteBuffer byteBuffer = Charset.forName(string2).encode(string);
        byte[] byArray = new byte[byteBuffer.limit()];
        byteBuffer.get(byArray);
        return byArray;
    }

    static String DecodeFromChosenCharset(byte[] byArray, String string) {
        if (string.equals(PLATFORM_ENCODING)) {
            return new String(byArray);
        }
        Charset charset = Charset.forName(string);
        return charset.decode(ByteBuffer.wrap(byArray)).toString();
    }

    static /* synthetic */ void access$100(HapiWrapper hapiWrapper, String string) {
        hapiWrapper.logInformationMessage(string);
    }

    static /* synthetic */ g access$202(HapiWrapper hapiWrapper, g g10) {
        hapiWrapper.m_splash = g10;
        return hapiWrapper.m_splash;
    }

    static /* synthetic */ x access$300() {
        return ATO_SPLASH_RESOURCE;
    }

    static /* synthetic */ Csi access$502(HapiWrapper hapiWrapper, Csi csi) {
        hapiWrapper.m_Csi = csi;
        return hapiWrapper.m_Csi;
    }

    static /* synthetic */ b access$600(HapiWrapper hapiWrapper) {
        return hapiWrapper.m_csiInitializationLatch;
    }

    static /* synthetic */ byte[] access$702(HapiWrapper hapiWrapper, byte[] byArray) {
        hapiWrapper.m_package = byArray;
        return byArray;
    }

    static /* synthetic */ byte[] access$800(HapiWrapper hapiWrapper) {
        return hapiWrapper.m_plainText;
    }

    static /* synthetic */ String access$900(HapiWrapper hapiWrapper) {
        return hapiWrapper.m_termsConditions;
    }

    static /* synthetic */ Csi access$500(HapiWrapper hapiWrapper) {
        return hapiWrapper.m_Csi;
    }

    static /* synthetic */ f access$1002(HapiWrapper hapiWrapper, f f10) {
        hapiWrapper.m_lastPackageInfo = f10;
        return hapiWrapper.m_lastPackageInfo;
    }

    static /* synthetic */ byte[] access$700(HapiWrapper hapiWrapper) {
        return hapiWrapper.m_package;
    }

    static /* synthetic */ String access$1100(HapiWrapper hapiWrapper) {
        return hapiWrapper.m_encryptionCert;
    }

    static /* synthetic */ X509Certificate access$1200(HapiWrapper hapiWrapper, String string) throws CertificateException, IOException {
        return hapiWrapper.decodedEncryptionCertificate(string);
    }

    static /* synthetic */ String access$1300(HapiWrapper hapiWrapper) {
        return hapiWrapper.m_encodingCharset;
    }

    static /* synthetic */ f access$1000(HapiWrapper hapiWrapper) {
        return hapiWrapper.m_lastPackageInfo;
    }

    static /* synthetic */ byte[] access$802(HapiWrapper hapiWrapper, byte[] byArray) {
        hapiWrapper.m_plainText = byArray;
        return byArray;
    }
}

