/*
 * Decompiled with CFR 0.152.
 */
package au.gov.bafcsi.common.utils;

import au.gov.bafcsi.common.utils.ad;
import au.gov.bafcsi.common.utils.aq;
import au.gov.bafcsi.common.utils.j2;
import au.gov.bafcsi.common.utils.r;
import au.gov.bafcsi.common.utils.w;
import java.awt.Frame;
import java.awt.HeadlessException;
import javax.swing.SwingUtilities;

public class IncomingNativeUtils {
    private static final Object LOAD_LIBRARY_LOCK = new Object();
    private static boolean m_libraryIsLoaded;

    public static void jvmCleanup() {
        IncomingNativeUtils.disposeAwtFrames();
        IncomingNativeUtils.interruptUserThreads();
        IncomingNativeUtils.shutdownAccessibility();
    }

    private static void shutdownAccessibility() {
        IncomingNativeUtils.stopAccessibleMonitorThread();
        try {
            IncomingNativeUtils.loadNativeLibrary();
            IncomingNativeUtils.jniShutdownNativeAccessibility();
        }
        catch (Throwable throwable) {
            r.a(w.g, throwable.getMessage(), throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadNativeLibrary() {
        Object object = LOAD_LIBRARY_LOCK;
        synchronized (object) {
            if (!m_libraryIsLoaded) {
                try {
                    ad.a("CSINative");
                    m_libraryIsLoaded = true;
                }
                catch (aq aq2) {
                    String string = "IncomingNativeUtils: Unable to load the CSINative.dll";
                    r.a(w.g, string, aq2);
                }
            }
        }
    }

    private static native void jniShutdownNativeAccessibility();

    private static void stopAccessibleMonitorThread() {
        Thread[] threadArray = IncomingNativeUtils.getAllCurrentThreads();
        for (int i10 = 0; i10 < threadArray.length; ++i10) {
            Thread thread = threadArray[i10];
            if (!thread.getName().startsWith("EventQueueMonitor-ComponentEvtDispatch")) continue;
            thread.stop();
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void interruptUserThreads() {
        Thread[] threadArray = IncomingNativeUtils.getAllCurrentThreads();
        Thread thread = Thread.currentThread();
        for (int i10 = 0; i10 < threadArray.length; ++i10) {
            Thread thread2 = threadArray[i10];
            if (thread2.isDaemon() || !thread2.isAlive() || thread2 == thread) continue;
            try {
                System.out.println(thread2);
                thread2.join(1000L);
                thread2.interrupt();
                continue;
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            finally {
                if (!thread2.isInterrupted()) {
                    thread2.interrupt();
                }
            }
        }
    }

    private static Thread[] getAllCurrentThreads() {
        ThreadGroup threadGroup = IncomingNativeUtils.getRootThreadGroup();
        int n10 = threadGroup.activeCount();
        n10 = n10 % 2 == 1 ? ++n10 : (n10 += 2);
        Thread[] threadArray = new Thread[n10];
        int n11 = threadGroup.enumerate(threadArray, true);
        while (n11 == n10) {
            n10 += n10 / 2;
            threadArray = new Thread[n10];
            n11 = threadGroup.enumerate(threadArray, true);
        }
        Thread[] threadArray2 = new Thread[n11];
        System.arraycopy(threadArray, 0, threadArray2, 0, n11);
        return threadArray2;
    }

    private static ThreadGroup getRootThreadGroup() {
        ThreadGroup threadGroup = Thread.currentThread().getThreadGroup();
        while (threadGroup.getParent() != null) {
            threadGroup = threadGroup.getParent();
        }
        return threadGroup;
    }

    private static void disposeAwtFrames() {
        try {
            Frame[] frameArray = Frame.getFrames();
            for (int i10 = 0; i10 < frameArray.length; ++i10) {
                Frame frame = frameArray[i10];
                if (!frame.isDisplayable()) continue;
                SwingUtilities.invokeLater(new j2(frame));
            }
        }
        catch (HeadlessException headlessException) {
            r.a(w.i, "jvmCleanup(): Headless Exception while getting/disposing Frames.", headlessException);
        }
    }
}

