/*
 * Decompiled with CFR 0.152.
 */
package au.gov.bafcsi.common;

import au.gov.bafcsi.clapi.crypto.CertStoreException;
import au.gov.bafcsi.clapi.crypto.CertificateCollection;
import au.gov.bafcsi.clapi.crypto.CertificateStore;
import au.gov.bafcsi.clapi.crypto.CsiCertificate;
import au.gov.bafcsi.clapi.crypto.fi;
import au.gov.bafcsi.common.CertSelectGui;
import au.gov.bafcsi.common.SignGui;
import au.gov.bafcsi.common.UserPreferences;
import au.gov.bafcsi.common.iv;
import au.gov.bafcsi.common.jb;
import au.gov.bafcsi.common.utils.ae;
import au.gov.bafcsi.common.utils.i9;
import au.gov.bafcsi.common.utils.r;
import au.gov.bafcsi.common.utils.s;
import au.gov.bafcsi.common.utils.w;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;

public class CertificateSelector {
    private final int MILLISECS_IN_A_DAY = 86400000;
    private final int MILLISECS_IN_AN_HOUR = 3600000;
    private final long CERT_EXPIRY_WARNING_PERIOD = 14L;
    private String m_oldSigningTermsConditions = "";
    private CsiCertificate m_oldSigningCertificate = null;
    private boolean m_lastSignOperationSuccessful = false;
    private i9 m_signingConfirmTimer = null;
    private boolean m_signingConfirmTimedOut = true;

    public CsiCertificate getSigningCertificate(boolean bl2, String string) {
        return this.getSigningCertificate(bl2, string, null);
    }

    public CsiCertificate getSigningCertificate(boolean bl2, String string, String string2) {
        CsiCertificate csiCertificate = this.getDefaultSigningCertificate(bl2, string2);
        if (csiCertificate != null && !this.canSuppressSigningConfirmScreen(bl2, string, csiCertificate)) {
            SignGui signGui = new SignGui(csiCertificate, string, bl2, string2);
            signGui.show();
            csiCertificate = signGui.getSigningCertificate();
            if (!signGui.doSign()) {
                csiCertificate = null;
            }
        }
        this.m_lastSignOperationSuccessful = false;
        this.m_oldSigningTermsConditions = string;
        this.m_oldSigningCertificate = csiCertificate;
        return csiCertificate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CsiCertificate getDefaultSigningCertificate(boolean bl2, String string) {
        CsiCertificate csiCertificate;
        boolean bl3;
        String string2;
        block38: {
            string2 = bl2 ? "non-repudiation" : "authentication";
            bl3 = false;
            csiCertificate = null;
            try {
                block37: {
                    try {
                        csiCertificate = bl2 ? UserPreferences.getPreferredNonRepudiationCertificate() : UserPreferences.getPreferredAuthenticationCertificate();
                        if (csiCertificate == null) {
                            bl3 = false;
                            break block37;
                        }
                        bl3 = true;
                        if (string != null && !csiCertificate.getAbn().equals(string)) {
                            throw new iv();
                        }
                        csiCertificate.checkValidity();
                        this.checkSigningCertificateForExpiryWarning(csiCertificate);
                    }
                    catch (iv iv2) {
                        ae.a("The " + string2 + " certificate has the wrong ABN for this transaction.", "CSI - Information", 1);
                        csiCertificate = null;
                        Object var8_7 = null;
                        if (csiCertificate == null) {
                            if (bl2) {
                                s.a().a((CsiCertificate)null);
                            } else {
                                s.a().c((CsiCertificate)null);
                            }
                        }
                        break block38;
                    }
                    catch (CertStoreException certStoreException) {
                        ae.a("The " + string2 + " signing certificate could not be located.", "CSI - Information", 1);
                        csiCertificate = null;
                        Object var8_8 = null;
                        if (csiCertificate == null) {
                            if (bl2) {
                                s.a().a((CsiCertificate)null);
                            } else {
                                s.a().c((CsiCertificate)null);
                            }
                        }
                        break block38;
                    }
                    catch (CertificateNotYetValidException certificateNotYetValidException) {
                        ae.a("The " + string2 + " signing certificate is not yet valid.", "CSI - Warning", 2);
                        csiCertificate = null;
                        Object var8_9 = null;
                        if (csiCertificate == null) {
                            if (bl2) {
                                s.a().a((CsiCertificate)null);
                            } else {
                                s.a().c((CsiCertificate)null);
                            }
                        }
                        break block38;
                    }
                    catch (CertificateExpiredException certificateExpiredException) {
                        ae.a("The " + string2 + " signing certificate has expired.", "CSI - Warning", 2);
                        csiCertificate = null;
                        Object var8_10 = null;
                        if (csiCertificate == null) {
                            if (bl2) {
                                s.a().a((CsiCertificate)null);
                            } else {
                                s.a().c((CsiCertificate)null);
                            }
                        }
                    }
                }
                Object var8_6 = null;
                if (csiCertificate == null) {
                    if (bl2) {
                        s.a().a((CsiCertificate)null);
                    } else {
                        s.a().c((CsiCertificate)null);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var8_11 = null;
                if (csiCertificate == null) {
                    if (bl2) {
                        s.a().a((CsiCertificate)null);
                    } else {
                        s.a().c((CsiCertificate)null);
                    }
                }
                throw throwable;
            }
        }
        if (csiCertificate == null) {
            try {
                CertificateStore.getInstance().refreshStore();
            }
            catch (CertStoreException certStoreException) {
                r.a(w.j, "Unable to refresh CertificateStore", certStoreException);
            }
            CertificateCollection certificateCollection = CertificateSelector.getAllSigningCerts(bl2, string);
            if (certificateCollection == null || certificateCollection.size() == 0) {
                String string3 = "No valid " + string2 + " certificates are available for signing.\n" + "Refer to help documentation for certificate import instructions.\n" + "The current signing operation will be cancelled.";
                ae.a(string3, "CSI - Warning", 2);
                return null;
            }
            if (certificateCollection.size() == 1) {
                csiCertificate = certificateCollection.getCertificate(0);
                this.checkSigningCertificateForExpiryWarning(csiCertificate);
            } else {
                if (!bl3) {
                    ae.a("A default certificate has not been selected for " + string2 + " signing.\n" + "Please click OK and then select a default certificate.", "CSI - Information", 1);
                }
                if ((csiCertificate = this.getUserSelectedCertificate(bl2, string)) != null) {
                    if (bl2) {
                        s.a().d(csiCertificate);
                    } else {
                        s.a().b(csiCertificate);
                    }
                }
            }
        }
        return csiCertificate;
    }

    private static CertificateCollection getAllSigningCerts(boolean bl2, String string) {
        CertificateCollection certificateCollection;
        CertificateStore certificateStore = CertificateStore.getInstance();
        try {
            certificateCollection = bl2 ? certificateStore.getAllValidNonRepudiationCertificates() : certificateStore.getAllValidAuthenticationCertificates();
        }
        catch (CertStoreException certStoreException) {
            certificateCollection = null;
            String string2 = "A problem occured while attempting to getAllCertificates() in CertificateSelector.getAllSigningCerts().";
            r.a(w.g, string2, certStoreException);
        }
        if (certificateCollection != null) {
            certificateCollection = certificateCollection.filterOnAbn(string);
        }
        return certificateCollection;
    }

    private void checkSigningCertificateForExpiryWarning(CsiCertificate csiCertificate) {
        long l10 = csiCertificate.getNotAfter().getTime();
        long l11 = System.currentTimeMillis();
        if (l11 + 1209600000L > l10) {
            int n10 = (int)((l10 - l11) / 86400000L);
            if (n10 >= 2) {
                ae.a("The signing certificate will expire in " + n10 + " days.", "CSI - Warning", 2);
            } else {
                int n11 = (int)((l10 - l11) / 3600000L);
                if (n11 >= 2) {
                    ae.a("The signing certificate will expire in " + n11 + " hours.", "CSI - Warning", 2);
                } else {
                    ae.a("The signing certificate will expire in less than 2 hours.", "CSI - Warning", 2);
                }
            }
        }
    }

    private CsiCertificate getUserSelectedCertificate(boolean bl2, String string) {
        CertSelectGui certSelectGui = new CertSelectGui(bl2, string);
        fi fi2 = certSelectGui.showDialog();
        if (fi2 != null) {
            return bl2 ? fi2.f() : fi2.e();
        }
        return null;
    }

    private boolean canSuppressSigningConfirmScreen(boolean bl2, String string, CsiCertificate csiCertificate) {
        return csiCertificate != null && !bl2 && !this.m_signingConfirmTimedOut && this.m_lastSignOperationSuccessful && this.m_oldSigningTermsConditions.equals(string) && this.m_oldSigningCertificate.equals(csiCertificate);
    }

    public void flagSigningOperationAsSuccessful() {
        this.m_lastSignOperationSuccessful = true;
        int n10 = s.a().y() * 60000;
        if (n10 == 0) {
            this.m_signingConfirmTimer = null;
            this.timeOutSigningConfirm();
        } else {
            this.m_signingConfirmTimer = new i9(n10, new jb(this));
            this.m_signingConfirmTimedOut = false;
            this.m_signingConfirmTimer.a();
        }
    }

    private void timeOutSigningConfirm() {
        if (this.m_signingConfirmTimer != null) {
            this.m_signingConfirmTimer.b();
            this.m_signingConfirmTimer = null;
        }
        this.m_signingConfirmTimedOut = true;
    }

    static /* synthetic */ void access$000(CertificateSelector certificateSelector) {
        certificateSelector.timeOutSigningConfirm();
    }
}

