/*
 * Decompiled with CFR 0.152.
 */
package au.gov.bafcsi.clapi.pkcs12.bags;

import au.gov.bafcsi.clapi.asn1.ax;
import au.gov.bafcsi.clapi.asn1.az;
import au.gov.bafcsi.clapi.asn1.cf;
import au.gov.bafcsi.clapi.asn1.coders.CoderException;
import au.gov.bafcsi.clapi.common.AlgorithmIdentifier;
import au.gov.bafcsi.clapi.common.Oid;
import au.gov.bafcsi.clapi.common.Oids;
import au.gov.bafcsi.clapi.crypto.Pkcs8EncodedPrivateKey;
import au.gov.bafcsi.clapi.crypto.symmetriccipher.cz;
import au.gov.bafcsi.clapi.pkcs12.Pkcs12Exception;
import au.gov.bafcsi.clapi.pkcs12.cx;
import au.gov.bafcsi.common.ByteArray;
import au.gov.bafcsi.common.utils.q;
import au.gov.bafcsi.common.utils.w;
import java.io.IOException;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.InvalidParameterSpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.SecretKey;
import javax.crypto.spec.PBEParameterSpec;

public class cw
extends az {
    public cw() {
        this.a((ax)new AlgorithmIdentifier(), "encryptionAlgorithm");
        this.a((ax)new cf(), "encryptedData");
    }

    public cw(Key key, String string) throws Pkcs12Exception {
        if (key == null) {
            throw new IllegalArgumentException("ShroudedKeyBag(Key,String) - Key is null.");
        }
        if (string == null) {
            throw new IllegalArgumentException("ShroudedKeyBag(Key,String) - String is null.");
        }
        SecureRandom secureRandom = new SecureRandom();
        byte[] byArray = new byte[20];
        secureRandom.nextBytes(byArray);
        PBEParameterSpec pBEParameterSpec = new PBEParameterSpec(byArray, 5);
        try {
            MessageDigest messageDigest = q.a(Oids.sha1);
            cx cx2 = new cx(string, pBEParameterSpec, messageDigest);
            SecretKey secretKey = cx2.a(Oids.pbeWithSHAAnd3_KeyTripleDES_CBC);
            AlgorithmParameters algorithmParameters = cx2.a(secretKey.getAlgorithm());
            ByteArray byteArray = new ByteArray();
            cz cz2 = q.c(secretKey.getAlgorithm());
            cz2.a(1, secretKey, algorithmParameters);
            byteArray.append(cz2.a(key.getEncoded()));
            byteArray.append(cz2.a());
            AlgorithmParameters algorithmParameters2 = q.f("PBE");
            algorithmParameters2.init(pBEParameterSpec);
            this.a((ax)new AlgorithmIdentifier((Oid)Oids.pbeWithSHAAnd3_KeyTripleDES_CBC, algorithmParameters2), "encryptionAlgorithm");
            this.a((ax)new cf(byteArray), "encryptedData");
        }
        catch (Exception exception) {
            throw new Pkcs12Exception("Unexpected Exception.", exception);
        }
    }

    public cw(AlgorithmIdentifier algorithmIdentifier, ByteArray byteArray) {
        if (algorithmIdentifier == null) {
            throw new IllegalArgumentException("ShroudedKeyBag(AlgorithmIdentifier,ByteArray) - AlgorithmIdentifier is null.");
        }
        if (byteArray == null) {
            throw new IllegalArgumentException("ShroudedKeyBag(AlgorithmIdentifier,ByteArray) - ByteArray is null.");
        }
        this.a((ax)algorithmIdentifier, "encryptionAlgorithm");
        this.a((ax)new cf(byteArray), "encryptedData");
    }

    public AlgorithmIdentifier h() {
        return (AlgorithmIdentifier)this.a("encryptionAlgorithm");
    }

    public ByteArray i() {
        return ((cf)this.a("encryptedData")).j();
    }

    public PrivateKey b(String string) throws Pkcs12Exception {
        if (string == null) {
            throw new IllegalArgumentException("ShroudedKeyBag.getPrivateKey(String) - String is null");
        }
        try {
            PBEParameterSpec pBEParameterSpec = (PBEParameterSpec)this.h().getAlgorithmParameters().getParameterSpec(PBEParameterSpec.class);
            MessageDigest messageDigest = q.a(Oids.sha1);
            cx cx2 = new cx(string, pBEParameterSpec, messageDigest);
            SecretKey secretKey = cx2.a(this.h().getAlgorithmOID());
            AlgorithmParameters algorithmParameters = cx2.a(secretKey.getAlgorithm());
            ByteArray byteArray = new ByteArray();
            cz cz2 = q.c(secretKey.getAlgorithm());
            cz2.a(2, secretKey, algorithmParameters);
            byteArray.append(cz2.a(this.i().getBytes()));
            byteArray.append(cz2.a());
            Pkcs8EncodedPrivateKey pkcs8EncodedPrivateKey = new Pkcs8EncodedPrivateKey();
            pkcs8EncodedPrivateKey.a(byteArray);
            Oid oid = pkcs8EncodedPrivateKey.getAlgorithmOid();
            KeyFactory keyFactory = q.b(Oids.getJCAMapping(oid));
            return keyFactory.generatePrivate(new PKCS8EncodedKeySpec(byteArray.getBytes()));
        }
        catch (InvalidParameterSpecException invalidParameterSpecException) {
            throw new Pkcs12Exception(w.h, "Unable to retrieve private key.", invalidParameterSpecException);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new Pkcs12Exception(w.h, "Unable to retrieve private key.", noSuchAlgorithmException);
        }
        catch (CoderException coderException) {
            throw new Pkcs12Exception(w.h, "Unable to retrieve private key.", coderException);
        }
        catch (IOException iOException) {
            throw new Pkcs12Exception(w.f, "Unable to retrieve private key.", iOException);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new Pkcs12Exception(w.h, "Unable to retrieve private key.", invalidKeyException);
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new Pkcs12Exception(w.h, "Unable to retrieve private key.", invalidAlgorithmParameterException);
        }
        catch (IllegalStateException illegalStateException) {
            throw new Pkcs12Exception(w.f, "Unable to retrieve private key.", illegalStateException);
        }
        catch (IllegalBlockSizeException illegalBlockSizeException) {
            throw new Pkcs12Exception(w.h, "Unable to retrieve private key.", illegalBlockSizeException);
        }
        catch (BadPaddingException badPaddingException) {
            throw new Pkcs12Exception(w.h, "Unable to retrieve private key.", badPaddingException);
        }
        catch (InvalidKeySpecException invalidKeySpecException) {
            throw new Pkcs12Exception(w.h, "Unable to retrieve private key.", invalidKeySpecException);
        }
    }
}

