/*
 * Decompiled with CFR 0.152.
 */
package au.gov.bafcsi.clapi.pkcs12;

import au.gov.bafcsi.clapi.asn1.a1;
import au.gov.bafcsi.clapi.asn1.a3;
import au.gov.bafcsi.clapi.asn1.aw;
import au.gov.bafcsi.clapi.asn1.ax;
import au.gov.bafcsi.clapi.asn1.az;
import au.gov.bafcsi.clapi.asn1.br;
import au.gov.bafcsi.clapi.asn1.cf;
import au.gov.bafcsi.clapi.asn1.cy;
import au.gov.bafcsi.clapi.common.Attributes;
import au.gov.bafcsi.clapi.common.Oids;
import au.gov.bafcsi.clapi.crypto.CertificateCollection;
import au.gov.bafcsi.clapi.crypto.mac.f7;
import au.gov.bafcsi.clapi.packaging.cms.full.cc;
import au.gov.bafcsi.clapi.packaging.cms.full.ch;
import au.gov.bafcsi.clapi.pkcs12.Pkcs12Exception;
import au.gov.bafcsi.clapi.pkcs12.bags.cm;
import au.gov.bafcsi.clapi.pkcs12.bags.cs;
import au.gov.bafcsi.clapi.pkcs12.bags.cw;
import au.gov.bafcsi.clapi.pkcs12.cb;
import au.gov.bafcsi.clapi.pkcs12.cd;
import au.gov.bafcsi.clapi.pkcs12.ce;
import au.gov.bafcsi.clapi.pkcs12.cg;
import au.gov.bafcsi.clapi.pkcs12.ck;
import au.gov.bafcsi.clapi.pkcs12.cl;
import au.gov.bafcsi.clapi.pkcs12.cx;
import au.gov.bafcsi.clapi.pkcs12.fx;
import au.gov.bafcsi.common.ByteArray;
import au.gov.bafcsi.common.utils.q;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.security.MessageDigest;
import java.security.SecureRandom;
import java.util.Collection;
import java.util.LinkedList;
import javax.crypto.SecretKey;
import javax.crypto.spec.PBEParameterSpec;

public class Pkcs12Exporter {
    private static final int ITERATIONS = 1024;

    public static void save(File file, String string, Collection collection) throws Pkcs12Exception {
        FileOutputStream fileOutputStream;
        if (file == null) {
            throw new IllegalArgumentException("Pkcs12Exporter.save(File,String,Collection) - Export File is null.");
        }
        try {
            fileOutputStream = new FileOutputStream(file);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new Pkcs12Exception("Could not find the file: " + file.getAbsolutePath() + " when saving the PKCS#12.", fileNotFoundException);
        }
        Pkcs12Exporter.save((OutputStream)fileOutputStream, string, collection);
    }

    public static void save(File file, String string, fx fx2) throws Pkcs12Exception {
        if (fx2 == null) {
            throw new IllegalArgumentException("Pkcs12Exporter.save(File,String,Certificate) - Certificate is null.");
        }
        LinkedList<fx> linkedList = new LinkedList<fx>();
        linkedList.add(fx2);
        Pkcs12Exporter.save(file, string, linkedList);
    }

    public static void save(OutputStream outputStream, String string, Collection collection) throws Pkcs12Exception {
        if (outputStream == null) {
            throw new IllegalArgumentException("Pkcs12Exporter.save(File,String,Collection) - Export File is null.");
        }
        if (string == null) {
            throw new IllegalArgumentException("Pkcs12Exporter.save(File,String,Collection) - Password String is null.");
        }
        if (collection == null) {
            throw new IllegalArgumentException("Pkcs12Exporter.save(File,String,Collection) - Collection is null.");
        }
        if (collection.isEmpty()) {
            throw new IllegalArgumentException("Pkcs12Exporter.save(File,String,Collection) - Collection is empty.");
        }
        Pkcs12Exporter.process(outputStream, string, collection);
    }

    public static void save(OutputStream outputStream, String string, fx fx2) throws Pkcs12Exception {
        if (fx2 == null) {
            throw new IllegalArgumentException("Pkcs12Exporter.save(File,String,Certificate) - Certificate is null.");
        }
        LinkedList<fx> linkedList = new LinkedList<fx>();
        linkedList.add(fx2);
        Pkcs12Exporter.save(outputStream, string, linkedList);
    }

    private static void process(OutputStream outputStream, String string, Collection collection) throws Pkcs12Exception {
        try {
            Object object;
            a1 a12;
            az az2;
            az az3;
            az az4;
            Object object2;
            Object object3;
            Object object4;
            Object object5;
            Object object6;
            Object[] objectArray;
            Object object7;
            cg cg2 = new cg();
            MessageDigest messageDigest = q.a(Oids.sha1);
            int n10 = 0;
            Object object8 = collection.iterator();
            while (object8.hasNext()) {
                object7 = (fx)object8.next();
                objectArray = ((fx)object7).b();
                object6 = new Attributes();
                ((Attributes)object6).addAttribute(Oids.friendlyName, new cy("Certificate #" + n10++));
                object5 = new ByteArray(messageDigest.digest(objectArray[0].getEncoded()));
                ((Attributes)object6).addAttribute(Oids.localKeyID, new cf((ByteArray)object5));
                messageDigest.reset();
                object4 = new cm(objectArray[0].getX509Certificate(), Oids.x509Certificate);
                object3 = new cl(Oids.certBag, (aw)object4, (Attributes)object6);
                object2 = new ck();
                ((br)object2).a((ax)object3);
                az4 = new cc(Oids.data, new ch(((a3)object2).g()));
                cg2.a(az4);
                az3 = new cw(((fx)object7).b, string);
                az2 = new cl(Oids.shroudedKeyBag, az3, (Attributes)object6);
                a12 = new ck();
                ((br)a12).a(az2);
                object = new cc(Oids.data, new ch(a12.g()));
                cg2.a((ax)object);
                if (objectArray.length <= 1) continue;
                CertificateCollection certificateCollection = new CertificateCollection();
                for (int i10 = 1; i10 < objectArray.length; ++i10) {
                    certificateCollection.addCertificate(objectArray[i10]);
                }
                cs cs2 = new cs(certificateCollection);
                cl cl2 = new cl(Oids.secretBag, cs2, null);
                ck ck2 = new ck();
                ck2.a(cl2);
                cc cc2 = new cc(Oids.data, new ch(ck2.g()));
                cg2.a(cc2);
            }
            object8 = cg2.g();
            messageDigest.reset();
            object7 = new SecureRandom();
            objectArray = new byte[16];
            ((SecureRandom)object7).nextBytes((byte[])objectArray);
            object6 = new PBEParameterSpec((byte[])objectArray, 1024);
            object5 = new cx(string, (PBEParameterSpec)object6, messageDigest);
            object4 = ((cx)object5).a(20, messageDigest.getAlgorithm());
            object3 = q.e("HMACwith" + messageDigest.getAlgorithm());
            ((f7)object3).a((SecretKey)object4);
            ((f7)object3).a(((ByteArray)object8).getBytes());
            object2 = new ByteArray(((f7)object3).a());
            az4 = new ce(Oids.sha1, (ByteArray)object2);
            az3 = new cd((ce)az4, new ByteArray((byte[])objectArray), 1024);
            az2 = new cc(Oids.data, new ch((ByteArray)object8));
            a12 = new cb((cc)az2, (cd)az3);
            object = a12.encode(outputStream);
            ((OutputStream)object).flush();
            ((OutputStream)object).close();
        }
        catch (Exception exception) {
            throw new Pkcs12Exception("Unexpected Exception exporting PKCS#12 file: " + exception.getMessage(), exception);
        }
    }
}

