/*
 * Decompiled with CFR 0.152.
 */
package au.gov.bafcsi.clapi.packaging.xml.signature.keyinfo;

import au.gov.bafcsi.clapi.certs.CsiX509Certificate;
import au.gov.bafcsi.clapi.crypto.CertificateCollection;
import au.gov.bafcsi.clapi.crypto.CsiCertificate;
import au.gov.bafcsi.clapi.packaging.xml.XMLElement;
import au.gov.bafcsi.clapi.packaging.xml.XMLException;
import au.gov.bafcsi.clapi.packaging.xml.XMLUtils;
import au.gov.bafcsi.clapi.packaging.xml.signature.XMLSignatureException;
import au.gov.bafcsi.common.ByteArray;
import java.io.ByteArrayInputStream;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class hx
extends XMLElement {
    public hx(Document document, X509Certificate x509Certificate) throws XMLSignatureException {
        super(document, "X509Data", "http://www.w3.org/2000/09/xmldsig#");
        if (x509Certificate == null) {
            throw new IllegalArgumentException("X509Data(Document, X509Certificate) - The supplied X509Certificate is null.");
        }
        this.addReturn("        ");
        try {
            this.addChild(XMLUtils.toBase64Binary(document, "X509Certificate", "http://www.w3.org/2000/09/xmldsig#", new ByteArray(x509Certificate.getEncoded())));
        }
        catch (XMLException xMLException) {
            throw new XMLSignatureException("X509Data(Document, X509Certificate)", xMLException);
        }
        catch (CertificateEncodingException certificateEncodingException) {
            throw new XMLSignatureException("X509Data(Document, X509Certificate)", certificateEncodingException);
        }
    }

    private hx(Element element) {
        super(element);
    }

    public CertificateCollection a() throws XMLSignatureException {
        int n10 = this.numberOfChildren("X509Certificate", "http://www.w3.org/2000/09/xmldsig#");
        if (n10 == 0) {
            return null;
        }
        CertificateCollection certificateCollection = new CertificateCollection();
        for (int i10 = 0; i10 < n10; ++i10) {
            Element element = this.findChild("X509Certificate", "http://www.w3.org/2000/09/xmldsig#", i10);
            if (element == null) {
                return null;
            }
            try {
                ByteArray byteArray = XMLUtils.fromBase64Binary(element);
                CsiX509Certificate csiX509Certificate = new CsiX509Certificate(new ByteArrayInputStream(byteArray.getBytes()));
                certificateCollection.addCertificate(new CsiCertificate(csiX509Certificate));
                continue;
            }
            catch (XMLException xMLException) {
                throw new XMLSignatureException("X509Data.getCertificates()", xMLException);
            }
            catch (CertificateException certificateException) {
                throw new XMLSignatureException("X509Data.getCertificates()", certificateException);
            }
        }
        return certificateCollection;
    }

    public static hx a(Element element) {
        if (element == null) {
            throw new IllegalArgumentException("X509Data.getInstance(Element) - The supplied Element is null.");
        }
        if (!element.getNamespaceURI().equals("http://www.w3.org/2000/09/xmldsig#")) {
            throw new IllegalArgumentException("X509Data.getInstance(Element) - The supplied Element is not in the namespace 'http://www.w3.org/2000/09/xmldsig#'.");
        }
        if (!element.getLocalName().equals("X509Data")) {
            throw new IllegalArgumentException("X509Data.getInstance(Element) - The supplied Element is not an X509Data.");
        }
        return new hx(element);
    }
}

