/*
 * Decompiled with CFR 0.152.
 */
package au.gov.bafcsi.clapi.packaging.xml.signature;

import au.gov.bafcsi.clapi.common.Oids;
import au.gov.bafcsi.clapi.common.SignatureOid;
import au.gov.bafcsi.clapi.common.UnsupportedAlgorithmException;
import au.gov.bafcsi.clapi.crypto.CertificateStore;
import au.gov.bafcsi.clapi.crypto.CsiCertificate;
import au.gov.bafcsi.clapi.crypto.CsiPrivateKey;
import au.gov.bafcsi.clapi.crypto.UserCancelledSignatureException;
import au.gov.bafcsi.clapi.packaging.xml.XMLElement;
import au.gov.bafcsi.clapi.packaging.xml.XMLException;
import au.gov.bafcsi.clapi.packaging.xml.XMLSerializer;
import au.gov.bafcsi.clapi.packaging.xml.XMLUtils;
import au.gov.bafcsi.clapi.packaging.xml.h8;
import au.gov.bafcsi.clapi.packaging.xml.hp;
import au.gov.bafcsi.clapi.packaging.xml.resource.IDResolver;
import au.gov.bafcsi.clapi.packaging.xml.resource.h7;
import au.gov.bafcsi.clapi.packaging.xml.resource.ig;
import au.gov.bafcsi.clapi.packaging.xml.signature.Validity;
import au.gov.bafcsi.clapi.packaging.xml.signature.XMLSignatureException;
import au.gov.bafcsi.clapi.packaging.xml.signature.c14n.he;
import au.gov.bafcsi.clapi.packaging.xml.signature.fv;
import au.gov.bafcsi.clapi.packaging.xml.signature.fw;
import au.gov.bafcsi.clapi.packaging.xml.signature.h6;
import au.gov.bafcsi.clapi.packaging.xml.signature.hg;
import au.gov.bafcsi.clapi.packaging.xml.signature.ho;
import au.gov.bafcsi.clapi.packaging.xml.signature.hq;
import au.gov.bafcsi.clapi.packaging.xml.signature.hy;
import au.gov.bafcsi.clapi.packaging.xml.signature.io;
import au.gov.bafcsi.clapi.packaging.xml.signature.keyinfo.hs;
import au.gov.bafcsi.clapi.packaging.xml.signature.keyinfo.ht;
import au.gov.bafcsi.clapi.packaging.xml.signature.keyinfo.hx;
import au.gov.bafcsi.clapi.packaging.xml.signature.properties.CSIAttributes;
import au.gov.bafcsi.clapi.packaging.xml.signature.properties.SigningTime;
import au.gov.bafcsi.clapi.packaging.xml.signature.properties.h4;
import au.gov.bafcsi.clapi.packaging.xml.signature.properties.h5;
import au.gov.bafcsi.clapi.packaging.xml.signature.transforms.hh;
import au.gov.bafcsi.clapi.packaging.xml.signature.transforms.hi;
import au.gov.bafcsi.common.ByteArray;
import au.gov.bafcsi.common.MimeType;
import au.gov.bafcsi.common.utils.base64.Base64;
import au.gov.bafcsi.common.utils.s;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.Key;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.interfaces.DSAPublicKey;
import java.security.interfaces.RSAPublicKey;
import java.util.Date;
import javax.crypto.SecretKey;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class XMLSignature
extends XMLElement {
    private fw signedInfo;

    public XMLSignature(Document document, fw fw2, hs hs2, hy[] hyArray, String string) {
        super(document, "Signature", "http://www.w3.org/2000/09/xmldsig#");
        if (fw2 == null) {
            throw new IllegalArgumentException("XMLSignature(SignedInfo, KeyInfo) - The supplied SignedInfo is null.");
        }
        if (hs2 == null) {
            throw new IllegalArgumentException("XMLSignature(SignedInfo, KeyInfo) - The supplied KeyInfo is null.");
        }
        this.signedInfo = fw2;
        this.addReturn("  ");
        this.addChild(fw2);
        this.addReturn("  ");
        this.addChild(new h6(document));
        this.addReturn("  ");
        this.addChild(hs2);
        if (hyArray != null) {
            int n10 = hyArray.length;
            for (int i10 = 0; i10 < n10; ++i10) {
                this.addReturn("  ");
                this.addChild(hyArray[i10]);
            }
        }
        this.addReturn(null);
        if (string != null) {
            this.setAttribute("Id", string);
        }
    }

    private XMLSignature(Element element) {
        super(element);
    }

    public fw getSignedInfo() throws XMLSignatureException {
        if (this.signedInfo != null) {
            return this.signedInfo;
        }
        try {
            return fw.a(this.findChild("SignedInfo", "http://www.w3.org/2000/09/xmldsig#"));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new XMLSignatureException("XMLSignature.getSignedInfo()", illegalArgumentException);
        }
    }

    public h6 getSignatureValue() throws XMLSignatureException {
        try {
            return h6.a(this.findChild("SignatureValue", "http://www.w3.org/2000/09/xmldsig#"));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new XMLSignatureException("XMLSignature.getSignatureValue()", illegalArgumentException);
        }
    }

    public hs getKeyInfo() throws XMLSignatureException {
        try {
            return hs.a(this.findChild("KeyInfo", "http://www.w3.org/2000/09/xmldsig#"));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new XMLSignatureException("XMLSignature.getKeyInfo()", illegalArgumentException);
        }
    }

    public PublicKey getPublicKey() throws XMLSignatureException {
        return this.getKeyInfo().c();
    }

    public CSIAttributes getCSIAttributes() throws XMLSignatureException {
        Element element;
        try {
            element = XMLUtils.findElement(XMLUtils.getOwnerDocument(this.getElement()), "//csi:CSIAttributes");
        }
        catch (XMLException xMLException) {
            throw new XMLSignatureException("XMLSignature.getCSIAttributes() - " + xMLException.toString());
        }
        return element != null ? CSIAttributes.getInstance(element) : null;
    }

    public SigningTime getSigningTime() throws XMLSignatureException {
        Element element;
        try {
            element = XMLUtils.findElement(XMLUtils.getOwnerDocument(this.getElement()), "//csi:SigningTime");
        }
        catch (XMLException xMLException) {
            throw new XMLSignatureException("XMLSignature.getSigningTime(Element) - " + xMLException.toString());
        }
        return element != null ? SigningTime.getInstance(element) : null;
    }

    public InputStream getTransformedReferenceStream(int n10) throws XMLSignatureException {
        try {
            hq hq2 = this.getSignedInfo().a(n10);
            if (hq2 == null) {
                throw new XMLSignatureException("XMLSignature.getReferenceStream(int) - The XMLSignature does not contain a Reference[" + n10 + "] !");
            }
            hp hp2 = hq2.b();
            h7 h72 = hp2.a(XMLUtils.getOwnerDocument(this.getElement()), null);
            hh hh2 = hq2.d();
            h72 = hh2.a(h72, null);
            return h72.b();
        }
        catch (h8 h82) {
            throw new XMLSignatureException("XMLSignature.getReferenceStream(int)", h82);
        }
        catch (ig ig2) {
            throw new XMLSignatureException("XMLSignature.getReferenceStream(int)", ig2);
        }
    }

    public void sign(Key key, IDResolver iDResolver, boolean bl2) throws XMLSignatureException, UserCancelledSignatureException {
        this.sign(key, iDResolver, bl2, MimeType.PLAIN_TEXT);
    }

    public void sign(Key key, IDResolver iDResolver, boolean bl2, MimeType mimeType) throws XMLSignatureException, UserCancelledSignatureException {
        if (key == null) {
            throw new IllegalArgumentException("XMLSignature.sign(Key, IDResolver) - The supplied Key is null.");
        }
        if (!(key instanceof PrivateKey) && !(key instanceof SecretKey)) {
            throw new IllegalArgumentException("XMLSignature.sign(Key, IDResolver) - The supplied Key must be an instanceof PrivateKey or SecretKey.");
        }
        fw fw2 = this.getSignedInfo();
        fw2.a(iDResolver);
        hg hg2 = fw2.b();
        ByteArray byteArray = fw2.d();
        fv fv2 = null;
        if (bl2) {
            fv2 = new fv(mimeType, fw2);
        }
        ByteArray byteArray2 = hg2.a(key, byteArray, fv2);
        this.getSignatureValue().a(byteArray2);
    }

    public Validity verify(Key key, IDResolver iDResolver) throws XMLSignatureException {
        if (key == null) {
            throw new IllegalArgumentException("XMLSignature.verify(Key) - The supplied Key is null.");
        }
        if (!(key instanceof PublicKey) && !(key instanceof SecretKey)) {
            throw new IllegalArgumentException("XMLSignature.verify(Key) - The supplied Key must be an instanceof PublicKey or SecretKey.");
        }
        Validity validity = new Validity();
        fw fw2 = fw.a(this.findChild("SignedInfo", "http://www.w3.org/2000/09/xmldsig#"));
        fw2.a(validity, iDResolver);
        hg hg2 = fw2.b();
        ByteArray byteArray = fw2.d();
        ByteArray byteArray2 = this.getSignatureValue().a();
        io io2 = hg2.a(key, byteArray, byteArray2);
        validity.setSignatureValidity(io2);
        return validity;
    }

    public Validity verify(IDResolver iDResolver) throws XMLSignatureException {
        return this.verify(this.getPublicKey(), iDResolver);
    }

    public static XMLSignature getInstance(InputStream inputStream) throws XMLSignatureException {
        if (inputStream == null) {
            throw new IllegalArgumentException("XMLSignature(InputStream) - The supplied InputStream is null.");
        }
        try {
            Document document = XMLUtils.getDocument(inputStream, false, true);
            return XMLSignature.getInstance(document);
        }
        catch (XMLException xMLException) {
            throw new XMLSignatureException("XMLSignature.getInstance(InputStream)", xMLException);
        }
    }

    public static XMLSignature getInstance(Document document) throws XMLSignatureException {
        Element element;
        if (document == null) {
            throw new IllegalArgumentException("XMLSignature.getInstance(Element) - The supplied Element is null.");
        }
        try {
            element = XMLUtils.findElement(document, "//dsig:Signature");
        }
        catch (XMLException xMLException) {
            throw new XMLSignatureException("XMLSignature.getInstance(Document) - " + xMLException.toString());
        }
        if (element != null) {
            return new XMLSignature(element);
        }
        throw new XMLSignatureException("XMLSignature.getInstance(Document) - //dsig:Signature Element does not exist in the supplied Document.");
    }

    public static XMLSignature buildDetached(Document document, CsiCertificate csiCertificate, String[] stringArray, boolean bl2, boolean bl3, String string) throws XMLSignatureException, UserCancelledSignatureException {
        IDResolver iDResolver;
        h4[] h4Array;
        XMLElement xMLElement;
        String string2;
        Document document2;
        if (document == null) {
            throw new IllegalArgumentException("XMLSignature.buildDetached(Document, CsiCertificate, String[], boolean, String) - The supplied Document is null.");
        }
        if (csiCertificate == null) {
            throw new IllegalArgumentException("XMLSignature.buildDetached(Document, CsiCertificate, String[], boolean, String) - The supplied CsiCertificate is null.");
        }
        if (stringArray == null) {
            throw new IllegalArgumentException("XMLSignature.buildDetached(Document, CsiCertificate, String[], boolean, String) - The supplied String[] is null.");
        }
        if (bl2 && !csiCertificate.canDoNonRepudiationSigning()) {
            throw new XMLSignatureException("XMLSignature.buildEnveloped(ByteArray[], CsiCertificate, boolean, String) - The supplied CsiCertificate cannot sign for non repudiation.");
        }
        if (!bl2 && !csiCertificate.canDoAuthenticationSigning()) {
            throw new XMLSignatureException("XMLSignature.buildEnveloped(ByteArray[], CsiCertificate, boolean, String) - The supplied CsiCertificate cannot sign for authentication.");
        }
        try {
            document2 = XMLUtils.getDocument(false, true);
        }
        catch (XMLException xMLException) {
            throw new XMLSignatureException("XMLSignature.buildDetached(Document, CsiCertificate, String[], boolean, String)", xMLException);
        }
        he he2 = he.a(document2, "http://www.w3.org/TR/2001/REC-xml-c14n-20010315#WithComments");
        PublicKey publicKey = csiCertificate.getPublicKey();
        hg hg2 = XMLSignature.getSignatureAlgorithm(csiCertificate, document2, publicKey);
        try {
            string2 = XMLSignature.getDigestMethod(csiCertificate);
        }
        catch (UnsupportedAlgorithmException unsupportedAlgorithmException) {
            throw new XMLSignatureException(unsupportedAlgorithmException.getMessage());
        }
        hq[] hqArray = new hq[stringArray.length + 1 + (bl3 ? 1 : 0)];
        for (int i10 = 0; i10 < stringArray.length; ++i10) {
            xMLElement = new hh(document2);
            ((hh)xMLElement).a(hi.a(document2, "http://www.w3.org/TR/2001/REC-xml-c14n-20010315", null));
            hqArray[i10] = new hq(document2, (hh)xMLElement, new ho(document2, string2), null, new hp(stringArray[i10]), null, bl2);
        }
        hqArray[stringArray.length] = new hq(document2, null, new ho(document2, string2), null, new hp("#signedCSIAttributes"), null, false);
        if (bl3) {
            hqArray[stringArray.length + 1] = new hq(document2, null, new ho(document2, string2), null, new hp("#signedSigningTime"), null, false);
        }
        fw fw2 = new fw(document2, he2, hg2, hqArray);
        xMLElement = new hs(document2);
        ((hs)xMLElement).a(new ht(document2, publicKey));
        ((hs)xMLElement).a(new hx(document2, csiCertificate));
        s s2 = s.a();
        CSIAttributes cSIAttributes = CSIAttributes.buildInstance(document2, bl2, s2.c(), s2.an(), csiCertificate.getStoreType().toString(), MimeType.PLAIN_TEXT.toString());
        h4 h42 = new h4(document2, cSIAttributes.getElement(), "signedCSIAttributes", string);
        h4 h43 = new h4(document2, SigningTime.buildInstance(document2, new Date()).getElement(), "signedSigningTime", string);
        if (bl3) {
            h4[] h4Array2 = new h4[2];
            h4Array2[0] = h42;
            h4Array = h4Array2;
            h4Array2[1] = h43;
        } else {
            h4[] h4Array3 = new h4[1];
            h4Array = h4Array3;
            h4Array3[0] = h42;
        }
        h5 h52 = new h5(document2, h4Array);
        hy hy2 = new hy(document2, h52.getElement(), "signatureProperties");
        XMLSignature xMLSignature = new XMLSignature(document2, fw2, (hs)xMLElement, new hy[]{hy2}, string);
        CertificateStore certificateStore = CertificateStore.getInstance();
        CsiPrivateKey csiPrivateKey = certificateStore.getPrivateKey(csiCertificate);
        document2.appendChild(xMLSignature.getElement());
        try {
            iDResolver = new IDResolver(document2);
            iDResolver.addDocument(document);
        }
        catch (ig ig2) {
            throw new XMLSignatureException("XMLSignature.buildDetached(Document, CsiCertificate, String[], boolean, String)", ig2);
        }
        xMLSignature.sign(csiPrivateKey, iDResolver, bl2);
        return xMLSignature;
    }

    public static void buildEmbedded(Element element, CsiCertificate csiCertificate, String[] stringArray, boolean bl2, boolean bl3, String string) throws XMLSignatureException, UserCancelledSignatureException {
        h4[] h4Array;
        XMLElement xMLElement;
        String string2;
        if (element == null) {
            throw new IllegalArgumentException("XMLSignature.buildEmbedded(Element, CsiCertificate, String[], boolean, String) - The supplied Node is null.");
        }
        if (csiCertificate == null) {
            throw new IllegalArgumentException("XMLSignature.buildEmbedded(Element, CsiCertificate, String[], boolean, String) - The supplied CsiCertificate is null.");
        }
        if (stringArray == null) {
            throw new IllegalArgumentException("XMLSignature.buildEmbedded(Element, CsiCertificate, String[], boolean, String) - The supplied String[] is null.");
        }
        if (bl2 && !csiCertificate.canDoNonRepudiationSigning()) {
            throw new XMLSignatureException("XMLSignature.buildEnveloped(ByteArray[], CsiCertificate, boolean, String) - The supplied CsiCertificate cannot sign for non repudiation.");
        }
        if (!bl2 && !csiCertificate.canDoAuthenticationSigning()) {
            throw new XMLSignatureException("XMLSignature.buildEnveloped(ByteArray[], CsiCertificate, boolean, String) - The supplied CsiCertificate cannot sign for authentication.");
        }
        Document document = XMLUtils.getOwnerDocument(element);
        he he2 = he.a(document, "http://www.w3.org/TR/2001/REC-xml-c14n-20010315#WithComments");
        PublicKey publicKey = csiCertificate.getPublicKey();
        hg hg2 = XMLSignature.getSignatureAlgorithm(csiCertificate, document, publicKey);
        try {
            string2 = XMLSignature.getDigestMethod(csiCertificate);
        }
        catch (UnsupportedAlgorithmException unsupportedAlgorithmException) {
            throw new XMLSignatureException(unsupportedAlgorithmException.getMessage());
        }
        hq[] hqArray = new hq[stringArray.length + 1 + (bl3 ? 1 : 0)];
        for (int i10 = 0; i10 < stringArray.length; ++i10) {
            xMLElement = new hh(document);
            ((hh)xMLElement).a(hi.a(document, "http://www.w3.org/TR/2001/REC-xml-c14n-20010315", null));
            hqArray[i10] = new hq(document, (hh)xMLElement, new ho(document, string2), null, new hp(stringArray[i10]), null, bl2);
        }
        hqArray[stringArray.length] = new hq(document, null, new ho(document, string2), null, new hp("#signedCSIAttributes"), null, false);
        if (bl3) {
            hqArray[stringArray.length + 1] = new hq(document, null, new ho(document, string2), null, new hp("#signedSigningTime"), null, false);
        }
        fw fw2 = new fw(document, he2, hg2, hqArray);
        xMLElement = new hs(document);
        ((hs)xMLElement).a(new ht(document, publicKey));
        ((hs)xMLElement).a(new hx(document, csiCertificate));
        s s2 = s.a();
        CSIAttributes cSIAttributes = CSIAttributes.buildInstance(document, bl2, s2.c(), s2.an(), csiCertificate.getStoreType().toString(), MimeType.PLAIN_TEXT.toString());
        h4 h42 = new h4(document, cSIAttributes.getElement(), "signedCSIAttributes", string);
        h4 h43 = new h4(document, SigningTime.buildInstance(document, new Date()).getElement(), "signedSigningTime", string);
        if (bl3) {
            h4[] h4Array2 = new h4[2];
            h4Array2[0] = h42;
            h4Array = h4Array2;
            h4Array2[1] = h43;
        } else {
            h4[] h4Array3 = new h4[1];
            h4Array = h4Array3;
            h4Array3[0] = h42;
        }
        h5 h52 = new h5(document, h4Array);
        hy hy2 = new hy(document, h52.getElement(), "signatureProperties");
        XMLSignature xMLSignature = new XMLSignature(document, fw2, (hs)xMLElement, new hy[]{hy2}, string);
        CertificateStore certificateStore = CertificateStore.getInstance();
        CsiPrivateKey csiPrivateKey = certificateStore.getPrivateKey(csiCertificate);
        element.appendChild(xMLSignature.getElement());
        xMLSignature.sign(csiPrivateKey, null, bl2);
    }

    public static XMLSignature buildEnveloped(ByteArray byteArray, CsiCertificate csiCertificate, boolean bl2, String string) throws XMLSignatureException, UserCancelledSignatureException {
        return XMLSignature.buildEnveloped(new ByteArray[]{byteArray}, csiCertificate, bl2, string, MimeType.PLAIN_TEXT);
    }

    public static XMLSignature buildEnveloped(ByteArray byteArray, CsiCertificate csiCertificate, boolean bl2, String string, MimeType mimeType) throws XMLSignatureException, UserCancelledSignatureException {
        return XMLSignature.buildEnveloped(new ByteArray[]{byteArray}, csiCertificate, bl2, string, mimeType);
    }

    public static XMLSignature buildEnveloped(ByteArray[] byteArrayArray, CsiCertificate csiCertificate, boolean bl2, String string) throws XMLSignatureException, UserCancelledSignatureException {
        return XMLSignature.buildEnveloped(byteArrayArray, csiCertificate, bl2, string, MimeType.PLAIN_TEXT);
    }

    public static XMLSignature buildEnveloped(ByteArray[] byteArrayArray, CsiCertificate csiCertificate, boolean bl2, String string, MimeType mimeType) throws XMLSignatureException, UserCancelledSignatureException {
        Object object;
        Object object2;
        XMLElement xMLElement;
        String string2;
        Document document;
        if (byteArrayArray == null || byteArrayArray.length == 0) {
            throw new IllegalArgumentException("XMLSignature.buildEnveloped(ByteArray[], CsiCertificate, boolean, String) - The supplied ByteArray[] is either null or of length 0.");
        }
        if (csiCertificate == null) {
            throw new IllegalArgumentException("XMLSignature.buildEnveloped(ByteArray[], CsiCertificate, boolean, String) - The supplied CsiCertificate is null.");
        }
        if (bl2 && !csiCertificate.canDoNonRepudiationSigning()) {
            throw new XMLSignatureException("XMLSignature.buildEnveloped(ByteArray[], CsiCertificate, boolean, String) - The supplied CsiCertificate cannot sign for non repudiation.");
        }
        if (!bl2 && !csiCertificate.canDoAuthenticationSigning()) {
            throw new XMLSignatureException("XMLSignature.buildEnveloped(ByteArray[], CsiCertificate, boolean, String) - The supplied CsiCertificate cannot sign for authentication.");
        }
        if (bl2 && csiCertificate.isIdentrusCertificate()) {
            throw new XMLSignatureException("XMLSignature.buildEnveloped(ByteArray[], CsiCertificate, boolean, String) - You cannot sign for non repudiation with an Identrus certificate.");
        }
        try {
            document = XMLUtils.getDocument(false, true);
        }
        catch (XMLException xMLException) {
            throw new XMLSignatureException("XMLSignature.buildEnveloped(ByteArray[], CsiCertificate, boolean, String)", xMLException);
        }
        he he2 = he.a(document, "http://www.w3.org/TR/2001/REC-xml-c14n-20010315#WithComments");
        PublicKey publicKey = csiCertificate.getPublicKey();
        hg hg2 = XMLSignature.getSignatureAlgorithm(csiCertificate, document, publicKey);
        try {
            string2 = XMLSignature.getDigestMethod(csiCertificate);
        }
        catch (UnsupportedAlgorithmException unsupportedAlgorithmException) {
            throw new XMLSignatureException(unsupportedAlgorithmException.getMessage());
        }
        hq[] hqArray = new hq[byteArrayArray.length + 2];
        int n10 = byteArrayArray.length;
        for (int i10 = 0; i10 < n10; ++i10) {
            xMLElement = new hh(document);
            ((hh)xMLElement).a(hi.a(document, "http://www.w3.org/2000/09/xmldsig#base64", null));
            hqArray[i10] = new hq(document, (hh)xMLElement, new ho(document, string2), null, new hp("#data" + i10), null, bl2);
        }
        hqArray[n10] = new hq(document, null, new ho(document, string2), null, new hp("#signedCSIAttributes"), null, false);
        hqArray[n10 + 1] = new hq(document, null, new ho(document, string2), null, new hp("#signedSigningTime"), null, false);
        fw fw2 = new fw(document, he2, hg2, hqArray);
        xMLElement = new hs(document);
        ((hs)xMLElement).a(new ht(document, publicKey));
        ((hs)xMLElement).a(new hx(document, csiCertificate));
        hy[] hyArray = new hy[n10 + 1];
        for (int i11 = 0; i11 < n10; ++i11) {
            try {
                object2 = Base64.encode(byteArrayArray[i11]);
            }
            catch (IOException iOException) {
                throw new XMLSignatureException("XMLSignature.buildEnveloped(ByteArray[], CsiCertificate, boolean, String)", iOException);
            }
            object = document.createTextNode(((ByteArray)object2).toString());
            hyArray[i11] = new hy(document, (Node)object, "data" + i11);
        }
        s s2 = s.a();
        object2 = CSIAttributes.buildInstance(document, bl2, s2.c(), s2.an(), csiCertificate.getStoreType().toString(), MimeType.PLAIN_TEXT.toString());
        object = new h4(document, ((XMLElement)object2).getElement(), "signedCSIAttributes", string);
        SigningTime signingTime = SigningTime.buildInstance(document, new Date());
        h4 h42 = new h4(document, signingTime.getElement(), "signedSigningTime", string);
        h5 h52 = new h5(document, new h4[]{object, h42});
        hyArray[n10] = new hy(document, h52.getElement(), "signatureProperties");
        XMLSignature xMLSignature = new XMLSignature(document, fw2, (hs)xMLElement, hyArray, string);
        document.appendChild(xMLSignature.getElement());
        CertificateStore certificateStore = CertificateStore.getInstance();
        CsiPrivateKey csiPrivateKey = certificateStore.getPrivateKey(csiCertificate);
        xMLSignature.sign(csiPrivateKey, null, bl2, mimeType);
        return xMLSignature;
    }

    public String toString() {
        Document document = XMLUtils.getOwnerDocument(this.getElement());
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            XMLSerializer.serialize(document, byteArrayOutputStream);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception.toString());
        }
        return new String(byteArrayOutputStream.toByteArray());
    }

    private static String getDigestMethod(CsiCertificate csiCertificate) throws UnsupportedAlgorithmException {
        return XMLUtils.getDigestMethod(SignatureOid.getDigestOid(csiCertificate.getSigAlgOID()));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static hg getSignatureAlgorithm(CsiCertificate csiCertificate, Document document, PublicKey publicKey) throws XMLSignatureException {
        hg hg2 = null;
        String string = csiCertificate.getX509Certificate().getSigAlgOID();
        if (publicKey instanceof RSAPublicKey) {
            if (string.equalsIgnoreCase(Oids.sha1WithRSASignature.toString())) {
                return new hg(document, "http://www.w3.org/2000/09/xmldsig#rsa-sha1");
            }
            if (string.equalsIgnoreCase(Oids.sha256WithRSAEncryption.toString())) {
                return new hg(document, "http://www.w3.org/2001/04/xmldsig-more#rsa-sha256");
            }
            if (string.equalsIgnoreCase(Oids.sha384WithRSAEncryption.toString())) {
                return new hg(document, "http://www.w3.org/2001/04/xmldsig-more#rsa-sha384");
            }
            if (!string.equalsIgnoreCase(Oids.sha512WithRSAEncryption.toString())) throw new XMLSignatureException("XMLSignature.buildEnveloped(ByteArray[], CsiCertificate, boolean, String) - The supplied CsiCertificate's PublicKey is not an RSAPublicKey nor is it a DSAPublicKey, only these Key types are supported.");
            return new hg(document, "http://www.w3.org/2001/04/xmldsig-more#rsa-sha512");
        }
        if (!(publicKey instanceof DSAPublicKey)) throw new XMLSignatureException("XMLSignature.buildEnveloped(ByteArray[], CsiCertificate, boolean, String) - The supplied CsiCertificate's PublicKey is not an RSAPublicKey nor is it a DSAPublicKey, only these Key types are supported.");
        return new hg(document, "http://www.w3.org/2000/09/xmldsig#dsa-sha1");
    }
}

