/*
 * Decompiled with CFR 0.152.
 */
package au.gov.bafcsi.clapi.packaging.cms;

import au.gov.bafcsi.clapi.asn1.coders.CoderException;
import au.gov.bafcsi.clapi.common.AlgorithmIdentifier;
import au.gov.bafcsi.clapi.common.Attributes;
import au.gov.bafcsi.clapi.common.Oids;
import au.gov.bafcsi.clapi.common.Pkcs7DataOid;
import au.gov.bafcsi.clapi.packaging.cms.full.cc;
import au.gov.bafcsi.clapi.packaging.cms.full.ga;
import au.gov.bafcsi.clapi.packaging.da;
import au.gov.bafcsi.clapi.packaging.exceptions.BadMessageFormatException;
import au.gov.bafcsi.clapi.packaging.exceptions.PackagingException;
import java.io.IOException;
import java.io.InputStream;
import javax.crypto.SecretKey;

public class EncryptedCmsInputStream
extends InputStream
implements da {
    private InputStream in = null;
    private cc contentInfo = null;
    private InputStream contentStream = null;
    private ga encryptedData = null;
    private boolean cancelled = false;

    public EncryptedCmsInputStream(InputStream inputStream, SecretKey secretKey) throws IOException {
        if (inputStream == null) {
            throw new IllegalArgumentException("EncryptedCmsInputStream(InputStream,SecretKey) : InputStream is null.");
        }
        if (secretKey == null) {
            throw new IllegalArgumentException("EncryptedCmsInputStream(InputStream,SecretKey) : SecretKey is null.");
        }
        this.in = inputStream;
        this.contentInfo = new cc();
        try {
            this.contentInfo.decode(this.in);
        }
        catch (CoderException coderException) {
            throw new BadMessageFormatException("Cannot decode contentInfo.", coderException);
        }
        if (!this.contentInfo.j().equals(Oids.encryptedData)) {
            throw new PackagingException("ContentInfo does not contain an EncryptedData object.");
        }
        this.encryptedData = (ga)this.contentInfo.k();
        this.encryptedData.a(secretKey, null);
        this.contentStream = this.encryptedData.m();
    }

    public int read() throws IOException {
        return this.contentStream.read();
    }

    public int read(byte[] byArray, int n10, int n11) throws IOException {
        return this.contentStream.read(byArray, n10, n11);
    }

    public void close() throws IOException {
        if (!this.cancelled) {
            this.contentInfo.i();
            try {
                this.encryptedData.decodeFully();
            }
            catch (CoderException coderException) {
                throw new PackagingException("Cannot decode the stream.", coderException);
            }
        }
        this.contentStream = null;
        this.in.close();
    }

    public Pkcs7DataOid getContentType() {
        return this.encryptedData.i();
    }

    public int getVersion() {
        return this.encryptedData.h();
    }

    public AlgorithmIdentifier getEncryptionAlgorithm() {
        return this.encryptedData.j();
    }

    public Attributes getUnprotectedAttributes() {
        return this.encryptedData.k();
    }

    public void setCancelled() {
        this.cancelled = true;
        if (this.in instanceof da) {
            ((da)((Object)this.in)).setCancelled();
        }
    }
}

