/*
 * Decompiled with CFR 0.152.
 */
package au.gov.bafcsi.clapi.crypto.symmetriccipher;

import au.gov.bafcsi.clapi.crypto.symmetriccipher.c0;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.RC2ParameterSpec;

public final class Rc2
extends c0 {
    public static final int BLOCK_SIZE = 8;
    private static final int[] S_BOX = new int[]{217, 120, 249, 196, 25, 221, 181, 237, 40, 233, 253, 121, 74, 160, 216, 157, 198, 126, 55, 131, 43, 118, 83, 142, 98, 76, 100, 136, 68, 139, 251, 162, 23, 154, 89, 245, 135, 179, 79, 19, 97, 69, 109, 141, 9, 129, 125, 50, 189, 143, 64, 235, 134, 183, 123, 11, 240, 149, 33, 34, 92, 107, 78, 130, 84, 214, 101, 147, 206, 96, 178, 28, 115, 86, 192, 20, 167, 140, 241, 220, 18, 117, 202, 31, 59, 190, 228, 209, 66, 61, 212, 48, 163, 60, 182, 38, 111, 191, 14, 218, 70, 105, 7, 87, 39, 242, 29, 155, 188, 148, 67, 3, 248, 17, 199, 246, 144, 239, 62, 231, 6, 195, 213, 47, 200, 102, 30, 215, 8, 232, 234, 222, 128, 82, 238, 247, 132, 170, 114, 172, 53, 77, 106, 42, 150, 26, 210, 113, 90, 21, 73, 116, 75, 159, 208, 94, 4, 24, 164, 236, 194, 224, 65, 110, 15, 81, 203, 204, 36, 145, 175, 80, 161, 244, 112, 57, 153, 124, 58, 133, 35, 184, 180, 122, 252, 2, 54, 91, 37, 85, 151, 49, 45, 93, 250, 152, 227, 138, 146, 174, 5, 223, 41, 16, 103, 108, 186, 201, 211, 0, 230, 207, 225, 158, 168, 44, 99, 22, 1, 63, 88, 226, 137, 169, 13, 56, 52, 27, 171, 51, 255, 176, 187, 72, 12, 95, 185, 177, 205, 46, 197, 243, 219, 71, 229, 165, 156, 119, 10, 166, 32, 104, 254, 127, 193, 173};
    private final int[] m_sessionKey = new int[64];
    private boolean m_decrypt;

    public Rc2() {
        super("RC2", 8);
    }

    protected void engineInit(int n10, Key key, AlgorithmParameters algorithmParameters, SecureRandom secureRandom) throws InvalidKeyException, InvalidAlgorithmParameterException {
        try {
            Object t2 = algorithmParameters.getParameterSpec(RC2ParameterSpec.class);
            this.engineInit(n10, key, (AlgorithmParameterSpec)t2, secureRandom);
        }
        catch (InvalidParameterSpecException invalidParameterSpecException) {
            super.engineInit(n10, key, algorithmParameters, secureRandom);
        }
    }

    protected final void engineInit(int n10, Key key, AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidKeyException, InvalidAlgorithmParameterException {
        AlgorithmParameterSpec algorithmParameterSpec2;
        if (algorithmParameterSpec instanceof IvParameterSpec) {
            algorithmParameterSpec2 = algorithmParameterSpec;
        } else if (algorithmParameterSpec instanceof RC2ParameterSpec) {
            RC2ParameterSpec rC2ParameterSpec = null;
            rC2ParameterSpec = (RC2ParameterSpec)algorithmParameterSpec;
            algorithmParameterSpec2 = new IvParameterSpec(rC2ParameterSpec.getIV());
        } else {
            throw new InvalidAlgorithmParameterException("The Cipher " + this.getClass().getName() + " only accepts" + " AlgorithmParameter's of type IvParameterSpec or" + " RC2ParameterSpec. The AlgorithmParameter passed in was" + " of type " + algorithmParameterSpec.getClass().getName());
        }
        super.engineInit(n10, key, algorithmParameterSpec2, secureRandom);
    }

    protected void coreInit(Key key, boolean bl2) throws InvalidKeyException {
        this.makeKey(key);
        this.m_decrypt = bl2;
    }

    protected void coreCrypt(byte[] byArray, int n10, byte[] byArray2, int n11) {
        if (this.m_decrypt) {
            this.blockDecrypt(byArray, n10, byArray2, n11);
        } else {
            this.blockEncrypt(byArray, n10, byArray2, n11);
        }
    }

    private void makeKey(Key key) throws InvalidKeyException {
        int n10;
        byte[] byArray = key.getEncoded();
        if (byArray == null) {
            throw new InvalidKeyException("Null RC2 user key");
        }
        int n11 = byArray.length;
        if (n11 > 128) {
            throw new InvalidKeyException("Invalid RC2 user key size");
        }
        int[] nArray = new int[128];
        for (n10 = 0; n10 < n11; ++n10) {
            nArray[n10] = byArray[n10] & 0xFF;
        }
        for (n10 = n11; n10 < 128; ++n10) {
            nArray[n10] = S_BOX[nArray[n10 - n11] + nArray[n10 - 1] & 0xFF];
        }
        nArray[128 - n11] = S_BOX[nArray[128 - n11] & 0xFF];
        for (n10 = 127 - n11; n10 >= 0; --n10) {
            nArray[n10] = S_BOX[nArray[n10 + n11] ^ nArray[n10 + 1]];
        }
        for (n10 = 63; n10 >= 0; --n10) {
            this.m_sessionKey[n10] = (nArray[n10 * 2 + 1] << 8 | nArray[n10 * 2]) & 0xFFFF;
        }
    }

    private void blockEncrypt(byte[] byArray, int n10, byte[] byArray2, int n11) {
        int n12 = byArray[n10++] & 0xFF | (byArray[n10++] & 0xFF) << 8;
        int n13 = byArray[n10++] & 0xFF | (byArray[n10++] & 0xFF) << 8;
        int n14 = byArray[n10++] & 0xFF | (byArray[n10++] & 0xFF) << 8;
        int n15 = byArray[n10++] & 0xFF | (byArray[n10] & 0xFF) << 8;
        int n16 = 0;
        for (int i10 = 0; i10 < 16; ++i10) {
            n12 = n12 + (n13 & ~n15) + (n14 & n15) + this.m_sessionKey[n16++] & 0xFFFF;
            n12 = n12 << 1 | n12 >>> 15;
            n13 = n13 + (n14 & ~n12) + (n15 & n12) + this.m_sessionKey[n16++] & 0xFFFF;
            n13 = n13 << 2 | n13 >>> 14;
            n14 = n14 + (n15 & ~n13) + (n12 & n13) + this.m_sessionKey[n16++] & 0xFFFF;
            n14 = n14 << 3 | n14 >>> 13;
            n15 = n15 + (n12 & ~n14) + (n13 & n14) + this.m_sessionKey[n16++] & 0xFFFF;
            n15 = n15 << 5 | n15 >>> 11;
            if (i10 != 4 && i10 != 10) continue;
            n14 += this.m_sessionKey[(n13 += this.m_sessionKey[(n12 += this.m_sessionKey[n15 & 0x3F]) & 0x3F]) & 0x3F];
            n15 += this.m_sessionKey[n14 & 0x3F];
        }
        byArray2[n11++] = (byte)n12;
        byArray2[n11++] = (byte)(n12 >>> 8);
        byArray2[n11++] = (byte)n13;
        byArray2[n11++] = (byte)(n13 >>> 8);
        byArray2[n11++] = (byte)n14;
        byArray2[n11++] = (byte)(n14 >>> 8);
        byArray2[n11++] = (byte)n15;
        byArray2[n11] = (byte)(n15 >>> 8);
    }

    private void blockDecrypt(byte[] byArray, int n10, byte[] byArray2, int n11) {
        int n12 = byArray[n10 + 0] & 0xFF | (byArray[n10 + 1] & 0xFF) << 8;
        int n13 = byArray[n10 + 2] & 0xFF | (byArray[n10 + 3] & 0xFF) << 8;
        int n14 = byArray[n10 + 4] & 0xFF | (byArray[n10 + 5] & 0xFF) << 8;
        int n15 = byArray[n10 + 6] & 0xFF | (byArray[n10 + 7] & 0xFF) << 8;
        int n16 = 63;
        for (int i10 = 15; i10 >= 0; --i10) {
            n15 = (n15 >>> 5 | n15 << 11) & 0xFFFF;
            n15 = n15 - (n12 & ~n14) - (n13 & n14) - this.m_sessionKey[n16--] & 0xFFFF;
            n14 = (n14 >>> 3 | n14 << 13) & 0xFFFF;
            n14 = n14 - (n15 & ~n13) - (n12 & n13) - this.m_sessionKey[n16--] & 0xFFFF;
            n13 = (n13 >>> 2 | n13 << 14) & 0xFFFF;
            n13 = n13 - (n14 & ~n12) - (n15 & n12) - this.m_sessionKey[n16--] & 0xFFFF;
            n12 = (n12 >>> 1 | n12 << 15) & 0xFFFF;
            n12 = n12 - (n13 & ~n15) - (n14 & n15) - this.m_sessionKey[n16--] & 0xFFFF;
            if (i10 != 11 && i10 != 5) continue;
            n15 = n15 - this.m_sessionKey[n14 & 0x3F] & 0xFFFF;
            n14 = n14 - this.m_sessionKey[n13 & 0x3F] & 0xFFFF;
            n13 = n13 - this.m_sessionKey[n12 & 0x3F] & 0xFFFF;
            n12 = n12 - this.m_sessionKey[n15 & 0x3F] & 0xFFFF;
        }
        byArray2[n11++] = (byte)n12;
        byArray2[n11++] = (byte)(n12 >>> 8);
        byArray2[n11++] = (byte)n13;
        byArray2[n11++] = (byte)(n13 >>> 8);
        byArray2[n11++] = (byte)n14;
        byArray2[n11++] = (byte)(n14 >>> 8);
        byArray2[n11++] = (byte)n15;
        byArray2[n11] = (byte)(n15 >>> 8);
    }
}

