/*
 * Decompiled with CFR 0.152.
 */
package au.gov.bafcsi.clapi.crypto;

import au.gov.bafcsi.clapi.asn1.a7;
import au.gov.bafcsi.clapi.asn1.a8;
import au.gov.bafcsi.clapi.asn1.ax;
import au.gov.bafcsi.clapi.asn1.az;
import au.gov.bafcsi.clapi.asn1.b1;
import au.gov.bafcsi.clapi.asn1.bc;
import au.gov.bafcsi.clapi.asn1.bh;
import au.gov.bafcsi.clapi.asn1.bm;
import au.gov.bafcsi.clapi.asn1.bt;
import au.gov.bafcsi.clapi.asn1.coders.CoderException;
import au.gov.bafcsi.clapi.common.AlgorithmIdentifier;
import au.gov.bafcsi.clapi.common.Oids;
import au.gov.bafcsi.clapi.crypto.CsiCertificate;
import au.gov.bafcsi.clapi.packaging.cms.SignedCmsInputStream;
import au.gov.bafcsi.clapi.packaging.cms.full.CertificateSet;
import au.gov.bafcsi.common.ByteArray;
import au.gov.bafcsi.common.utils.r;
import au.gov.bafcsi.common.utils.w;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.Principal;
import java.security.PublicKey;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;

public final class CertificateCollection {
    private List internalList = Collections.synchronizedList(new LinkedList());

    public CertificateCollection() {
    }

    public CertificateCollection(CsiCertificate csiCertificate) {
        if (csiCertificate == null) {
            throw new IllegalArgumentException("CertificateCollection(CsiCertificate) - The supplied CsiCertificate is null.");
        }
        this.addCertificate(csiCertificate);
    }

    public CertificateCollection(CsiCertificate[] csiCertificateArray) {
        if (csiCertificateArray == null) {
            throw new IllegalArgumentException("CertificateCollection(CsiCertificate[]) - The supplied CsiCertificate[] is null.");
        }
        this.addAll(csiCertificateArray);
    }

    private CertificateCollection(List list) {
        if (list == null) {
            throw new IllegalArgumentException("CertificateCollection(Linkedlist) - The supplied LinkedList is null.");
        }
        this.internalList = Collections.synchronizedList(list);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(X509Certificate x509Certificate) {
        byte[] byArray = null;
        ByteArray byteArray = null;
        CsiCertificate csiCertificate = null;
        try {
            csiCertificate = new CsiCertificate(x509Certificate);
            byArray = csiCertificate.getFingerprint(Oids.sha1);
        }
        catch (CertificateEncodingException certificateEncodingException) {
            return this.internalList.contains(csiCertificate);
        }
        byteArray = new ByteArray(byArray);
        List list = this.internalList;
        synchronized (list) {
            Iterator iterator = this.internalList.iterator();
            while (iterator.hasNext()) {
                byte[] byArray2 = null;
                try {
                    byArray2 = ((CsiCertificate)iterator.next()).getFingerprint(Oids.sha1);
                    if (!byteArray.equals(byArray2)) continue;
                    return true;
                }
                catch (CertificateEncodingException certificateEncodingException) {
                }
            }
        }
        return false;
    }

    public void addAll(CertificateCollection certificateCollection) {
        Iterator iterator = certificateCollection.iterator();
        while (iterator.hasNext()) {
            this.addCertificate((CsiCertificate)iterator.next());
        }
    }

    public void addAll(CsiCertificate[] csiCertificateArray) {
        if (csiCertificateArray != null && csiCertificateArray.length > 0) {
            for (int i10 = 0; i10 < csiCertificateArray.length; ++i10) {
                this.addCertificate(csiCertificateArray[i10]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCertificate(CsiCertificate csiCertificate) {
        if (csiCertificate == null) {
            return;
        }
        boolean bl2 = true;
        List list = this.internalList;
        synchronized (list) {
            ListIterator listIterator = this.internalList.listIterator();
            while (listIterator.hasNext()) {
                CsiCertificate csiCertificate2 = (CsiCertificate)listIterator.next();
                if (csiCertificate2.getStoreType() == null || csiCertificate.getStoreType() == null || !csiCertificate.getStoreType().equals(csiCertificate2.getStoreType()) || !csiCertificate.equals(csiCertificate2)) continue;
                bl2 = false;
            }
        }
        if (bl2) {
            list = this.internalList;
            synchronized (list) {
                this.internalList.add(csiCertificate);
            }
        }
    }

    public CsiCertificate getCertificate(int n10) {
        return (CsiCertificate)this.internalList.get(n10);
    }

    public Iterator iterator() {
        return this.internalList.iterator();
    }

    public int size() {
        return this.internalList.size();
    }

    public boolean isEmpty() {
        return this.internalList.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CsiCertificate[] getOrderedCertificateChain() {
        CsiCertificate[] csiCertificateArray = new CsiCertificate[this.size()];
        int n10 = 0;
        List list = this.internalList;
        synchronized (list) {
            ListIterator listIterator = this.internalList.listIterator();
            while (listIterator.hasNext()) {
                csiCertificateArray[n10++] = (CsiCertificate)listIterator.next();
            }
        }
        return csiCertificateArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CsiCertificate getIssuerCertificate(CsiCertificate csiCertificate) {
        if (csiCertificate.isSelfSignedCertificate()) {
            return null;
        }
        Principal principal = csiCertificate.getIssuerDN();
        List list = this.internalList;
        synchronized (list) {
            Iterator iterator = this.internalList.iterator();
            while (iterator.hasNext()) {
                CsiCertificate csiCertificate2 = (CsiCertificate)iterator.next();
                if (!((Object)csiCertificate2.getSubjectDN()).equals(principal)) continue;
                if (csiCertificate2.isSelfSignedCertificate() && csiCertificate2.isUserCertificate()) {
                    return null;
                }
                return csiCertificate2;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isCertificateChainValid() {
        if (this.internalList.size() == 0) {
            return false;
        }
        List list = this.internalList;
        synchronized (list) {
            for (int i10 = 1; i10 < this.internalList.size(); ++i10) {
                if (this.chainSegmentIsValid((CsiCertificate)this.internalList.get(i10), (CsiCertificate)this.internalList.get(i10 - 1), i10)) continue;
                return false;
            }
        }
        return true;
    }

    public CertificateCollection getCertificateChain(CsiCertificate csiCertificate) {
        CsiCertificate csiCertificate2;
        CertificateCollection certificateCollection = new CertificateCollection();
        certificateCollection.addCertificate(csiCertificate);
        CsiCertificate csiCertificate3 = csiCertificate;
        while ((csiCertificate2 = this.getIssuerCertificate(csiCertificate3)) != null && this.chainSegmentIsValid(csiCertificate2, csiCertificate3, certificateCollection.size())) {
            certificateCollection.addCertificate(csiCertificate2);
            if (((Object)csiCertificate2.getSubjectDN()).equals(csiCertificate2.getIssuerDN())) break;
            csiCertificate3 = csiCertificate2;
        }
        return certificateCollection;
    }

    private boolean chainSegmentIsValid(CsiCertificate csiCertificate, CsiCertificate csiCertificate2, int n10) {
        PublicKey publicKey = csiCertificate.getPublicKey();
        try {
            csiCertificate2.verify(publicKey);
        }
        catch (Exception exception) {
            r.a(w.i, "CertificateCollection.chainSegmentIsValid(): Certificate signature could not be verified in the certificate chain.\nSigner certificate = " + ((Object)csiCertificate.getSubjectDN()).toString() + ".\n" + "Subordinate certificate = " + ((Object)csiCertificate2.getSubjectDN()).toString() + ".\n" + "Error = " + exception.getMessage());
            return false;
        }
        boolean[] blArray = csiCertificate.getKeyUsage();
        if (blArray != null && !blArray[5]) {
            r.a(w.i, "CertificateCollection.chainSegmentIsValid(): CA key usage was violated in the certificate chain.\nSigner certificate = " + ((Object)csiCertificate.getSubjectDN()).toString() + " (KeyUsage = " + csiCertificate.getKeyUsageString() + ").");
            return false;
        }
        if (csiCertificate.getBasicConstraints() < n10 - 1) {
            r.a(w.i, "CertificateCollection.chainSegmentIsValid(): BasicConstraints was violated in the certificate chain.\nSigner certificate = " + ((Object)csiCertificate.getSubjectDN()).toString() + " (BasicConstraints = " + csiCertificate.getBasicConstraints() + ").\n" + "Certificate chain length below this signer excluding end-user cert = " + (n10 - 1));
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CsiCertificate getCertificateByIssuer(Principal principal) {
        List list = this.internalList;
        synchronized (list) {
            Iterator iterator = this.internalList.iterator();
            while (iterator.hasNext()) {
                CsiCertificate csiCertificate = (CsiCertificate)iterator.next();
                if (!((Object)csiCertificate.getIssuerDN()).equals(principal)) continue;
                return csiCertificate;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CsiCertificate getCertificate(Principal principal) {
        List list = this.internalList;
        synchronized (list) {
            Iterator iterator = this.internalList.iterator();
            while (iterator.hasNext()) {
                CsiCertificate csiCertificate = (CsiCertificate)iterator.next();
                if (!((Object)csiCertificate.getSubjectDN()).equals(principal)) continue;
                if (((Object)csiCertificate.getIssuerDN()).equals(principal) && csiCertificate.getBasicConstraints() == -1) {
                    return null;
                }
                return csiCertificate;
            }
        }
        return null;
    }

    public static ByteArray toP7C(CertificateCollection certificateCollection) throws IOException {
        az az2 = new az();
        az2.a((ax)new bh(Oids.data), "a");
        az az3 = new az();
        az3.a((ax)new a7(1L), "b");
        az3.a((ax)new bt(AlgorithmIdentifier.class), "c");
        az3.a((ax)az2, "d");
        az3.a((ax)new bm(new b1(new CertificateSet(certificateCollection), 0)), "e");
        az3.a((ax)new bt(a7.class), "f");
        az az4 = new az();
        az4.a((ax)new bh(Oids.signedData), "g");
        az4.a((ax)new a8(az3, 0), "h");
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            bc bc2 = az4.encode(byteArrayOutputStream);
            bc2.flush();
            bc2.close();
        }
        catch (CoderException coderException) {
            throw new IOException("CertificateCollection.toP7C(OutputStream) - " + coderException.getMessage());
        }
        return new ByteArray(byteArrayOutputStream.toByteArray());
    }

    public static CertificateCollection fromP7C(ByteArray byteArray) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArray.getBytes());
        SignedCmsInputStream signedCmsInputStream = new SignedCmsInputStream(byteArrayInputStream);
        CertificateCollection certificateCollection = signedCmsInputStream.getCertificates();
        signedCmsInputStream.close();
        return certificateCollection;
    }

    public CertificateCollection sortedList() {
        LinkedList linkedList = new LinkedList();
        linkedList.addAll(this.internalList);
        Collections.sort(linkedList);
        return new CertificateCollection(linkedList);
    }

    public CertificateCollection filterOnAbn(String string) {
        if (string == null || this.size() < 1) {
            return this;
        }
        CertificateCollection certificateCollection = new CertificateCollection();
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            CsiCertificate csiCertificate = (CsiCertificate)iterator.next();
            if (!string.equals(csiCertificate.getAbn())) continue;
            certificateCollection.addCertificate(csiCertificate);
        }
        return certificateCollection;
    }

    public Collection getInternalCollection() {
        return this.internalList;
    }

    protected CertificateCollection copyByUsage(int n10) {
        CertificateCollection certificateCollection = new CertificateCollection();
        Iterator iterator = this.internalList.iterator();
        while (iterator.hasNext()) {
            CsiCertificate csiCertificate = (CsiCertificate)iterator.next();
            if (!csiCertificate.getKeyUsage()[n10]) continue;
            certificateCollection.addCertificate(csiCertificate);
        }
        return certificateCollection;
    }
}

