/*
 * Decompiled with CFR 0.152.
 */
package au.gov.bafcsi.clapi.certs;

import au.gov.bafcsi.clapi.asn1.bq;
import au.gov.bafcsi.clapi.certs.Extension;
import au.gov.bafcsi.clapi.certs.extensions.BasicConstraints;
import au.gov.bafcsi.clapi.certs.extensions.KeyUsage;
import au.gov.bafcsi.clapi.common.ExtensionOid;
import au.gov.bafcsi.clapi.common.Oid;
import au.gov.bafcsi.clapi.common.Oids;
import java.security.cert.CertificateException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public final class Extensions
extends bq {
    public Extensions() {
        super(Extension.class);
    }

    public void addExtension(Extension extension) {
        if (extension == null) {
            throw new IllegalArgumentException("Extensions.addExtension(Extension) - The supplied Extension is null.");
        }
        this.a(extension);
    }

    public boolean hasUnsupportedCriticalExtension() {
        return false;
    }

    public Set getNonCriticalExtensionOIDs() {
        HashSet<String> hashSet = new HashSet<String>();
        Iterator iterator = this.a();
        while (iterator.hasNext()) {
            Extension extension = (Extension)iterator.next();
            if (extension.getCritical()) continue;
            hashSet.add(extension.getExtensionOID().toString());
        }
        return hashSet;
    }

    public Set getCriticalExtensionOIDs() {
        HashSet<String> hashSet = new HashSet<String>();
        Iterator iterator = this.a();
        while (iterator.hasNext()) {
            Extension extension = (Extension)iterator.next();
            if (!extension.getCritical()) continue;
            hashSet.add(extension.getExtensionOID().toString());
        }
        return hashSet;
    }

    public byte[] getExtensionValue(ExtensionOid extensionOid) {
        Iterator iterator = this.a();
        while (iterator.hasNext()) {
            Extension extension = (Extension)iterator.next();
            if (!extension.getExtensionOID().equals(extensionOid)) continue;
            return extension.getExtensionValue().getDefensiveBytes();
        }
        return null;
    }

    public boolean[] getKeyUsage() throws CertificateException {
        Iterator iterator = this.a();
        while (iterator.hasNext()) {
            Extension extension = (Extension)iterator.next();
            if (!extension.getExtensionOID().equals(Oids.keyUsage)) continue;
            return new KeyUsage(extension.getExtensionValue()).getKeyUsage();
        }
        return null;
    }

    public int getBasicConstraints() throws CertificateException {
        Iterator iterator = this.a();
        while (iterator.hasNext()) {
            Extension extension = (Extension)iterator.next();
            if (!extension.getExtensionOID().equals(Oids.basicConstraints)) continue;
            return new BasicConstraints(extension.getExtensionValue()).getPathLengthConstraint();
        }
        return -1;
    }

    public void removeExtension(Oid oid) {
        if (oid == null) {
            throw new IllegalArgumentException("Extensions.removeExtension(Oid) - The supplied Oid is null.");
        }
        Iterator iterator = this.a();
        while (iterator.hasNext()) {
            Extension extension = (Extension)iterator.next();
            if (!extension.getExtensionOID().equals(oid)) continue;
            this.b(extension);
        }
    }
}

